/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.web.data.resource;

import java.io.Serializable;
import java.util.Date;
import javax.xml.namespace.QName;
import org.apache.wicket.Component;
import org.apache.wicket.Page;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;
import org.apache.wicket.util.tester.FormTester;
import org.geoserver.catalog.DimensionInfo;
import org.geoserver.catalog.DimensionPresentation;
import org.geoserver.catalog.FeatureTypeInfo;
import org.geoserver.catalog.ResourceInfo;
import org.geoserver.data.test.MockData;
import org.geoserver.data.test.SystemTestData;
import org.geoserver.web.FormTestPage;
import org.geoserver.web.GeoServerWicketTestSupport;
import org.geoserver.web.data.resource.DimensionEditor;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class DimensionEditorTest
extends GeoServerWicketTestSupport {
    private static final QName V_TIME_ELEVATION = new QName(MockData.SF_URI, "TimeElevation", MockData.SF_PREFIX);

    @Override
    protected void onSetUp(SystemTestData testData) throws Exception {
        super.onSetUp(testData);
        testData.addVectorLayer(V_TIME_ELEVATION, this.getCatalog());
    }

    @Before
    public void resetDimensions() {
        this.setupVectorDimension(V_TIME_ELEVATION.getLocalPart(), "time", "time", DimensionPresentation.LIST, null, null, null);
        this.setupNearestMatch(V_TIME_ELEVATION, "time", true, "PT10M", DimensionInfo.NearestFailBehavior.EXCEPTION, false);
        this.setupVectorDimension(V_TIME_ELEVATION.getLocalPart(), "elevation", "elevation", DimensionPresentation.LIST, null, null, null);
    }

    @Test
    public void testEditVectorTime() throws Exception {
        FeatureTypeInfo ft = this.getCatalog().getFeatureTypeByName(this.getLayerId(V_TIME_ELEVATION));
        DimensionInfo time = (DimensionInfo)ft.getMetadata().get("time", DimensionInfo.class);
        Model timeModel = new Model((Serializable)time);
        tester.startPage((Page)new FormTestPage(id -> new DimensionEditor(id, (IModel)timeModel, (ResourceInfo)ft, Date.class, true, false)));
        this.print((Component)tester.getLastRenderedPage(), true, true);
        String prefix = "form:panel:configContainer:configs:";
        tester.assertModelValue(prefix + "attributeContainer:attribute", (Object)"time");
        tester.assertModelValue(prefix + "attributeContainer:endAttribute", null);
        tester.assertModelValue(prefix + "presentation", (Object)DimensionPresentation.LIST);
        tester.assertInvisible(prefix + "resolutionContainer:resolutions");
        tester.assertModelValue(prefix + "nearestMatchContainer:nearestMatchEnabled", (Object)true);
        tester.assertModelValue(prefix + "nearestMatchContainer:acceptableIntervalEditor:acceptableInterval", (Object)"PT10M");
        tester.assertModelValue(prefix + "nearestMatchContainer:failedMatchBehaviorContainer:nearestFailBehavior", (Object)DimensionInfo.NearestFailBehavior.EXCEPTION);
        FormTester form = tester.newFormTester("form");
        String formPrefix = "panel:configContainer:configs:";
        form.select(formPrefix + "nearestMatchContainer:failedMatchBehaviorContainer:nearestFailBehavior", 0);
        form.submit();
        Assert.assertEquals((Object)DimensionInfo.NearestFailBehavior.IGNORE, (Object)time.getNearestFailBehavior());
    }

    @Test
    public void testEditVectorElevation() throws Exception {
        FeatureTypeInfo ft = this.getCatalog().getFeatureTypeByName(this.getLayerId(V_TIME_ELEVATION));
        DimensionInfo elevation = (DimensionInfo)ft.getMetadata().get("elevation", DimensionInfo.class);
        Model elevationModel = new Model((Serializable)elevation);
        tester.startPage((Page)new FormTestPage(id -> new DimensionEditor(id, (IModel)elevationModel, (ResourceInfo)ft, Double.class, false, false)));
        this.print((Component)tester.getLastRenderedPage(), true, true);
        String prefix = "form:panel:configContainer:configs:";
        tester.assertModelValue(prefix + "attributeContainer:attribute", (Object)"elevation");
        tester.assertModelValue(prefix + "attributeContainer:endAttribute", null);
        tester.assertModelValue(prefix + "presentation", (Object)DimensionPresentation.LIST);
        tester.assertInvisible(prefix + "resolutionContainer:resolutions");
        tester.assertInvisible(prefix + "nearestMatchContainer");
    }

    @Test
    public void testStartValueErrorMessageWithDateRange() throws Exception {
        FeatureTypeInfo ft = this.getCatalog().getFeatureTypeByName(this.getLayerId(V_TIME_ELEVATION));
        DimensionInfo time = (DimensionInfo)ft.getMetadata().get("time", DimensionInfo.class);
        Model timeModel = new Model((Serializable)time);
        tester.startPage((Page)new FormTestPage(id -> new DimensionEditor(id, (IModel)timeModel, (ResourceInfo)ft, Date.class, true, false)));
        this.print((Component)tester.getLastRenderedPage(), true, true);
        FormTester form = tester.newFormTester("form");
        String formPrefix = "panel:configContainer:configs:";
        form.setValue(formPrefix + "startEndContainer:startValue", "invalid-date-format");
        form.submit();
        tester.assertErrorMessages(new Serializable[]{"Start data range value must be an ISO8601 DateTime or a construct like 'PRESENT'"});
    }
}

