/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.web.data.layergroup;

import java.util.ArrayList;
import java.util.Collections;
import org.apache.wicket.markup.repeater.data.DataView;
import org.geoserver.catalog.LayerGroupInfo;
import org.geoserver.config.GeoServerInfo;
import org.geoserver.data.test.SystemTestData;
import org.geoserver.web.data.layergroup.LayerGroupBaseTest;
import org.geoserver.web.data.layergroup.LayerGroupPage;
import org.geoserver.web.data.layergroup.LayerGroupProvider;
import org.junit.Assert;
import org.junit.Test;

public class LayerGroupPageTest
extends LayerGroupBaseTest {
    @Override
    protected void onSetUp(SystemTestData testData) throws Exception {
        super.onSetUp(testData);
        this.login();
        tester.startPage(LayerGroupPage.class);
    }

    @Test
    public void testLoad() {
        tester.assertRenderedPage(LayerGroupPage.class);
        tester.assertNoErrorMessage();
        DataView dv = (DataView)tester.getComponentFromLastRenderedPage("table:listContainer:items");
        Assert.assertEquals((long)this.getCatalog().getLayerGroups().size(), (long)dv.size());
        LayerGroupInfo lg = (LayerGroupInfo)dv.getDataProvider().iterator(0L, 1L).next();
        ArrayList groups = new ArrayList(this.getCatalog().getLayerGroups());
        Collections.sort(groups, (g1, g2) -> g1.getName().compareTo(g2.getName()));
        Assert.assertEquals(groups.get(0), (Object)lg);
    }

    @Test
    public void testTimeColumnsToggle() {
        GeoServerInfo info = this.getGeoServerApplication().getGeoServer().getGlobal();
        info.getSettings().setShowCreatedTimeColumnsInAdminList(true);
        info.getSettings().setShowModifiedTimeColumnsInAdminList(true);
        this.getGeoServerApplication().getGeoServer().save(info);
        this.login();
        tester.assertRenderedPage(LayerGroupPage.class);
        tester.assertNoErrorMessage();
        DataView dv = (DataView)tester.getComponentFromLastRenderedPage("table:listContainer:items");
        LayerGroupProvider provider = (LayerGroupProvider)dv.getDataProvider();
        Assert.assertTrue((boolean)provider.getProperties().contains(LayerGroupProvider.CREATED_TIMESTAMP));
        Assert.assertTrue((boolean)provider.getProperties().contains(LayerGroupProvider.MODIFIED_TIMESTAMP));
    }
}

