/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.web.data.layer;

import java.io.IOException;
import java.io.Serializable;
import java.sql.Connection;
import java.sql.SQLException;
import org.apache.wicket.Component;
import org.apache.wicket.Page;
import org.apache.wicket.util.tester.FormTester;
import org.geoserver.catalog.FeatureTypeInfo;
import org.geoserver.web.data.layer.AbstractSqlViewPageTest;
import org.geoserver.web.data.layer.SQLViewEditPage;
import org.geotools.jdbc.JDBCDataStore;
import org.geotools.jdbc.SQLDialect;
import org.geotools.jdbc.VirtualTable;
import org.geotools.jdbc.VirtualTableParameter;
import org.junit.Assert;
import org.junit.Test;
import org.locationtech.jts.geom.Polygon;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

public class SqlViewEditPageTest
extends AbstractSqlViewPageTest {
    @Test
    public void testSqlViewManyParameters() throws IOException {
        this.login();
        StringBuilder sb = new StringBuilder("SELECT * FROM \"Forests\" WHERE \n");
        int LOOPS = 50;
        for (int i = 0; i < 50; ++i) {
            sb.append("name = '%PARAM").append(i + 1).append("%'");
            if (i < 49) {
                sb.append(" OR ");
            }
            sb.append("\n");
        }
        FeatureTypeInfo info = this.getCatalog().getFeatureTypeByName("Forests");
        VirtualTable vt = new VirtualTable("test", sb.toString());
        for (int i = 0; i < 50; ++i) {
            vt.addParameter(new VirtualTableParameter("PARAM" + (i + 1), "abc"));
        }
        info.getMetadata().put("JDBC_VIRTUAL_TABLE", (Serializable)vt);
        tester.startPage((Page)new SQLViewEditPage(info, null));
        tester.assertRenderedPage(SQLViewEditPage.class);
        tester.assertNoErrorMessage();
        Component component = tester.getComponentFromLastRenderedPage("form:parameters:listContainer:items:49");
        Assert.assertNotNull((Object)component);
    }

    @Test
    public void testSqlViewConnectionLeak() throws IOException, SQLException {
        this.login();
        FeatureTypeInfo info = this.getCatalog().getFeatureTypeByName("Forests");
        VirtualTable vt = new VirtualTable("test", "SELECT * FROM \"Forests\"");
        info.getMetadata().put("JDBC_VIRTUAL_TABLE", (Serializable)vt);
        FeatureTypeInfo ft = info;
        JDBCDataStore store = (JDBCDataStore)ft.getStore().getDataStore(null);
        SQLDialect spy = (SQLDialect)Mockito.spy((Object)store.getSQLDialect());
        ((SQLDialect)Mockito.doReturn(Polygon.class).when((Object)spy)).getMapping("VARBINARY");
        store.setSQLDialect(spy);
        tester.startPage((Page)new SQLViewEditPage(ft, null));
        tester.assertRenderedPage(SQLViewEditPage.class);
        tester.assertNoErrorMessage();
        FormTester formTester = tester.newFormTester("form");
        formTester.setValue("guessGeometrySrid", true);
        int LOOPS = 100;
        for (int i = 0; i < 100; ++i) {
            tester.executeAjaxEvent("form:refresh", "click");
        }
        ((SQLDialect)Mockito.verify((Object)spy, (VerificationMode)Mockito.atLeast((int)50))).createCRS(ArgumentMatchers.anyInt(), (Connection)ArgumentMatchers.notNull());
    }
}

