/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.web.admin;

import com.sun.media.jai.mlib.MlibWarpRIF;
import com.sun.media.jai.opimage.WarpRIF;
import it.geosolutions.jaiext.JAIExt;
import java.util.Collection;
import java.util.Set;
import org.apache.wicket.extensions.markup.html.form.palette.Palette;
import org.apache.wicket.markup.html.form.TextField;
import org.apache.wicket.util.tester.FormTester;
import org.geoserver.config.GeoServer;
import org.geoserver.config.GeoServerInfo;
import org.geoserver.config.JAIEXTInfo;
import org.geoserver.config.JAIInfo;
import org.geoserver.web.GeoServerHomePage;
import org.geoserver.web.GeoServerWicketTestSupport;
import org.geoserver.web.admin.JAIEXTPanel;
import org.geoserver.web.admin.JAIPage;
import org.geotools.image.ImageWorker;
import org.geotools.image.util.ImageUtilities;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class JAIPageTest
extends GeoServerWicketTestSupport {
    private GeoServer geoServer;

    @Before
    public void reset() {
        this.geoServer = this.getGeoServerApplication().getGeoServer();
        GeoServerInfo gsInfo = this.geoServer.getGlobal();
        JAIInfo jai = gsInfo.getJAI();
        jai.setTileThreads(2);
        this.geoServer.save(gsInfo);
    }

    @Test
    public void testValues() {
        JAIInfo info = this.geoServer.getGlobal().getJAI();
        this.login();
        tester.startPage(JAIPage.class);
        tester.assertComponent("form:tileThreads", TextField.class);
        tester.assertModelValue("form:tileThreads", (Object)info.getTileThreads());
    }

    @Test
    public void testSave() {
        this.login();
        tester.startPage(JAIPage.class);
        FormTester ft = tester.newFormTester("form");
        ft.setValue("tileThreads", "3");
        ft.submit("submit");
        tester.assertRenderedPage(GeoServerHomePage.class);
        JAIInfo jai = this.geoServer.getGlobal().getJAI();
        Assert.assertEquals((long)3L, (long)jai.getTileThreads());
    }

    @Test
    public void testApply() {
        this.login();
        tester.startPage(JAIPage.class);
        FormTester ft = tester.newFormTester("form");
        ft.setValue("tileThreads", "3");
        ft.submit("apply");
        tester.assertRenderedPage(JAIPage.class);
        JAIInfo jai = this.geoServer.getGlobal().getJAI();
        Assert.assertEquals((long)3L, (long)jai.getTileThreads());
    }

    @Test
    public void testNativeWarp() {
        Object factory;
        Collection jaiext;
        Palette p;
        if (!ImageUtilities.isMediaLibAvailable()) {
            Assert.assertTrue((boolean)true);
            return;
        }
        GeoServer geoServer = this.getGeoServerApplication().getGeoServer();
        GeoServerInfo global = geoServer.getGlobal();
        JAIInfo info = global.getJAI();
        Assert.assertFalse((boolean)info.isAllowNativeWarp());
        JAIExt.registerJAIDescriptor((String)"Warp");
        JAIEXTInfo jeinfo = info.getJAIEXTInfo();
        Set jeOps = jeinfo.getJAIEXTOperations();
        jeOps.remove("Warp");
        jeinfo.setJAIEXTOperations(jeOps);
        jeinfo.getJAIOperations().add("Warp");
        info.setJAIEXTInfo(jeinfo);
        global.setJAI(info);
        geoServer.save(global);
        this.login();
        tester.startPage(JAIPage.class);
        tester.assertRenderedPage(JAIPage.class);
        boolean isJAIExtEnabled = ImageWorker.isJaiExtEnabled();
        if (isJAIExtEnabled) {
            tester.assertComponent("form:jaiext", JAIEXTPanel.class);
            tester.assertComponent("form:jaiext:jaiextOps", Palette.class);
            p = (Palette)tester.getComponentFromLastRenderedPage("form:jaiext:jaiextOps");
            jaiext = p.getChoices();
            Assert.assertNotNull((Object)jaiext);
            Assert.assertFalse((boolean)jaiext.contains("Warp"));
        } else {
            tester.assertInvisible("form:jaiext");
        }
        FormTester form = tester.newFormTester("form");
        form.setValue("allowNativeWarp", true);
        form.submit("submit");
        tester.assertNoErrorMessage();
        info = global.getJAI();
        if (isJAIExtEnabled) {
            Assert.assertTrue((boolean)info.isAllowNativeWarp());
            factory = info.getJAI().getOperationRegistry().getFactory("rendered", "Warp");
            Assert.assertTrue((boolean)(factory instanceof MlibWarpRIF));
        } else {
            Assert.assertFalse((boolean)info.isAllowNativeWarp());
            factory = info.getJAI().getOperationRegistry().getFactory("rendered", "Warp");
            Assert.assertTrue((boolean)(factory instanceof WarpRIF));
        }
        tester.startPage(JAIPage.class);
        tester.assertRenderedPage(JAIPage.class);
        if (isJAIExtEnabled) {
            tester.assertComponent("form:jaiext", JAIEXTPanel.class);
            tester.assertComponent("form:jaiext:jaiextOps", Palette.class);
            p = (Palette)tester.getComponentFromLastRenderedPage("form:jaiext:jaiextOps");
            jaiext = p.getChoices();
            Assert.assertNotNull((Object)jaiext);
            Assert.assertFalse((boolean)jaiext.contains("Warp"));
        }
        form = tester.newFormTester("form");
        form.setValue("allowNativeWarp", false);
        form.submit("submit");
        tester.assertNoErrorMessage();
        info = global.getJAI();
        Assert.assertFalse((boolean)info.isAllowNativeWarp());
        factory = info.getJAI().getOperationRegistry().getFactory("rendered", "Warp");
        Assert.assertTrue((boolean)(factory instanceof WarpRIF));
    }
}

