/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.web.admin;

import java.io.IOException;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Iterator;
import org.apache.wicket.Component;
import org.apache.wicket.Page;
import org.apache.wicket.core.request.handler.RenderPageRequestHandler;
import org.apache.wicket.markup.html.form.DropDownChoice;
import org.apache.wicket.markup.repeater.Item;
import org.apache.wicket.markup.repeater.data.DataView;
import org.apache.wicket.request.cycle.RequestCycle;
import org.apache.wicket.request.mapper.parameter.PageParameters;
import org.geoserver.catalog.Catalog;
import org.geoserver.catalog.CatalogBuilder;
import org.geoserver.catalog.LayerGroupInfo;
import org.geoserver.catalog.ResourceInfo;
import org.geoserver.catalog.StoreInfo;
import org.geoserver.catalog.WorkspaceInfo;
import org.geoserver.data.test.MockData;
import org.geoserver.data.test.SystemTestData;
import org.geoserver.security.AdminRequest;
import org.geoserver.web.GeoServerWicketTestSupport;
import org.geoserver.web.UnauthorizedPage;
import org.geoserver.web.data.layer.LayerPage;
import org.geoserver.web.data.layer.NewFeatureTypePage;
import org.geoserver.web.data.layer.SQLViewNewPage;
import org.geoserver.web.data.layergroup.LayerGroupEditPage;
import org.geoserver.web.data.layergroup.LayerGroupPage;
import org.geoserver.web.data.store.DataAccessEditPage;
import org.geoserver.web.data.store.DataAccessNewPage;
import org.geoserver.web.data.store.StorePage;
import org.geoserver.web.data.workspace.WorkspaceEditPage;
import org.geoserver.web.data.workspace.WorkspaceNewPage;
import org.geoserver.web.data.workspace.WorkspacePage;
import org.geotools.data.property.PropertyDataStoreFactory;
import org.junit.After;
import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Test;

public abstract class AbstractAdminPrivilegeTest
extends GeoServerWicketTestSupport {
    @Override
    protected void onSetUp(SystemTestData testData) throws Exception {
        super.onSetUp(testData);
        this.addUser("cite", "cite", null, Arrays.asList("ROLE_CITE_ADMIN"));
        this.addUser("sf", "sf", null, Arrays.asList("ROLE_SF_ADMIN"));
        this.setupAccessRules();
        Catalog cat = this.getCatalog();
        LayerGroupInfo lg = cat.getFactory().createLayerGroup();
        lg.setName("cite_local");
        lg.setWorkspace(cat.getWorkspaceByName("cite"));
        lg.getLayers().add(cat.getLayerByName(this.getLayerId(MockData.LAKES)));
        lg.getLayers().add(cat.getLayerByName(this.getLayerId(MockData.FORESTS)));
        new CatalogBuilder(cat).calculateLayerGroupBounds(lg);
        cat.add(lg);
        lg = cat.getFactory().createLayerGroup();
        lg.setName("sf_local");
        lg.setWorkspace(cat.getWorkspaceByName("sf"));
        lg.getLayers().add(cat.getLayerByName(this.getLayerId(MockData.PRIMITIVEGEOFEATURE)));
        lg.getLayers().add(cat.getLayerByName(this.getLayerId(MockData.AGGREGATEGEOFEATURE)));
        new CatalogBuilder(cat).calculateLayerGroupBounds(lg);
        cat.add(lg);
        lg = cat.getFactory().createLayerGroup();
        lg.setName("cite_global");
        lg.getLayers().add(cat.getLayerByName(this.getLayerId(MockData.LAKES)));
        lg.getLayers().add(cat.getLayerByName(this.getLayerId(MockData.FORESTS)));
        new CatalogBuilder(cat).calculateLayerGroupBounds(lg);
        cat.add(lg);
        lg = cat.getFactory().createLayerGroup();
        lg.setName("sf_global");
        lg.getLayers().add(cat.getLayerByName(this.getLayerId(MockData.PRIMITIVEGEOFEATURE)));
        lg.getLayers().add(cat.getLayerByName(this.getLayerId(MockData.AGGREGATEGEOFEATURE)));
        new CatalogBuilder(cat).calculateLayerGroupBounds(lg);
        cat.add(lg);
    }

    protected abstract void setupAccessRules() throws IOException;

    @After
    public void finishAdminRequest() {
        AdminRequest.finish();
    }

    void loginAsCite() {
        this.login("cite", "cite", new String[]{"ROLE_CITE_ADMIN"});
    }

    void loginAsSf() {
        this.login("sf", "sf", new String[]{"ROLE_SF_ADMIN"});
    }

    @Test
    public void testWorkspaceAllPage() throws Exception {
        this.loginAsCite();
        tester.startPage(WorkspacePage.class);
        tester.assertRenderedPage(WorkspacePage.class);
        tester.assertNoErrorMessage();
        DataView dv = (DataView)tester.getComponentFromLastRenderedPage("table:listContainer:items");
        Assert.assertEquals((long)1L, (long)dv.size());
        AdminRequest.start((Object)new Object());
        Assert.assertEquals((long)1L, (long)dv.getDataProvider().size());
        WorkspaceInfo ws = (WorkspaceInfo)dv.getDataProvider().iterator(0L, 1L).next();
        Assert.assertEquals((Object)"cite", (Object)ws.getName());
    }

    @Test
    public void testWorkspaceNewPage() throws Exception {
        this.loginAsCite();
        tester.startPage(WorkspaceNewPage.class);
        tester.assertRenderedPage(UnauthorizedPage.class);
    }

    @Test
    public void testWorkspaceEditPage() throws Exception {
        this.loginAsCite();
        tester.startPage(WorkspaceEditPage.class, new PageParameters().add("name", (Object)"cite"));
        tester.assertRenderedPage(WorkspaceEditPage.class);
        tester.assertNoErrorMessage();
    }

    @Test
    public void testWorkspaceEditPageUnauthorized() throws Exception {
        this.loginAsCite();
        tester.startPage(WorkspaceEditPage.class, new PageParameters().add("name", (Object)"cdf"));
        tester.assertErrorMessages((Serializable[])new String[]{"Could not find workspace \"cdf\""});
    }

    @Test
    public void testLayerAllPage() throws Exception {
        this.loginAsCite();
        tester.startPage(LayerPage.class);
        tester.assertRenderedPage(LayerPage.class);
        this.print((Component)tester.getLastRenderedPage(), true, true, true);
        DataView dv = (DataView)tester.getComponentFromLastRenderedPage("table:listContainer:items");
        Assert.assertEquals((long)this.getCatalog().getResourcesByNamespace("cite", ResourceInfo.class).size(), (long)dv.size());
    }

    @Test
    public void testStoreAllPage() throws Exception {
        this.loginAsCite();
        tester.startPage(StorePage.class);
        tester.assertRenderedPage(StorePage.class);
        tester.assertNoErrorMessage();
        DataView dv = (DataView)tester.getComponentFromLastRenderedPage("table:listContainer:items");
        Assert.assertEquals((long)this.getCatalog().getStoresByWorkspace("cite", StoreInfo.class).size(), (long)dv.size());
    }

    @Test
    public void testStoreNewPage() throws Exception {
        this.loginAsCite();
        AdminRequest.start((Object)new Object());
        String dataStoreFactoryDisplayName = new PropertyDataStoreFactory().getDisplayName();
        tester.startPage((Page)new DataAccessNewPage(dataStoreFactoryDisplayName));
        tester.assertRenderedPage(DataAccessNewPage.class);
        tester.assertNoErrorMessage();
        AdminRequest.start((Object)new Object());
        DropDownChoice wsChoice = (DropDownChoice)tester.getComponentFromLastRenderedPage("dataStoreForm:workspacePanel:border:border_body:paramValue");
        Assert.assertEquals((long)1L, (long)wsChoice.getChoices().size());
        Assert.assertEquals((Object)"cite", (Object)((WorkspaceInfo)wsChoice.getChoices().get(0)).getName());
    }

    @Test
    public void testStoreEditPage() throws Exception {
        this.loginAsCite();
        tester.startPage(DataAccessEditPage.class, new PageParameters().add("wsName", (Object)"cite").add("storeName", (Object)"cite"));
        tester.assertRenderedPage(DataAccessEditPage.class);
        tester.assertNoErrorMessage();
    }

    @Test
    public void testStoreEditPageUnauthorized() throws Exception {
        this.loginAsCite();
        tester.startPage(DataAccessEditPage.class, new PageParameters().add("wsName", (Object)"cdf").add("storeName", (Object)"cdf"));
        tester.assertRenderedPage(StorePage.class);
        tester.assertErrorMessages((Serializable[])new String[]{"Could not find data store \"cdf\" in workspace \"cdf\""});
    }

    @Test
    public void testLayerGroupAllPageAsAdmin() throws Exception {
        this.login();
        tester.startPage(LayerGroupPage.class);
        tester.assertRenderedPage(LayerGroupPage.class);
        Catalog cat = this.getCatalog();
        DataView view = (DataView)tester.getComponentFromLastRenderedPage("table:listContainer:items");
        Assert.assertEquals((long)cat.getLayerGroups().size(), (long)view.getItemCount());
    }

    @Test
    public void testLayerGroupAllPage() {
        this.loginAsCite();
        tester.startPage(LayerGroupPage.class);
        tester.assertRenderedPage(LayerGroupPage.class);
        Catalog cat = this.getCatalog();
        DataView view = (DataView)tester.getComponentFromLastRenderedPage("table:listContainer:items");
        AdminRequest.start((Object)new Object());
        Assert.assertEquals((long)cat.getLayerGroups().size(), (long)view.getItemCount());
        Iterator it = view.getItems();
        while (it.hasNext()) {
            String name = ((Item)it.next()).get("itemProperties:0:component:link:label").getDefaultModelObjectAsString();
            Assert.assertNotEquals((Object)"sf_local", (Object)name);
        }
    }

    @Test
    public void testLayerGroupEditPageAsAdmin() throws Exception {
        this.login();
        tester.startPage(LayerGroupEditPage.class);
        tester.assertRenderedPage(LayerGroupEditPage.class);
        tester.assertModelValue("publishedinfo:tabs:panel:workspace", null);
        DropDownChoice choice = (DropDownChoice)tester.getComponentFromLastRenderedPage("publishedinfo:tabs:panel:workspace");
        Assert.assertTrue((boolean)choice.isNullValid());
        Assert.assertFalse((boolean)choice.isRequired());
    }

    @Test
    public void testLayerGroupEditPage() throws Exception {
        this.loginAsCite();
        tester.startPage(LayerGroupEditPage.class);
        tester.assertRenderedPage(LayerGroupEditPage.class);
        Catalog cat = this.getCatalog();
        tester.assertModelValue("publishedinfo:tabs:panel:workspace", (Object)cat.getWorkspaceByName("cite"));
        DropDownChoice choice = (DropDownChoice)tester.getComponentFromLastRenderedPage("publishedinfo:tabs:panel:workspace");
        Assert.assertFalse((boolean)choice.isNullValid());
        Assert.assertTrue((boolean)choice.isRequired());
    }

    @Test
    public void testLayerGroupEditPageGlobal() throws Exception {
        this.loginAsCite();
        tester.startPage(LayerGroupEditPage.class, new PageParameters().add("group", (Object)"cite_global"));
        tester.assertRenderedPage(LayerGroupEditPage.class);
        Assert.assertFalse((boolean)tester.getComponentFromLastRenderedPage("publishedinfo:tabs:panel:name").isEnabled());
        Assert.assertFalse((boolean)tester.getComponentFromLastRenderedPage("publishedinfo:tabs:panel:workspace").isEnabled());
        Assert.assertNull((Object)tester.getComponentFromLastRenderedPage("publishedinfo:save"));
        Assert.assertTrue((boolean)tester.getComponentFromLastRenderedPage("publishedinfo:cancel").isEnabled());
    }

    @Test
    @Ignore
    public void testSqlViewNewPageAsWorkspaceAdmin() throws Exception {
        this.loginAsCite();
        PageParameters pp = new PageParameters();
        pp.add("wsName", (Object)"cite");
        pp.add("storeName", (Object)"cite");
        new SQLViewNewPage(pp);
        RequestCycle cycle = RequestCycle.get();
        RenderPageRequestHandler handler = (RenderPageRequestHandler)cycle.getRequestHandlerScheduledAfterCurrent();
        Assert.assertNotEquals(UnauthorizedPage.class, (Object)handler.getPageClass());
    }

    @Test
    @Ignore
    public void testCreateNewFeatureTypePageAsWorkspaceAdmin() throws Exception {
        this.loginAsCite();
        PageParameters pp = new PageParameters();
        pp.add("wsName", (Object)"cite");
        pp.add("storeName", (Object)"cite");
        new NewFeatureTypePage(pp);
        RequestCycle cycle = RequestCycle.get();
        RenderPageRequestHandler handler = (RenderPageRequestHandler)cycle.getRequestHandlerScheduledAfterCurrent();
        Assert.assertNotEquals(UnauthorizedPage.class, (Object)handler.getPageClass());
    }
}

