/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.web;

import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.Collections;
import java.util.List;
import javax.servlet.Filter;
import javax.servlet.http.HttpServletRequest;
import org.apache.wicket.protocol.http.WebSession;
import org.geoserver.platform.GeoServerExtensions;
import org.geoserver.web.GeoServerHomePage;
import org.geoserver.web.GeoServerLoginPage;
import org.geoserver.web.GeoServerWicketTestSupport;
import org.geoserver.web.ToolPage;
import org.geoserver.web.data.layer.LayerPage;
import org.junit.Assert;
import org.junit.Test;
import org.springframework.mock.web.MockHttpServletRequest;
import org.springframework.security.web.savedrequest.SavedRequest;

public class GeoServerSecuredPageTest
extends GeoServerWicketTestSupport {
    protected List<Filter> getFilters() {
        return Collections.singletonList((Filter)GeoServerExtensions.bean((String)"filterChainProxy"));
    }

    @Test
    public void testSecuredPageGivesRedirectWhenLoggedOut() throws UnsupportedEncodingException {
        this.logout();
        tester.startPage(LayerPage.class);
        tester.assertRenderedPage(GeoServerLoginPage.class);
        SavedRequest sr = (SavedRequest)tester.getHttpSession().getAttribute("SPRING_SECURITY_SAVED_REQUEST_KEY");
        Assert.assertNotNull((Object)sr);
        String redirectUrl = URLDecoder.decode(sr.getRedirectUrl(), "UTF8");
        Assert.assertTrue((boolean)redirectUrl.contains("wicket/bookmarkable/org.geoserver.web.data.layer.LayerPage"));
    }

    @Test
    public void testSecuredPageAllowsAccessWhenLoggedIn() {
        this.login();
        tester.startPage(LayerPage.class);
        tester.assertRenderedPage(LayerPage.class);
    }

    @Test
    public void testToolPageAllowsAccessWhenLoggedIn() {
        this.login();
        tester.startPage(ToolPage.class);
        tester.assertRenderedPage(ToolPage.class);
        tester.assertNoErrorMessage();
    }

    @Test
    public void testSessionFixationAvoidance() throws Exception {
        tester.startPage(GeoServerHomePage.class);
        WebSession session = WebSession.get();
        session.bind();
        session.setAttribute("test", (Serializable)((Object)"whatever"));
        tester.startPage(GeoServerHomePage.class);
        MockHttpServletRequest request = this.createRequest("login");
        request.setMethod("POST");
        request.setParameter("username", "admin");
        request.setParameter("password", "geoserver");
        String oldSessionId = request.getSession().getId();
        this.dispatch((HttpServletRequest)request);
        Assert.assertNotEquals((Object)oldSessionId, (Object)request.getSession().getId());
        Assert.assertNull((Object)session.getAttribute("test"));
    }
}

