/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.web;

import com.google.common.collect.Iterators;
import java.util.Iterator;
import java.util.Locale;
import java.util.Properties;
import org.apache.wicket.core.util.resource.locator.IResourceNameIterator;
import org.apache.wicket.util.resource.IResourceStream;
import org.geoserver.web.GeoServerResourceStreamLocator;
import org.junit.Assert;
import org.junit.Test;

public class GeoServerResourceStreamLocatorTest {
    @Test
    public void testUTF8EncodingConvention() throws Exception {
        Properties properties;
        GeoServerResourceStreamLocator l = new GeoServerResourceStreamLocator();
        try (IResourceStream resourceStream = l.locate(GeoServerResourceStreamLocatorTest.class, "./GeoServerApplication.properties");){
            properties = new Properties();
            properties.load(resourceStream.getInputStream());
            Assert.assertEquals((Object)"welcome", (Object)properties.getProperty("StatusPageTest.welcome"));
        }
        resourceStream = l.locate(GeoServerResourceStreamLocatorTest.class, "./GeoServerApplication.utf8.properties");
        try {
            properties = new Properties();
            properties.load(resourceStream.getInputStream());
            Assert.assertEquals((Object)"\u6b22\u8fce", (Object)properties.getProperty("StatusPageTest.welcome"));
        }
        finally {
            if (resourceStream != null) {
                resourceStream.close();
            }
        }
    }

    @Test
    public void testNewResourceNameIterator() {
        GeoServerResourceStreamLocator l = new GeoServerResourceStreamLocator();
        IResourceNameIterator it = l.newResourceNameIterator("org/geoserver/Foo", Locale.US, null, null, "html", false);
        Assert.assertEquals((long)1L, (long)Iterators.size((Iterator)it));
        it = l.newResourceNameIterator("org/geoserver/Foo", Locale.US, null, null, "css", false);
        Assert.assertEquals((long)1L, (long)Iterators.size((Iterator)it));
        it = l.newResourceNameIterator("org/geoserver/Foo", Locale.US, null, null, "ico", false);
        Assert.assertEquals((long)1L, (long)Iterators.size((Iterator)it));
        it = l.newResourceNameIterator("org/geoserver/Foo", Locale.US, null, null, "js", false);
        Assert.assertEquals((long)1L, (long)Iterators.size((Iterator)it));
        it = l.newResourceNameIterator("org/geoserver/Foo", Locale.US, null, null, "baz", false);
        Assert.assertTrue((Iterators.size((Iterator)it) > 1 ? 1 : 0) != 0);
        it = l.newResourceNameIterator("org/geoserver/Foo.html", Locale.US, null, null, (String)null, false);
        Assert.assertEquals((long)1L, (long)Iterators.size((Iterator)it));
        it = l.newResourceNameIterator("org/geoserver/Foo.css", Locale.US, null, null, (String)null, false);
        Assert.assertEquals((long)1L, (long)Iterators.size((Iterator)it));
        it = l.newResourceNameIterator("org/geoserver/Foo.ico", Locale.US, null, null, (String)null, false);
        Assert.assertEquals((long)1L, (long)Iterators.size((Iterator)it));
        it = l.newResourceNameIterator("org/geoserver/Foo.js", Locale.US, null, null, (String)null, false);
        Assert.assertEquals((long)1L, (long)Iterators.size((Iterator)it));
        it = l.newResourceNameIterator("org/geoserver/Foo.baz", Locale.US, null, null, (String)null, false);
        Assert.assertTrue((Iterators.size((Iterator)it) > 1 ? 1 : 0) != 0);
    }
}

