/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.web;

import org.apache.wicket.protocol.http.WebApplication;
import org.apache.wicket.protocol.http.mock.MockHttpServletResponse;
import org.apache.wicket.util.tester.WicketTester;
import org.geoserver.config.GeoServerInfo;
import org.geoserver.security.GeoServerSecurityTestSupport;
import org.geoserver.web.GeoServerApplication;
import org.geoserver.web.admin.StatusPage;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class GeoServerRedirectTest
extends GeoServerSecurityTestSupport {
    public GeoServerApplication getGeoServerApplication() {
        return (GeoServerApplication)applicationContext.getBean("webApplication");
    }

    @Before
    public void init() {
        this.login("admin", "geoserver", new String[]{"ROLE_ADMINISTRATOR"});
    }

    @Test
    public void testRedirect() throws Exception {
        GeoServerInfo global = this.getGeoServer().getGlobal();
        global.setWebUIMode(GeoServerInfo.WebUIMode.REDIRECT);
        this.getGeoServer().save(global);
        GeoServerApplication app = this.getGeoServerApplication();
        app.init();
        WicketTester tester = new WicketTester((WebApplication)app, false);
        tester.startPage(StatusPage.class);
        Assert.assertEquals((long)2L, (long)tester.getPreviousResponses().size());
        Assert.assertEquals((long)302L, (long)((MockHttpServletResponse)tester.getPreviousResponses().get(0)).getStatus());
    }

    @Test
    public void testDoNotRedirect() throws Exception {
        GeoServerInfo global = this.getGeoServer().getGlobal();
        global.setWebUIMode(GeoServerInfo.WebUIMode.DO_NOT_REDIRECT);
        this.getGeoServer().save(global);
        GeoServerApplication app = this.getGeoServerApplication();
        app.init();
        WicketTester tester = new WicketTester((WebApplication)app, false);
        tester.startPage(StatusPage.class);
        Assert.assertEquals((long)1L, (long)tester.getPreviousResponses().size());
        Assert.assertEquals((long)200L, (long)((MockHttpServletResponse)tester.getPreviousResponses().get(0)).getStatus());
    }

    @Test
    public void testDefaultRedirect() throws Exception {
        GeoServerInfo global = this.getGeoServer().getGlobal();
        global.setWebUIMode(GeoServerInfo.WebUIMode.DEFAULT);
        this.getGeoServer().save(global);
        GeoServerApplication app = this.getGeoServerApplication();
        app.setDefaultIsRedirect(true);
        app.init();
        WicketTester tester = new WicketTester((WebApplication)app, false);
        tester.startPage(StatusPage.class);
        Assert.assertEquals((long)2L, (long)tester.getPreviousResponses().size());
        Assert.assertEquals((long)302L, (long)((MockHttpServletResponse)tester.getPreviousResponses().get(0)).getStatus());
    }

    @Test
    public void testDefaultDoNotRedirect() throws Exception {
        GeoServerInfo global = this.getGeoServer().getGlobal();
        global.setWebUIMode(GeoServerInfo.WebUIMode.DEFAULT);
        this.getGeoServer().save(global);
        GeoServerApplication app = this.getGeoServerApplication();
        app.setDefaultIsRedirect(false);
        app.init();
        WicketTester tester = new WicketTester((WebApplication)app, false);
        tester.startPage(StatusPage.class);
        Assert.assertEquals((long)1L, (long)tester.getPreviousResponses().size());
        Assert.assertEquals((long)200L, (long)((MockHttpServletResponse)tester.getPreviousResponses().get(0)).getStatus());
    }
}

