/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.web;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import org.apache.wicket.Component;
import org.apache.wicket.Page;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.form.TextField;
import org.apache.wicket.markup.html.list.ListView;
import org.apache.wicket.model.StringResourceModel;
import org.apache.wicket.util.tester.FormTester;
import org.geoserver.config.ContactInfo;
import org.geoserver.config.GeoServer;
import org.geoserver.config.GeoServerInfo;
import org.geoserver.config.SettingsInfo;
import org.geoserver.data.test.MockData;
import org.geoserver.web.CapabilitiesHomePageLinkProvider;
import org.geoserver.web.GeoServerApplication;
import org.geoserver.web.GeoServerHomePage;
import org.geoserver.web.GeoServerHomePageContentProvider;
import org.geoserver.web.GeoServerWicketTestSupport;
import org.geoserver.web.HomePageSelection;
import org.geoserver.web.wicket.Select2DropDownChoice;
import org.geotools.api.util.InternationalString;
import org.geotools.util.GrowableInternationalString;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class GeoServerHomePageTest
extends GeoServerWicketTestSupport {
    @Before
    public void setupMode() {
        HomePageSelection.MODE = HomePageSelection.SelectionMode.DROPDOWN;
    }

    protected void setUpSpring(List<String> springContextLocations) {
        super.setUpSpring(springContextLocations);
        springContextLocations.add("classpath*:/org/geoserver/web/GeoServerHomePageTestContext.xml");
    }

    @Before
    public void resetMail() {
        GeoServer gs = this.getGeoServer();
        GeoServerInfo global = gs.getGlobal();
        SettingsInfo settings = global.getSettings();
        settings.getContact().setContactEmail("andrea@geoserver.org");
        gs.save(global);
    }

    @Test
    public void testProvidedGetCapabilities() {
        tester.startPage(GeoServerHomePage.class);
        tester.assertComponent("providedCaps", ListView.class);
        tester.assertModelValue("providedCaps", Collections.singletonList((CapabilitiesHomePageLinkProvider)this.getGeoServerApplication().getBeanOfType(CapabilitiesHomePageLinkProvider.class)));
    }

    @Test
    public void testHelloWorld() {
        GeoServer gs = this.getGeoServer();
        GeoServerInfo global = gs.getGlobal();
        SettingsInfo settings = global.getSettings();
        ContactInfo contact = settings.getContact();
        GrowableInternationalString helloWorld = new GrowableInternationalString("Hello World");
        helloWorld.add(Locale.ENGLISH, "Hello World");
        helloWorld.add(Locale.ITALIAN, "Ciao mondo");
        helloWorld.add(Locale.FRENCH, "Bonjour le monde");
        contact.setWelcome("Hello world");
        contact.setInternationalWelcome((InternationalString)helloWorld);
        gs.save(global);
        tester.getSession().setLocale(Locale.ITALIAN);
        tester.startPage(GeoServerHomePage.class);
        String html = tester.getLastResponseAsString();
        MatcherAssert.assertThat((Object)html, (Matcher)CoreMatchers.containsString((String)"Ciao mondo"));
        tester.getSession().setLocale(Locale.FRENCH);
        tester.startPage(GeoServerHomePage.class);
        html = tester.getLastResponseAsString();
        MatcherAssert.assertThat((Object)html, (Matcher)CoreMatchers.containsString((String)"Bonjour le monde"));
    }

    @Test
    public void testProvidedCentralBodyContent() {
        tester.startPage(GeoServerHomePage.class);
        GeoServerApplication geoServerApplication = this.getGeoServerApplication();
        List providers = geoServerApplication.getBeansOfType(GeoServerHomePageContentProvider.class);
        Assert.assertFalse((boolean)providers.isEmpty());
        tester.assertComponent("contributedContent", ListView.class);
        tester.assertModelValue("contributedContent", (Object)providers);
    }

    @Test
    public void testEmailIfNull() {
        GeoServerApplication geoServerApplication = this.getGeoServerApplication();
        String contactEmail = geoServerApplication.getGeoServer().getGlobal().getSettings().getContact().getContactEmail();
        Assert.assertEquals((Object)"andrea@geoserver.org", (Object)(contactEmail == null ? "andrea@geoserver.org" : contactEmail));
    }

    @Test
    public void testEmailEscape() {
        GeoServerApplication geoServerApplication = this.getGeoServerApplication();
        GeoServer gs = geoServerApplication.getGeoServer();
        GeoServerInfo global = gs.getGlobal();
        SettingsInfo settings = global.getSettings();
        settings.getContact().setContactEmail("<b>hello</b>test@mail.com");
        gs.save(global);
        tester.startPage(GeoServerHomePage.class);
        String html = tester.getLastResponseAsString();
        MatcherAssert.assertThat((Object)html, (Matcher)CoreMatchers.containsString((String)" <a href=\"mailto:&lt;b&gt;hello&lt;/b&gt;test@mail.com\">administrator</a>"));
    }

    @Test
    public void testDropDownSelection() throws Exception {
        tester.startPage(GeoServerHomePage.class);
        tester.assertNoErrorMessage();
        tester.assertRenderedPage(GeoServerHomePage.class);
        Page page1 = tester.getLastRenderedPage();
        Select2DropDownChoice workspaceSelector = (Select2DropDownChoice)tester.getComponentFromLastRenderedPage("form:workspace:select");
        List workspaces = this.getCatalog().getWorkspaces();
        List workspaceChoices = workspaceSelector.getChoices();
        Assert.assertEquals((long)workspaces.size(), (long)workspaceChoices.size());
        Select2DropDownChoice publishedSelector = (Select2DropDownChoice)tester.getComponentFromLastRenderedPage("form:layer:select");
        ArrayList publisheds = new ArrayList(this.getCatalog().getLayers());
        publisheds.addAll(this.getCatalog().getLayerGroups());
        List publishedChoices = publishedSelector.getChoices();
        Assert.assertEquals((long)publisheds.size(), (long)publishedChoices.size());
        FormTester form = tester.newFormTester("form");
        form.setValue("workspace:select", MockData.CITE_PREFIX);
        tester.executeAjaxEvent("form:workspace:select", "change");
        tester.assertRenderedPage(GeoServerHomePage.class);
        GeoServerHomePage page2 = (GeoServerHomePage)tester.getLastRenderedPage();
        Assert.assertNotSame((Object)page1, (Object)page2);
        Assert.assertEquals((Object)page2.getWorkspaceInfo(), (Object)this.getCatalog().getWorkspaceByName(MockData.CITE_PREFIX));
        form = tester.newFormTester("form");
        form.setValue("layer:select", MockData.BASIC_POLYGONS.getLocalPart());
        tester.executeAjaxEvent("form:layer:select", "change");
        tester.assertRenderedPage(GeoServerHomePage.class);
        GeoServerHomePage page3 = (GeoServerHomePage)tester.getLastRenderedPage();
        Assert.assertNotSame((Object)page1, (Object)page3);
        Assert.assertNotSame((Object)page2, (Object)page3);
        Assert.assertEquals((Object)page3.getWorkspaceInfo(), (Object)this.getCatalog().getWorkspaceByName(MockData.CITE_PREFIX));
        Assert.assertEquals((Object)page3.getPublishedInfo(), (Object)this.getCatalog().getLayerByName(this.getLayerId(MockData.BASIC_POLYGONS)));
    }

    @Test
    public void testDropDownLayerSelection() throws Exception {
        tester.startPage(GeoServerHomePage.class);
        tester.assertNoErrorMessage();
        tester.assertRenderedPage(GeoServerHomePage.class);
        Page page1 = tester.getLastRenderedPage();
        FormTester form = tester.newFormTester("form");
        form.setValue("layer:select", this.getLayerId(MockData.BASIC_POLYGONS));
        tester.executeAjaxEvent("form:layer:select", "change");
        tester.assertRenderedPage(GeoServerHomePage.class);
        GeoServerHomePage page2 = (GeoServerHomePage)tester.getLastRenderedPage();
        Assert.assertNotSame((Object)page1, (Object)page2);
        Assert.assertEquals((Object)page2.getWorkspaceInfo(), (Object)this.getCatalog().getWorkspaceByName(MockData.CITE_PREFIX));
        Assert.assertEquals((Object)page2.getPublishedInfo(), (Object)this.getCatalog().getLayerByName(this.getLayerId(MockData.BASIC_POLYGONS)));
        form = tester.newFormTester("form");
        form.setValue("layer:select", null);
        tester.executeAjaxEvent("form:layer:select", "change");
        tester.assertRenderedPage(GeoServerHomePage.class);
        GeoServerHomePage page3 = (GeoServerHomePage)tester.getLastRenderedPage();
        Assert.assertNotSame((Object)page1, (Object)page3);
        Assert.assertNotSame((Object)page2, (Object)page3);
        Assert.assertEquals((Object)page2.getWorkspaceInfo(), (Object)this.getCatalog().getWorkspaceByName(MockData.CITE_PREFIX));
        Assert.assertNull((Object)page2.getPublishedInfo());
    }

    @Test
    public void testTextSelection() throws Exception {
        HomePageSelection.MODE = HomePageSelection.SelectionMode.TEXT;
        tester.startPage(GeoServerHomePage.class);
        tester.assertNoErrorMessage();
        tester.assertRenderedPage(GeoServerHomePage.class);
        GeoServerHomePage page1 = (GeoServerHomePage)tester.getLastRenderedPage();
        tester.assertComponent("form:workspace:text", TextField.class);
        tester.assertComponent("form:layer:text", TextField.class);
        FormTester form = tester.newFormTester("form");
        form.setValue("workspace:text", MockData.CITE_PREFIX);
        tester.executeAjaxEvent("form:workspace:text", "change");
        tester.assertRenderedPage(GeoServerHomePage.class);
        GeoServerHomePage page2 = (GeoServerHomePage)tester.getLastRenderedPage();
        Assert.assertNotSame((Object)page1, (Object)page2);
        Assert.assertEquals((Object)page2.getWorkspaceInfo(), (Object)this.getCatalog().getWorkspaceByName(MockData.CITE_PREFIX));
        form = tester.newFormTester("form");
        form.setValue("layer:text", MockData.BASIC_POLYGONS.getLocalPart());
        tester.executeAjaxEvent("form:layer:text", "change");
        tester.assertRenderedPage(GeoServerHomePage.class);
        GeoServerHomePage page3 = (GeoServerHomePage)tester.getLastRenderedPage();
        Assert.assertNotSame((Object)page1, (Object)page3);
        Assert.assertNotSame((Object)page2, (Object)page3);
        Assert.assertEquals((Object)page3.getWorkspaceInfo(), (Object)this.getCatalog().getWorkspaceByName(MockData.CITE_PREFIX));
        Assert.assertEquals((Object)page3.getPublishedInfo(), (Object)this.getCatalog().getLayerByName(this.getLayerId(MockData.BASIC_POLYGONS)));
    }

    @Test
    public void testAutoSelection() throws Exception {
        HomePageSelection.MODE = HomePageSelection.SelectionMode.AUTOMATIC;
        HomePageSelection.HOME_PAGE_TIMEOUT = 86400000L;
        HomePageSelection.HOME_PAGE_MAX_ITEMS = 1;
        tester.startPage(GeoServerHomePage.class);
        tester.assertComponent("form:workspace:text", TextField.class);
        tester.assertComponent("form:layer:text", TextField.class);
        HomePageSelection.HOME_PAGE_MAX_ITEMS = this.getCatalog().getWorkspaces().size();
        tester.startPage(GeoServerHomePage.class);
        tester.assertComponent("form:workspace:select", Select2DropDownChoice.class);
        tester.assertComponent("form:layer:text", TextField.class);
        HomePageSelection.HOME_PAGE_MAX_ITEMS = Integer.MAX_VALUE;
        tester.startPage(GeoServerHomePage.class);
        tester.assertComponent("form:workspace:select", Select2DropDownChoice.class);
        tester.assertComponent("form:layer:select", Select2DropDownChoice.class);
    }

    @Test
    public void testHideSensitiveInfo() throws Exception {
        this.logout();
        tester.startPage(GeoServerHomePage.class);
        String version = new StringResourceModel("version", null, null).getString();
        String responseTxt = tester.getLastResponse().getDocument();
        Assert.assertFalse((boolean)responseTxt.contains(version));
        this.login();
        tester.startPage(GeoServerHomePage.class);
        responseTxt = tester.getLastResponse().getDocument();
        Assert.assertTrue((boolean)responseTxt.contains(version));
    }

    public static class MockHomePageContentProvider
    implements GeoServerHomePageContentProvider {
        public Component getPageBodyComponent(String id) {
            return new Label(id, (Serializable)((Object)"MockHomePageContentProvider"));
        }
    }
}

