/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.web;

import org.apache.wicket.validation.IValidatable;
import org.geoserver.web.EmailAddressValidator;
import org.geoserver.web.StringValidatable;
import org.junit.Assert;
import org.junit.Test;

public class EmailAddressValidatorTest {
    @Test
    public void shouldPassSavingEmailIsValid() {
        StringValidatable validatable = new StringValidatable("test@mail.com");
        new EmailAddressValidator().validate((IValidatable)validatable);
        Assert.assertTrue((boolean)validatable.isValid());
    }

    @Test
    public void shouldPassIfUnicodeEmailIsValid() {
        StringValidatable validatable = new StringValidatable("\u7528\u6237\u540d@\u9886\u57df.\u7535\u8111");
        new EmailAddressValidator().validate((IValidatable)validatable);
        Assert.assertTrue((boolean)validatable.isValid());
    }

    @Test
    public void shouldFailIfEmailIsInvalid() {
        StringValidatable validatable = new StringValidatable("test@gmail.com\"><script>alert('XSS')</script>");
        new EmailAddressValidator().validate((IValidatable)validatable);
        Assert.assertFalse((boolean)validatable.isValid());
    }
}

