/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.web.wicket.browser;

import java.io.File;
import java.io.FileFilter;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.stream.Stream;
import org.geoserver.platform.GeoServerExtensions;
import org.geoserver.platform.GeoServerResourceLoader;
import org.geoserver.platform.resource.Paths;
import org.geoserver.platform.resource.Resource;
import org.geoserver.security.FileAccessManager;
import org.geoserver.web.wicket.browser.GeoServerFileChooser;

public class FileRootsFinder
implements Serializable {
    private ArrayList<File> roots;
    private File dataDirectory;
    private boolean prefixPaths = true;

    public FileRootsFinder(boolean includeDataDir) {
        this(GeoServerFileChooser.HIDE_FS, includeDataDir);
    }

    public FileRootsFinder(boolean hideFileSystem, boolean includeDataDir) {
        FileAccessManager fam = FileAccessManager.lookupFileAccessManager();
        List famRoots = fam.getAvailableRoots();
        if (famRoots != null) {
            this.roots = new ArrayList(famRoots);
            Collections.sort(this.roots);
            return;
        }
        this.roots = new ArrayList();
        if (!hideFileSystem) {
            this.roots.addAll(Arrays.asList(File.listRoots()));
        }
        Collections.sort(this.roots);
        GeoServerResourceLoader loader = this.getLoader();
        this.dataDirectory = loader.getBaseDirectory();
        if (includeDataDir) {
            this.roots.add(0, this.dataDirectory);
        }
        if (!hideFileSystem && GeoServerFileChooser.USER_HOME != null) {
            this.roots.add(1, GeoServerFileChooser.USER_HOME);
        }
    }

    public boolean isPrefixPaths() {
        return this.prefixPaths;
    }

    public void setPrefixPaths(boolean prefixPaths) {
        this.prefixPaths = prefixPaths;
    }

    public ArrayList<File> getRoots() {
        return this.roots;
    }

    public GeoServerResourceLoader getLoader() {
        return (GeoServerResourceLoader)GeoServerExtensions.bean(GeoServerResourceLoader.class);
    }

    public File getDataDirectory() {
        return this.dataDirectory;
    }

    public Stream<String> getMatches(String input, FileFilter fileFilter) {
        Stream<Object> result;
        Object loader;
        FileFilter ff = fileFilter == null ? f -> true : fileFilter;
        FileAccessManager fam = FileAccessManager.lookupFileAccessManager();
        List famRoots = fam.getAvailableRoots();
        if (famRoots == null) {
            PathSplitter ddSplitter = new PathSplitter(input, true);
            loader = this.getLoader();
            Resource resource = loader.get(ddSplitter.base);
            File dataDirectoryRoot = loader.get("/").dir();
            result = resource.list().stream().filter(r -> r.name().toLowerCase().contains(ddSplitter.name)).filter(r -> ff.accept(new File(dataDirectoryRoot, r.path()))).map(r -> ddSplitter.buildPath(r.name()));
        } else {
            result = Stream.empty();
        }
        PathSplitter fsSplitter = new PathSplitter(input, false);
        loader = this.getRoots().iterator();
        while (loader.hasNext()) {
            File searchBase;
            String[] names;
            String pathInRoot = fsSplitter.base;
            File root2 = (File)loader.next();
            if (!pathInRoot.startsWith(root2.getPath())) continue;
            if ((pathInRoot = pathInRoot.substring(root2.getPath().length())).startsWith(File.separator)) {
                pathInRoot = pathInRoot.substring(1);
            }
            if ((names = (searchBase = new File(root2, pathInRoot)).list((dir, fileName) -> fileName.toLowerCase().contains(fsSplitter.name))) == null) continue;
            Stream<String> rootPaths = Arrays.stream(names).filter(name -> ff.accept(new File(fsSplitter.base, (String)name))).map(fileName -> fsSplitter.buildPath((String)fileName));
            result = Stream.concat(result, rootPaths);
        }
        String prefix = this.prefixPaths ? "file://" : "";
        Stream<String> rootMatches = this.getRoots().stream().filter(root -> root.getPath().contains(input)).map(r -> prefix + r.getPath());
        result = Stream.concat(result, rootMatches);
        return result.distinct().sorted();
    }

    class PathSplitter {
        String separator;
        boolean dataDirectoryPath;
        String base;
        String name;

        public PathSplitter(String input, boolean dataDirectoryPath) {
            int idx;
            this.separator = dataDirectoryPath ? "/" : File.separator;
            this.dataDirectoryPath = dataDirectoryPath;
            if (input.startsWith("file:")) {
                input = input.startsWith("file:/") ? (input.startsWith("file://") ? input.substring(7) : input.substring(6)) : input.substring(5);
            }
            if ((idx = input.lastIndexOf(this.separator)) >= 0) {
                this.base = input.substring(0, idx);
                this.name = input.substring(idx + 1, input.length()).toLowerCase();
            } else {
                this.base = this.separator;
                this.name = input.toLowerCase();
            }
            if (dataDirectoryPath) {
                this.base = Paths.convert((String)this.base);
            }
        }

        private String buildPath(String name) {
            String prefix = FileRootsFinder.this.prefixPaths ? (this.dataDirectoryPath ? "file:" : "file://") : "";
            String localBase = this.base;
            if (this.dataDirectoryPath && localBase.startsWith(this.separator)) {
                localBase = this.base.substring(1);
            }
            if (localBase.endsWith(this.separator)) {
                return prefix + localBase + name;
            }
            return prefix + localBase + this.separator + name;
        }
    }
}

