/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.web.wicket;

import java.io.PrintStream;
import java.util.Arrays;
import java.util.regex.Pattern;
import org.apache.wicket.Component;
import org.apache.wicket.MarkupContainer;
import org.apache.wicket.Page;

public class WicketHierarchyPrinter {
    static final Pattern NEWLINE = Pattern.compile("\\n", 8);
    PrintStream out;
    boolean valueDumpEnabled;
    boolean classDumpEnabled;
    boolean pathDumpEnabled;

    public static void print(Component c, boolean dumpClass, boolean dumpValue, boolean dumpPath) {
        WicketHierarchyPrinter printer = new WicketHierarchyPrinter();
        printer.setPathDumpEnabled(dumpClass);
        printer.setClassDumpEnabled(dumpClass);
        printer.setValueDumpEnabled(dumpValue);
        if (c instanceof Page) {
            printer.print(c);
        } else {
            printer.print(c);
        }
    }

    public static void print(Component c, boolean dumpClass, boolean dumpValue) {
        WicketHierarchyPrinter.print(c, dumpClass, dumpValue, false);
    }

    public WicketHierarchyPrinter() {
        this.out = System.out;
    }

    public WicketHierarchyPrinter(PrintStream out) {
        this.out = out;
    }

    public void setValueDumpEnabled(boolean valueDumpEnabled) {
        this.valueDumpEnabled = valueDumpEnabled;
    }

    public void setClassDumpEnabled(boolean classDumpEnabled) {
        this.classDumpEnabled = classDumpEnabled;
    }

    public void print(Component c) {
        this.walkHierarchy(c, 0);
    }

    private void walkHierarchy(Component c, int level) {
        this.printComponent(c, level);
        if (c instanceof MarkupContainer) {
            MarkupContainer mc = (MarkupContainer)c;
            for (Component component : mc) {
                this.walkHierarchy(component, level + 1);
            }
        }
    }

    private void printComponent(Component c, int level) {
        if (c instanceof Page) {
            this.out.print(this.tab(level) + "PAGE_ROOT");
        } else {
            this.out.print(this.tab(level) + c.getId());
        }
        if (this.pathDumpEnabled) {
            this.out.print(" " + c.getPageRelativePath());
        }
        if (this.classDumpEnabled) {
            String className = c.getClass().isAnonymousClass() ? c.getClass().getSuperclass().getName() : c.getClass().getName();
            this.out.print("(" + className + ")");
        }
        if (this.valueDumpEnabled) {
            try {
                Object value = "null";
                if (c.getDefaultModel() != null && c.getDefaultModelObject() != null) {
                    value = "'" + NEWLINE.matcher(c.getDefaultModelObjectAsString()).replaceAll("\\\\n") + "'";
                }
                this.out.print(" " + (String)value);
            }
            catch (Exception e) {
                this.out.print(" 'ERROR_RETRIEVING_MODEL " + e.getMessage() + "'");
            }
        }
        this.out.println();
    }

    String tab(int level) {
        char[] spaces = new char[level * 3];
        Arrays.fill(spaces, ' ');
        return String.valueOf(spaces);
    }

    public boolean isPathDumpEnabled() {
        return this.pathDumpEnabled;
    }

    public void setPathDumpEnabled(boolean pathDumpEnabled) {
        this.pathDumpEnabled = pathDumpEnabled;
    }
}

