/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.web.wicket;

import java.io.Serializable;
import java.util.Arrays;
import org.apache.wicket.Component;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.ajax.markup.html.AjaxLink;
import org.apache.wicket.ajax.markup.html.form.AjaxSubmitLink;
import org.apache.wicket.feedback.IFeedback;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.form.Form;
import org.apache.wicket.markup.html.form.IFormSubmittingComponent;
import org.apache.wicket.markup.html.list.ListItem;
import org.apache.wicket.markup.html.list.ListView;
import org.apache.wicket.markup.html.panel.Panel;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;
import org.geoserver.web.wicket.GSModalWindow;

public class GeoServerDialog
extends Panel {
    GSModalWindow window;
    Component userPanel;
    DialogDelegate delegate;

    public GeoServerDialog(String id) {
        super(id);
        Component[] componentArray = new Component[1];
        this.window = new GSModalWindow("dialog");
        componentArray[0] = this.window;
        this.add(componentArray);
    }

    public void setTitle(IModel<String> title) {
        this.window.setTitle(title);
    }

    public void setInitialHeight(int initialHeight) {
        this.window.setInitialHeight(initialHeight);
    }

    public void setInitialWidth(int initialWidth) {
        this.window.setInitialWidth(initialWidth);
    }

    public void showOkCancel(AjaxRequestTarget target, DialogDelegate delegate) {
        this.userPanel = delegate.getContents("userPanel");
        this.window.setContent((Component)new ContentsPage(this.userPanel));
        this.window.setCloseButtonCallback((GSModalWindow.CloseButtonCallback & Serializable)target12 -> delegate.onCancel(target12));
        this.window.setWindowClosedCallback((GSModalWindow.WindowClosedCallback & Serializable)target1 -> delegate.onClose(target1));
        this.delegate = delegate;
        this.window.show(target);
    }

    @SafeVarargs
    public final void showInfo(AjaxRequestTarget target, IModel<String> heading, IModel<String> ... messages) {
        this.window.setContent((Component)new InfoPage(this.window.getContentId(), heading, messages));
        this.window.show(target);
    }

    public void close(AjaxRequestTarget target) {
        this.window.close(target);
        this.delegate = null;
        this.userPanel = null;
    }

    public void submit(AjaxRequestTarget target) {
        this.submit(target, this.userPanel);
    }

    void submit(AjaxRequestTarget target, Component contents) {
        if (this.delegate.onSubmit(target, contents)) {
            this.close(target);
        }
    }

    AjaxSubmitLink sumbitLink(Component contents) {
        AjaxSubmitLink link = new AjaxSubmitLink("submit"){

            protected void onSubmit(AjaxRequestTarget target) {
                GeoServerDialog.this.submit(target, (Component)this.getDefaultModelObject());
            }

            protected void onError(AjaxRequestTarget target) {
                GeoServerDialog.this.delegate.onError(target, this.getForm());
            }
        };
        link.setDefaultModel((IModel)new Model((Serializable)contents));
        return link;
    }

    Component cancelLink() {
        return new AjaxLink<Void>("cancel"){

            public void onClick(AjaxRequestTarget target) {
                if (GeoServerDialog.this.delegate.onCancel(target)) {
                    GeoServerDialog.this.window.close(target);
                    GeoServerDialog.this.delegate = null;
                }
            }
        };
    }

    public static abstract class DialogDelegate
    implements Serializable {
        protected abstract Component getContents(String var1);

        public void onError(AjaxRequestTarget target, Form<?> form) {
            form.getPage().visitChildren(IFeedback.class, (component, visit) -> {
                if (component.getOutputMarkupId()) {
                    target.add(new Component[]{component});
                }
            });
        }

        public void onClose(AjaxRequestTarget target) {
        }

        protected abstract boolean onSubmit(AjaxRequestTarget var1, Component var2);

        protected boolean onCancel(AjaxRequestTarget target) {
            return true;
        }
    }

    protected class InfoPage
    extends Panel {
        @SafeVarargs
        public InfoPage(String id, IModel<String> title, IModel<String> ... messages) {
            super(id);
            this.add(new Component[]{new Label("title", title)});
            this.add(new Component[]{new ListView<IModel<String>>("messages", Arrays.asList(messages)){

                protected void populateItem(ListItem<IModel<String>> item) {
                    item.add(new Component[]{new Label("message", (IModel)item.getModelObject()).setEscapeModelStrings(false)});
                }
            }});
        }
    }

    protected class ContentsPage
    extends Panel {
        public ContentsPage(Component contents) {
            super("content");
            Form form = new Form("form");
            this.add(new Component[]{form});
            form.add(new Component[]{contents});
            AjaxSubmitLink submit = GeoServerDialog.this.sumbitLink(contents);
            form.add(new Component[]{submit});
            form.add(new Component[]{GeoServerDialog.this.cancelLink()});
            form.setDefaultButton((IFormSubmittingComponent)submit);
        }
    }
}

