/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.web.spring.security;

import org.apache.wicket.Session;
import org.apache.wicket.protocol.http.WebSession;
import org.apache.wicket.request.Request;
import org.geoserver.security.GeoServerSecurityManager;
import org.geoserver.web.GeoServerApplication;
import org.springframework.security.authentication.AnonymousAuthenticationToken;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.context.SecurityContextHolder;

public class GeoServerSession
extends WebSession {
    public GeoServerSession(Request request) {
        super(request);
    }

    public static GeoServerSession get() {
        return (GeoServerSession)Session.get();
    }

    public Authentication getAuthentication() {
        Authentication auth = SecurityContextHolder.getContext().getAuthentication();
        if (auth != null && auth.getAuthorities().size() == 1 && "ROLE_ANONYMOUS".equals(((GrantedAuthority)auth.getAuthorities().iterator().next()).getAuthority())) {
            return null;
        }
        return auth;
    }

    public String getUsername() {
        Authentication user = this.getAuthentication();
        boolean anonymous = user == null || user instanceof AnonymousAuthenticationToken;
        return anonymous ? "anonymous" : user.getName();
    }

    public boolean isAdmin() {
        Authentication auth = this.getAuthentication();
        if (auth == null || !auth.isAuthenticated() || auth instanceof AnonymousAuthenticationToken) {
            return false;
        }
        GeoServerSecurityManager securityManager = GeoServerApplication.get().getSecurityManager();
        return securityManager.checkAuthenticationForAdminRole(auth);
    }
}

