/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.web.data.store;

import java.io.Serializable;
import org.apache.wicket.Component;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.ajax.form.OnChangeAjaxBehavior;
import org.apache.wicket.ajax.markup.html.form.AjaxSubmitLink;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.markup.html.form.Form;
import org.apache.wicket.markup.html.form.IFormSubmitter;
import org.apache.wicket.markup.html.form.IFormSubmittingComponent;
import org.apache.wicket.markup.html.form.validation.IFormValidator;
import org.apache.wicket.markup.html.link.BookmarkablePageLink;
import org.apache.wicket.markup.html.panel.FeedbackPanel;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;
import org.apache.wicket.model.PropertyModel;
import org.apache.wicket.model.ResourceModel;
import org.apache.wicket.validation.IValidator;
import org.apache.wicket.validation.validator.RangeValidator;
import org.geoserver.catalog.WMSStoreInfo;
import org.geoserver.catalog.WorkspaceInfo;
import org.geoserver.security.impl.FileSandboxEnforcer;
import org.geoserver.web.ComponentAuthorizer;
import org.geoserver.web.GeoServerSecuredPage;
import org.geoserver.web.data.store.StoreNameValidator;
import org.geoserver.web.data.store.StorePage;
import org.geoserver.web.data.store.panel.CheckBoxParamPanel;
import org.geoserver.web.data.store.panel.PasswordParamPanel;
import org.geoserver.web.data.store.panel.TextParamPanel;
import org.geoserver.web.data.store.panel.WorkspacePanel;
import org.geoserver.web.wicket.GeoServerDialog;
import org.geoserver.web.wicket.ParamResourceModel;

abstract class AbstractWMSStorePage
extends GeoServerSecuredPage {
    protected WorkspacePanel workspacePanel;
    private Form<WMSStoreInfo> form;
    GeoServerDialog dialog;
    TextParamPanel<String> capabilitiesURL;
    protected TextParamPanel<String> usernamePanel;
    protected PasswordParamPanel password;
    protected TextParamPanel<String> headerNamePanel;
    protected TextParamPanel<String> headerValuePanel;
    protected TextParamPanel<String> authKeyPanel;

    AbstractWMSStorePage() {
    }

    void initUI(WMSStoreInfo store) {
        Model model = new Model((Serializable)store);
        Component[] componentArray = new Component[1];
        this.dialog = new GeoServerDialog("dialog");
        componentArray[0] = this.dialog;
        this.add(componentArray);
        this.form = new Form("form", (IModel)model);
        this.add(new Component[]{this.form});
        PropertyModel nameModel = new PropertyModel((Object)model, "name");
        TextParamPanel namePanel = new TextParamPanel("namePanel", nameModel, (IModel<String>)new ResourceModel("AbstractWMSStorePage.dataSrcName", "Data Source Name"), true, (IValidator<T>[])new IValidator[0]);
        this.form.add(new Component[]{namePanel});
        this.form.add(new Component[]{new TextParamPanel("descriptionPanel", new PropertyModel((Object)model, "description"), (IModel<String>)new ResourceModel("AbstractWMSStorePage.description", "Description"), false, (IValidator<T>[])new IValidator[0])});
        this.form.add(new Component[]{new CheckBoxParamPanel("enabledPanel", (IModel<Boolean>)new PropertyModel((Object)model, "enabled"), (IModel)new ResourceModel("enabled", "Enabled"))});
        this.form.add(new Component[]{new CheckBoxParamPanel("disableOnConnFailurePanel", (IModel<Boolean>)new PropertyModel((Object)model, "disableOnConnFailure"), (IModel)new ResourceModel("AbstractWMSStorePage.disableOnConnFailure", "Autodisable on connection failure"))});
        this.workspacePanel = new WorkspacePanel("workspacePanel", (IModel<WorkspaceInfo>)new PropertyModel((Object)model, "workspace"), (IModel<String>)new ResourceModel("workspace", "Workspace"), true);
        this.form.add(new Component[]{this.workspacePanel});
        this.capabilitiesURL = new TextParamPanel("capabilitiesURL", new PropertyModel((Object)model, "capabilitiesURL"), (IModel<String>)new ParamResourceModel("capabilitiesURL", (Component)this, new Object[0]), true, (IValidator<T>[])new IValidator[0]);
        this.form.add(new Component[]{this.capabilitiesURL});
        this.usernamePanel = new TextParamPanel("userNamePanel", new PropertyModel((Object)model, "username"), (IModel<String>)new ResourceModel("AbstractWMSStorePage.userName"), false, (IValidator<T>[])new IValidator[0]);
        this.form.add(new Component[]{this.usernamePanel});
        Component[] componentArray2 = new Component[1];
        this.password = new PasswordParamPanel("passwordPanel", (IModel<String>)new PropertyModel((Object)model, "password"), (IModel<String>)new ResourceModel("AbstractWMSStorePage.password"), false);
        componentArray2[0] = this.password;
        this.form.add(componentArray2);
        this.headerNamePanel = new TextParamPanel("headerNamePanel", new PropertyModel((Object)model, "headerName"), (IModel<String>)new ResourceModel("AbstractWMSStorePage.headerName"), false, (IValidator<T>[])new IValidator[0]);
        this.form.add(new Component[]{this.headerNamePanel});
        this.headerValuePanel = new TextParamPanel("headerValuePanel", new PropertyModel((Object)model, "headerValue"), (IModel<String>)new ResourceModel("AbstractWMSStorePage.headerValue"), false, (IValidator<T>[])new IValidator[0]);
        this.form.add(new Component[]{this.headerValuePanel});
        this.authKeyPanel = new TextParamPanel("authKeyPanel", new PropertyModel((Object)model, "authKey"), (IModel<String>)new ResourceModel("AbstractWMSStorePage.authKey"), false, (IValidator<T>[])new IValidator[0]);
        this.form.add(new Component[]{this.authKeyPanel});
        final PropertyModel useHttpConnectionPoolModel = new PropertyModel((Object)model, "useConnectionPooling");
        CheckBoxParamPanel useConnectionPooling = new CheckBoxParamPanel("useConnectionPoolingPanel", (IModel<Boolean>)useHttpConnectionPoolModel, (IModel)new ResourceModel("AbstractWMSStorePage.useHttpConnectionPooling"));
        this.form.add(new Component[]{useConnectionPooling});
        PropertyModel connectionsModel = new PropertyModel((Object)model, "maxConnections");
        final TextParamPanel maxConnections = new TextParamPanel("maxConnectionsPanel", connectionsModel, (IModel<String>)new ResourceModel("AbstractWMSStorePage.maxConnections"), true, (IValidator<T>[])new IValidator[]{new RangeValidator((Comparable)Integer.valueOf(1), (Comparable)Integer.valueOf(128))});
        maxConnections.setOutputMarkupId(true);
        maxConnections.setEnabled((Boolean)useHttpConnectionPoolModel.getObject());
        this.form.add(new Component[]{maxConnections});
        useConnectionPooling.getFormComponent().add(new Behavior[]{new OnChangeAjaxBehavior(){

            protected void onUpdate(AjaxRequestTarget target) {
                boolean enabled = (Boolean)useHttpConnectionPoolModel.getObject();
                maxConnections.setEnabled(enabled);
                target.add(new Component[]{maxConnections});
            }
        }});
        PropertyModel connectTimeoutModel = new PropertyModel((Object)model, "connectTimeout");
        this.form.add(new Component[]{new TextParamPanel("connectTimeoutPanel", connectTimeoutModel, (IModel<String>)new ResourceModel("AbstractWMSStorePage.connectTimeout"), true, (IValidator<T>[])new IValidator[]{new RangeValidator((Comparable)Integer.valueOf(1), (Comparable)Integer.valueOf(240))})});
        PropertyModel readTimeoutModel = new PropertyModel((Object)model, "readTimeout");
        this.form.add(new Component[]{new TextParamPanel("readTimeoutPanel", readTimeoutModel, (IModel<String>)new ResourceModel("AbstractWMSStorePage.readTimeout"), true, (IValidator<T>[])new IValidator[]{new RangeValidator((Comparable)Integer.valueOf(1), (Comparable)Integer.valueOf(360))})});
        this.form.add(new Component[]{new BookmarkablePageLink("cancel", StorePage.class)});
        this.form.add(new Component[]{this.saveLink()});
        this.form.setDefaultButton((IFormSubmittingComponent)this.saveLink());
        this.form.add(new Component[]{new FeedbackPanel("feedback")});
        StoreNameValidator storeNameValidator = new StoreNameValidator(this.workspacePanel.getFormComponent(), namePanel.getFormComponent(), store.getId());
        this.form.add((IFormValidator)storeNameValidator);
    }

    private AjaxSubmitLink saveLink() {
        return new AjaxSubmitLink("save", this.form){

            protected void onError(AjaxRequestTarget target) {
                super.onError(target);
                target.add(new Component[]{this.getForm()});
            }

            protected void onSubmit(AjaxRequestTarget target) {
                AbstractWMSStorePage.this.form.process((IFormSubmitter)this);
                WMSStoreInfo info = (WMSStoreInfo)this.getForm().getModelObject();
                try {
                    AbstractWMSStorePage.this.onSave(info, target);
                }
                catch (FileSandboxEnforcer.SandboxException e) {
                    AbstractWMSStorePage.this.form.error((Serializable)((Object)new ParamResourceModel("sandboxError", (Component)this, e.getFile().getAbsolutePath()).getString()));
                    target.add(new Component[]{this.getForm()});
                }
                catch (IllegalArgumentException e) {
                    AbstractWMSStorePage.this.form.error((Serializable)((Object)e.getMessage()));
                    target.add(new Component[]{this.getForm()});
                }
            }
        };
    }

    protected abstract void onSave(WMSStoreInfo var1, AjaxRequestTarget var2) throws IllegalArgumentException;

    @Override
    protected ComponentAuthorizer getPageAuthorizer() {
        return ComponentAuthorizer.WORKSPACE_ADMIN;
    }
}

