/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.web.data.store;

import java.io.Serializable;
import org.apache.wicket.Component;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.ajax.markup.html.form.AjaxSubmitLink;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.form.Form;
import org.apache.wicket.markup.html.form.IFormSubmittingComponent;
import org.apache.wicket.markup.html.form.validation.IFormValidator;
import org.apache.wicket.markup.html.link.BookmarkablePageLink;
import org.apache.wicket.markup.html.panel.FeedbackPanel;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;
import org.apache.wicket.model.PropertyModel;
import org.apache.wicket.model.ResourceModel;
import org.apache.wicket.validation.IValidator;
import org.geoserver.catalog.CoverageStoreInfo;
import org.geoserver.catalog.StoreInfo;
import org.geoserver.catalog.WorkspaceInfo;
import org.geoserver.web.ComponentAuthorizer;
import org.geoserver.web.GeoServerApplication;
import org.geoserver.web.GeoServerSecuredPage;
import org.geoserver.web.GeoserverAjaxSubmitLink;
import org.geoserver.web.data.store.StoreEditPanel;
import org.geoserver.web.data.store.StoreExtensionPoints;
import org.geoserver.web.data.store.StoreNameValidator;
import org.geoserver.web.data.store.StorePage;
import org.geoserver.web.data.store.panel.CheckBoxParamPanel;
import org.geoserver.web.data.store.panel.TextParamPanel;
import org.geoserver.web.data.store.panel.WorkspacePanel;
import org.geotools.coverage.grid.io.AbstractGridFormat;

abstract class AbstractCoverageStorePage
extends GeoServerSecuredPage {
    protected WorkspacePanel workspacePanel;
    private Form<CoverageStoreInfo> paramsForm;

    AbstractCoverageStorePage() {
    }

    void initUI(CoverageStoreInfo store) {
        AbstractGridFormat format = store.getFormat();
        if (format == null) {
            String msg = "Coverage Store factory not found";
            msg = new ResourceModel("CoverageStoreEditPage.cantGetCoverageStoreFactory", msg).getObject();
            throw new IllegalArgumentException(msg);
        }
        Model model = new Model((Serializable)store);
        this.paramsForm = new Form("rasterStoreForm", (IModel)model);
        this.add(new Component[]{this.paramsForm});
        this.paramsForm.add(new Component[]{new Label("storeType", (Serializable)((Object)format.getName()))});
        this.paramsForm.add(new Component[]{new Label("storeTypeDescription", (Serializable)((Object)format.getDescription()))});
        PropertyModel nameModel = new PropertyModel((Object)model, "name");
        TextParamPanel namePanel = new TextParamPanel("namePanel", nameModel, (IModel<String>)new ResourceModel("AbstractCoverageStorePage.dataSrcName", "Data Source Name"), true, (IValidator<T>[])new IValidator[0]);
        this.paramsForm.add(new Component[]{namePanel});
        this.paramsForm.add(new Component[]{new TextParamPanel("descriptionPanel", new PropertyModel((Object)model, "description"), (IModel<String>)new ResourceModel("AbstractCoverageStorePage.description", "Description"), false, (IValidator<T>[])new IValidator[0])});
        this.paramsForm.add(new Component[]{new CheckBoxParamPanel("enabledPanel", (IModel<Boolean>)new PropertyModel((Object)model, "enabled"), (IModel)new ResourceModel("enabled", "Enabled"))});
        this.paramsForm.add(new Component[]{new CheckBoxParamPanel("disableOnConnFailurePanel", (IModel<Boolean>)new PropertyModel((Object)model, "disableOnConnFailure"), (IModel)new ResourceModel("AbstractCoverageStorePage.disableOnConnFailure", "Auto disable on connection failure"))});
        this.workspacePanel = new WorkspacePanel("workspacePanel", (IModel<WorkspaceInfo>)new PropertyModel((Object)model, "workspace"), (IModel<String>)new ResourceModel("workspace", "Workspace"), true);
        this.paramsForm.add(new Component[]{this.workspacePanel});
        GeoServerApplication app = this.getGeoServerApplication();
        StoreEditPanel storeEditPanel = StoreExtensionPoints.getStoreEditPanel("parametersPanel", this.paramsForm, (StoreInfo)store, app);
        this.paramsForm.add(new Component[]{storeEditPanel});
        this.paramsForm.add(new Component[]{new BookmarkablePageLink("cancel", StorePage.class)});
        this.paramsForm.add(new Component[]{this.saveLink()});
        this.paramsForm.add(new Component[]{this.applyLink()});
        this.paramsForm.setDefaultButton((IFormSubmittingComponent)this.saveLink());
        this.paramsForm.add(new Component[]{new FeedbackPanel("feedback")});
        StoreNameValidator storeNameValidator = new StoreNameValidator(this.workspacePanel.getFormComponent(), namePanel.getFormComponent(), store.getId());
        this.paramsForm.add((IFormValidator)storeNameValidator);
    }

    private AjaxSubmitLink saveLink() {
        return new AjaxSubmitLink("save", this.paramsForm){

            protected void onError(AjaxRequestTarget target) {
                super.onError(target);
                target.add(new Component[]{AbstractCoverageStorePage.this.paramsForm});
            }

            protected void onSubmit(AjaxRequestTarget target) {
                CoverageStoreInfo info = (CoverageStoreInfo)this.getForm().getModelObject();
                try {
                    AbstractCoverageStorePage.this.onSave(info, target, true);
                }
                catch (IllegalArgumentException e) {
                    AbstractCoverageStorePage.this.paramsForm.error((Serializable)((Object)e.getMessage()));
                    target.add(new Component[]{AbstractCoverageStorePage.this.paramsForm});
                }
            }
        };
    }

    private GeoserverAjaxSubmitLink applyLink() {
        return new GeoserverAjaxSubmitLink("apply", this.paramsForm, this){

            @Override
            protected void onError(AjaxRequestTarget target) {
                super.onError(target);
                target.add(new Component[]{AbstractCoverageStorePage.this.paramsForm});
            }

            @Override
            protected void onSubmitInternal(AjaxRequestTarget target) {
                try {
                    CoverageStoreInfo info = (CoverageStoreInfo)this.getForm().getModelObject();
                    AbstractCoverageStorePage.this.onSave(info, target, false);
                }
                catch (IllegalArgumentException e) {
                    AbstractCoverageStorePage.this.paramsForm.error((Serializable)((Object)e.getMessage()));
                    target.add(new Component[]{AbstractCoverageStorePage.this.paramsForm});
                }
            }
        };
    }

    protected abstract void onSave(CoverageStoreInfo var1, AjaxRequestTarget var2, boolean var3) throws IllegalArgumentException;

    @Override
    protected ComponentAuthorizer getPageAuthorizer() {
        return ComponentAuthorizer.WORKSPACE_ADMIN;
    }
}

