/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.web.data.layergroup;

import java.util.ArrayList;
import java.util.List;
import org.apache.wicket.Component;
import org.apache.wicket.MarkupContainer;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.ajax.markup.html.AjaxLink;
import org.apache.wicket.markup.html.form.FormComponentPanel;
import org.apache.wicket.markup.html.form.TextField;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.PropertyModel;
import org.geoserver.catalog.Catalog;
import org.geoserver.catalog.PublishedInfo;
import org.geoserver.catalog.StyleInfo;
import org.geoserver.catalog.WorkspaceInfo;
import org.geoserver.catalog.impl.LayerGroupStyle;
import org.geoserver.catalog.impl.StyleInfoImpl;
import org.geoserver.platform.GeoServerExtensions;
import org.geoserver.web.data.layergroup.LayerGroupEntry;
import org.geoserver.web.data.layergroup.LayerGroupEntryPanel;
import org.geoserver.web.data.layergroup.LayerGroupStyleModel;
import org.geoserver.web.data.resource.TitleAndAbstractPanel;

public abstract class LayerGroupStylePanel
extends FormComponentPanel<LayerGroupStyle> {
    private LayerGroupEntryPanel<LayerGroupStyle> groupEntryPanel;
    private TextField<String> name;

    public LayerGroupStylePanel(String id, LayerGroupStyleModel model, IModel<WorkspaceInfo> workspaceInfo) {
        super(id, (IModel)model);
        PropertyModel styleNameModel = new PropertyModel((Object)model, "name");
        if (styleNameModel.getObject() == null) {
            styleNameModel.setObject((Object)new StyleInfoImpl((Catalog)GeoServerExtensions.bean((String)"catalog")));
        }
        this.name = new TextField("layerGroupStyleName", model.nameModel());
        this.name.setRequired(true);
        this.add(new Component[]{this.name});
        TitleAndAbstractPanel titleAndAbstractPanel = new TitleAndAbstractPanel("titleAndAbstract", (IModel<?>)model, "titleMsg", "abstract", (MarkupContainer)this);
        this.add(new Component[]{titleAndAbstractPanel});
        this.add(new Component[]{this.removeLink()});
        this.groupEntryPanel = new LayerGroupEntryPanel<LayerGroupStyle>("layerGroupEntryPanel", (IModel)model, workspaceInfo, true, false){

            @Override
            protected List<PublishedInfo> getLayers(LayerGroupStyle object) {
                return object.getLayers();
            }

            @Override
            protected List<StyleInfo> getStyles(LayerGroupStyle object) {
                return object.getStyles();
            }
        };
        this.groupEntryPanel.setOutputMarkupId(true);
        this.add(new Component[]{this.groupEntryPanel});
    }

    private AjaxLink<LayerGroupStyle> removeLink() {
        return new AjaxLink<LayerGroupStyle>("remove"){

            public void onClick(AjaxRequestTarget target) {
                LayerGroupStylePanel.this.handleRemoval(target, (LayerGroupStyle)LayerGroupStylePanel.this.getModelObject());
                LayerGroupStylePanel.this.groupEntryPanel.modelChanged();
                target.add(new Component[]{LayerGroupStylePanel.this.groupEntryPanel});
            }
        };
    }

    protected abstract void handleRemoval(AjaxRequestTarget var1, LayerGroupStyle var2);

    public void convertInput() {
        this.updateStyleModel();
    }

    public void updateModel() {
        this.updateStyleModel();
    }

    private void updateStyleModel() {
        List<LayerGroupEntry> layerGroupEntries = this.groupEntryPanel.getEntries();
        int size = layerGroupEntries.size();
        ArrayList<PublishedInfo> publishedInfos = new ArrayList<PublishedInfo>(size);
        ArrayList<StyleInfo> styleInfos = new ArrayList<StyleInfo>(size);
        for (int i = 0; i < layerGroupEntries.size(); ++i) {
            LayerGroupEntry entry = layerGroupEntries.get(i);
            if (publishedInfos.size() <= i) {
                publishedInfos.add(i, entry.getLayer());
            } else {
                publishedInfos.set(i, entry.getLayer());
            }
            if (styleInfos.size() <= i) {
                styleInfos.add(i, entry.getStyle());
                continue;
            }
            styleInfos.set(i, entry.getStyle());
        }
        LayerGroupStyleModel styleModel = this.getStyleModel();
        styleModel.setLayers(publishedInfos);
        styleModel.setStyles(styleInfos);
    }

    private LayerGroupStyleModel getStyleModel() {
        return (LayerGroupStyleModel)this.getModel();
    }
}

