/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.web;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.geotools.util.Version;

public class ServiceLinkDescription
implements Serializable,
Comparable<ServiceLinkDescription> {
    private static final long serialVersionUID = -5600492358023139816L;
    private final String serviceType;
    private final String specificServiceType;
    private final String protocol;
    private final Version version;
    private final String link;
    private final String workspace;
    private final String layer;
    private static List<String> OGC_SERVICE_ORDER = Collections.unmodifiableList(Arrays.asList("WMS", "WMTS", "WFS", "WCS", "WPS", "CSW"));

    public ServiceLinkDescription(String serviceType, Version version, String link, String workspace, String layer) {
        this(serviceType, version, link, workspace, layer, null);
    }

    public ServiceLinkDescription(String serviceType, Version version, String link, String workspace, String layer, String protocol) {
        this(serviceType, version, link, workspace, layer, protocol, null);
    }

    public ServiceLinkDescription(String serviceType, Version version, String link, String workspace, String layer, String protocol, String specificServiceType) {
        this.serviceType = serviceType;
        this.version = version;
        this.link = link;
        this.workspace = workspace;
        this.layer = layer;
        this.protocol = protocol != null ? protocol : this.serviceType;
        this.specificServiceType = specificServiceType;
    }

    public String getServiceType() {
        return this.serviceType;
    }

    public String getProtocol() {
        return this.protocol;
    }

    public String getSpecificServiceType() {
        return this.specificServiceType;
    }

    public Version getVersion() {
        return this.version;
    }

    public String getLink() {
        return this.link;
    }

    public String getWorkspace() {
        return this.workspace;
    }

    public String getLayer() {
        return this.layer;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ServiceLinkDescription)) {
            return false;
        }
        ServiceLinkDescription that = (ServiceLinkDescription)o;
        return Objects.equals(this.workspace, that.workspace) && Objects.equals(this.layer, that.layer) && this.serviceType.equals(that.serviceType) && this.version.equals((Object)that.version) && Objects.equals(this.link, that.link) && this.protocol.equals(that.protocol);
    }

    public int hashCode() {
        return Objects.hash(this.workspace, this.layer, this.serviceType, this.version, this.link, this.protocol);
    }

    private boolean isOGCWebService() {
        return OGC_SERVICE_ORDER.contains(this.getProtocol());
    }

    @Override
    public int compareTo(ServiceLinkDescription o) {
        if (this.isOGCWebService() && !o.isOGCWebService()) {
            return -1;
        }
        if (!this.isOGCWebService() && o.isOGCWebService()) {
            return 1;
        }
        int compareProtocol = this.protocol.compareTo(o.protocol);
        int compareVersion = -this.version.compareTo(o.getVersion());
        return compareProtocol != 0 ? compareProtocol : compareVersion;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("ServiceLinkDescription{");
        sb.append("service='").append(this.serviceType).append('\'');
        sb.append(", version=").append((CharSequence)this.version);
        sb.append(", protocol='").append(this.protocol).append('\'');
        sb.append(", workspace='").append(this.workspace).append('\'');
        sb.append(", layer='").append(this.layer).append('\'');
        sb.append(", link='").append(this.link).append('\'');
        sb.append('}');
        return sb.toString();
    }
}

