/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.web;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import java.util.logging.Logger;
import org.apache.wicket.Component;
import org.geoserver.config.ServiceInfo;
import org.geoserver.ows.DisabledServiceCheck;
import org.geoserver.platform.GeoServerExtensions;
import org.geoserver.platform.Service;
import org.geoserver.web.CapabilitiesHomePageLinkProvider;
import org.geoserver.web.CapabilitiesHomePagePanel;
import org.geoserver.web.ServiceDescriptionProvider;

public class ServiceInfoCapabilitiesProvider
implements CapabilitiesHomePageLinkProvider {
    static Logger LOGGER = Logger.getLogger("org.geoserver.web");

    @Override
    public Component getCapabilitiesComponent(String id) {
        Set<String> skip = this.skipServiceDescriptionProviders();
        ArrayList<CapabilitiesHomePagePanel.CapsInfo> serviceInfoLinks = new ArrayList<CapabilitiesHomePagePanel.CapsInfo>();
        for (Service service : GeoServerExtensions.extensions(Service.class)) {
            CapabilitiesHomePagePanel.CapsInfo ci;
            Object capsLink;
            String serviceId = service.getId();
            if (skip.contains(serviceId.toLowerCase())) continue;
            try {
                ServiceInfo serviceInfo = DisabledServiceCheck.lookupServiceInfo((Service)service);
                if (serviceInfo != null && !serviceInfo.isEnabled()) {
                    continue;
                }
            }
            catch (Exception unexpected) {
                LOGGER.fine("Error while looking up service info for service ");
            }
            if (service.getCustomCapabilitiesLink() != null) {
                capsLink = service.getCustomCapabilitiesLink();
                ci = new CapabilitiesHomePagePanel.CapsInfo(serviceId, service.getVersion(), (String)capsLink);
                serviceInfoLinks.add(ci);
                continue;
            }
            if (!service.getOperations().contains("GetCapabilities")) continue;
            capsLink = "../ows?service=" + serviceId + "&version=" + service.getVersion().toString() + "&request=GetCapabilities";
            ci = new CapabilitiesHomePagePanel.CapsInfo(serviceId, service.getVersion(), (String)capsLink);
            serviceInfoLinks.add(ci);
        }
        if (serviceInfoLinks.isEmpty()) {
            return null;
        }
        return new CapabilitiesHomePagePanel(id, serviceInfoLinks);
    }

    protected Set<String> skipServiceDescriptionProviders() {
        HashSet<String> skip = new HashSet<String>();
        for (ServiceDescriptionProvider provider : GeoServerExtensions.extensions(ServiceDescriptionProvider.class)) {
            for (String serviceType : provider.getServiceTypes()) {
                skip.add(serviceType.toLowerCase());
            }
        }
        return skip;
    }
}

