/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.web;

import java.io.File;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import java.util.function.Supplier;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import org.apache.wicket.Application;
import org.apache.wicket.Component;
import org.apache.wicket.ConverterLocator;
import org.apache.wicket.DefaultExceptionMapper;
import org.apache.wicket.IConverterLocator;
import org.apache.wicket.RuntimeConfigurationType;
import org.apache.wicket.Session;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.core.request.handler.IPageRequestHandler;
import org.apache.wicket.core.request.handler.PageProvider;
import org.apache.wicket.core.util.resource.locator.IResourceStreamLocator;
import org.apache.wicket.csp.CSPDirective;
import org.apache.wicket.markup.html.panel.FeedbackPanel;
import org.apache.wicket.protocol.http.CsrfPreventionRequestCycleListener;
import org.apache.wicket.protocol.http.WebApplication;
import org.apache.wicket.protocol.http.WebSession;
import org.apache.wicket.protocol.http.servlet.ServletWebRequest;
import org.apache.wicket.request.IExceptionMapper;
import org.apache.wicket.request.IRequestHandler;
import org.apache.wicket.request.IRequestHandlerDelegate;
import org.apache.wicket.request.IRequestMapper;
import org.apache.wicket.request.Request;
import org.apache.wicket.request.Response;
import org.apache.wicket.request.component.IRequestablePage;
import org.apache.wicket.request.cycle.IRequestCycleListener;
import org.apache.wicket.request.cycle.RequestCycle;
import org.apache.wicket.request.http.WebRequest;
import org.apache.wicket.request.http.WebResponse;
import org.apache.wicket.request.resource.ResourceReference;
import org.apache.wicket.resource.JQueryResourceReference;
import org.apache.wicket.resource.loader.IStringResourceLoader;
import org.apache.wicket.settings.RequestCycleSettings;
import org.apache.wicket.util.convert.IConverter;
import org.apache.wicket.util.visit.IVisitor;
import org.geoserver.catalog.Catalog;
import org.geoserver.catalog.ValidationException;
import org.geoserver.config.GeoServer;
import org.geoserver.config.GeoServerInfo;
import org.geoserver.platform.GeoServerExtensions;
import org.geoserver.platform.GeoServerResourceLoader;
import org.geoserver.security.GeoServerSecurityManager;
import org.geoserver.web.DynamicCryptoMapper;
import org.geoserver.web.GeoServerErrorPage;
import org.geoserver.web.GeoServerExpiredPage;
import org.geoserver.web.GeoServerHomePage;
import org.geoserver.web.GeoServerResourceStreamLocator;
import org.geoserver.web.GeoServerStringResourceLoader;
import org.geoserver.web.WicketCallback;
import org.geoserver.web.spring.security.GeoServerSession;
import org.geoserver.web.util.DataDirectoryConverterLocator;
import org.geoserver.web.util.GeoToolsConverterAdapter;
import org.geoserver.web.util.converters.StringBBoxConverter;
import org.geoserver.web.wicket.ParamResourceModel;
import org.geotools.data.util.MeasureConverterFactory;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.measure.Measure;
import org.geotools.util.logging.Logging;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationListener;
import org.springframework.security.authentication.event.AuthenticationSuccessEvent;
import org.springframework.security.authentication.event.InteractiveAuthenticationSuccessEvent;

public class GeoServerApplication
extends WebApplication
implements ApplicationContextAware,
ApplicationListener<ApplicationEvent> {
    public static final String LANGUAGE_COOKIE_NAME = "GeoServerUILanguage";
    public static final int LANGUAGE_COOKIE_AGE = 31536000;
    public static Logger LOGGER = Logging.getLogger((String)"org.geoserver.web");
    public static boolean DETECT_BROWSER = Boolean.valueOf(System.getProperty("org.geoserver.web.browser.detect", "true"));
    public static boolean CSP_STRICT = Boolean.valueOf(System.getProperty("org.geoserver.web.csp.strict", "true"));
    public static final String GEOSERVER_CSRF_DISABLED = "GEOSERVER_CSRF_DISABLED";
    public static final String GEOSERVER_CSRF_WHITELIST = "GEOSERVER_CSRF_WHITELIST";
    ApplicationContext applicationContext;
    protected boolean defaultIsRedirect = true;

    public static String getMessage(Component c, Exception e) {
        if (e instanceof ValidationException) {
            ValidationException ve = (ValidationException)e;
            try {
                if (ve.getParameters() == null) {
                    return new ParamResourceModel(ve.getKey(), c, ve.getParameters()).getString();
                }
                return new ParamResourceModel(ve.getKey(), c, ve.getParameters()).getString();
            }
            catch (Exception ex) {
                LOGGER.log(Level.FINE, "i18n not found, proceeding with default message", ex);
            }
        }
        return e.getMessage() == null ? e.toString() : e.getMessage();
    }

    public boolean isDefaultIsRedirect() {
        return this.defaultIsRedirect;
    }

    public void setDefaultIsRedirect(boolean defaultIsRedirect) {
        this.defaultIsRedirect = defaultIsRedirect;
    }

    public Class<GeoServerHomePage> getHomePage() {
        return GeoServerHomePage.class;
    }

    public static GeoServerApplication get() {
        return (GeoServerApplication)Application.get();
    }

    public ApplicationContext getApplicationContext() {
        return this.applicationContext;
    }

    public GeoServer getGeoServer() {
        return this.getBeanOfType(GeoServer.class);
    }

    public Catalog getCatalog() {
        return this.getGeoServer().getCatalog();
    }

    public GeoServerSecurityManager getSecurityManager() {
        return this.getBeanOfType(GeoServerSecurityManager.class);
    }

    public GeoServerResourceLoader getResourceLoader() {
        return this.getBeanOfType(GeoServerResourceLoader.class);
    }

    public <T> T getBeanOfType(Class<T> type) {
        return (T)GeoServerExtensions.bean(type, (ApplicationContext)this.getApplicationContext());
    }

    public Object getBean(String name) {
        return GeoServerExtensions.bean((String)name);
    }

    public <T> List<T> getBeansOfType(Class<T> type) {
        return GeoServerExtensions.extensions(type, (ApplicationContext)this.getApplicationContext());
    }

    public void clearWicketCaches() {
        this.getResourceSettings().getPropertiesFactory().clearCache();
        this.getResourceSettings().getLocalizer().clearCache();
    }

    public String getNonce() {
        return this.getCspSettings().getNonce(RequestCycle.get());
    }

    protected void init() {
        this.getResourceSettings().setUseMinifiedResources(false);
        this.getResourceSettings().setResourceStreamLocator((IResourceStreamLocator)new GeoServerResourceStreamLocator());
        if (CSP_STRICT) {
            this.getCspSettings().blocking().strict().add(CSPDirective.IMG_SRC, new String[]{"data:"});
        } else {
            this.getCspSettings().blocking().disabled();
            this.getCspSettings().reporting().strict().add(CSPDirective.IMG_SRC, new String[]{"data:"});
        }
        List<IStringResourceLoader> alternateResourceLoaders = this.getBeansOfType(IStringResourceLoader.class);
        for (IStringResourceLoader loader : alternateResourceLoaders) {
            LOGGER.info("Registering alternate resource loader: " + loader);
            this.getResourceSettings().getStringResourceLoaders().add(loader);
        }
        this.getResourceSettings().getStringResourceLoaders().add(0, new GeoServerStringResourceLoader());
        this.getDebugSettings().setAjaxDebugModeEnabled(false);
        this.getJavaScriptLibrarySettings().setJQueryReference((ResourceReference)JQueryResourceReference.INSTANCE_3);
        this.getApplicationSettings().setPageExpiredErrorPage(GeoServerExpiredPage.class);
        GeoServerSecurityManager securityManager = this.getBeanOfType(GeoServerSecurityManager.class);
        this.setRootRequestMapper((IRequestMapper)new DynamicCryptoMapper(this.getRootRequestMapper(), securityManager, this));
        this.getRequestCycleListeners().add((Object)new CallbackRequestCycleListener(this));
        Boolean geoserverCsrfDisabled = Boolean.valueOf(GeoServerExtensions.getProperty((String)GEOSERVER_CSRF_DISABLED));
        String geoserverCsrfWhitelist = GeoServerExtensions.getProperty((String)GEOSERVER_CSRF_WHITELIST);
        ArrayList<String[]> csrfListenersToRemove = new ArrayList<String[]>();
        for (String[] listener : this.getRequestCycleListeners()) {
            if (!(listener instanceof CsrfPreventionRequestCycleListener)) continue;
            csrfListenersToRemove.add(listener);
        }
        for (String[] listener : csrfListenersToRemove) {
            this.getRequestCycleListeners().remove((Object)listener);
        }
        CsrfPreventionRequestCycleListener csrfListener = new CsrfPreventionRequestCycleListener();
        if (!geoserverCsrfDisabled.booleanValue()) {
            if (geoserverCsrfWhitelist != null && !"".equals(geoserverCsrfWhitelist.trim())) {
                for (String origin : geoserverCsrfWhitelist.split(",")) {
                    csrfListener.addAcceptedOrigin(origin.trim());
                }
            }
            this.getRequestCycleListeners().add((Object)csrfListener);
        }
        this.getRequestCycleListeners().add((Object)new FeedbackPanelAjaxListener());
        GeoServerInfo.WebUIMode webUIMode = this.getGeoServer().getGlobal().getWebUIMode();
        if (webUIMode == null) {
            webUIMode = GeoServerInfo.WebUIMode.DEFAULT;
        }
        switch (webUIMode) {
            case DO_NOT_REDIRECT: {
                this.getRequestCycleSettings().setRenderStrategy(RequestCycleSettings.RenderStrategy.ONE_PASS_RENDER);
                break;
            }
            case REDIRECT: {
                this.getRequestCycleSettings().setRenderStrategy(RequestCycleSettings.RenderStrategy.REDIRECT_TO_BUFFER);
                break;
            }
            case DEFAULT: {
                this.getRequestCycleSettings().setRenderStrategy(this.defaultIsRedirect ? RequestCycleSettings.RenderStrategy.REDIRECT_TO_BUFFER : RequestCycleSettings.RenderStrategy.ONE_PASS_RENDER);
            }
        }
    }

    public Supplier<IExceptionMapper> getExceptionMapperProvider() {
        return () -> new DefaultExceptionMapper(){

            protected IRequestHandler mapUnexpectedExceptions(Exception e, Application application) {
                return this.createPageRequestHandler(new PageProvider((IRequestablePage)new GeoServerErrorPage(e)));
            }
        };
    }

    public RuntimeConfigurationType getConfigurationType() {
        String config = GeoServerExtensions.getProperty((String)"wicket.configuration", (ApplicationContext)this.getApplicationContext());
        if (config == null) {
            return RuntimeConfigurationType.DEPLOYMENT;
        }
        if (!"DEPLOYMENT".equalsIgnoreCase(config) && !"DEVELOPMENT".equalsIgnoreCase(config)) {
            LOGGER.warning("Unknown Wicket configuration value '" + config + "', defaulting to DEPLOYMENT");
            return RuntimeConfigurationType.DEPLOYMENT;
        }
        return RuntimeConfigurationType.valueOf((String)config.toUpperCase());
    }

    public Session newSession(Request request, Response response) {
        GeoServerSession s = new GeoServerSession(request);
        Locale locale = this.getLocaleFromCookies(request);
        if (locale != null) {
            this.refreshLocaleCookie(response, locale);
            s.setLocale(locale);
        } else if (s.getLocale() == null) {
            s.setLocale(Locale.ENGLISH);
        }
        return s;
    }

    public Locale getLocaleFromCookies(Request request) {
        if (request instanceof WebRequest) {
            List cookies = ((WebRequest)request).getCookies();
            for (Cookie cookie : cookies) {
                if (!LANGUAGE_COOKIE_NAME.equals(cookie.getName())) continue;
                cookie.setMaxAge(31536000);
                return new Locale(cookie.getValue());
            }
        }
        return null;
    }

    public void refreshLocaleCookie(Response response, Locale locale) {
        Cookie languageCookie = new Cookie(LANGUAGE_COOKIE_NAME, locale.getLanguage());
        languageCookie.setMaxAge(31536000);
        ((WebResponse)response).addCookie(languageCookie);
    }

    protected IConverterLocator newConverterLocator() {
        ConverterLocator locator = new ConverterLocator();
        locator.set(ReferencedEnvelope.class, (IConverter)new GeoToolsConverterAdapter(new StringBBoxConverter(), ReferencedEnvelope.class));
        DataDirectoryConverterLocator dd = new DataDirectoryConverterLocator(this.getResourceLoader());
        locator.set(File.class, dd.getConverter(File.class));
        locator.set(URI.class, dd.getConverter(URI.class));
        locator.set(URL.class, dd.getConverter(URL.class));
        locator.set(Measure.class, (IConverter)new GeoToolsConverterAdapter(MeasureConverterFactory.CONVERTER, Measure.class));
        return locator;
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }

    public HttpServletRequest servletRequest() {
        RequestCycle cycle = RequestCycle.get();
        if (cycle == null) {
            throw new IllegalStateException("Method must be called from a wicket request thread");
        }
        return this.servletRequest(cycle.getRequest());
    }

    public HttpServletRequest servletRequest(Request req) {
        if (req == null || !(req instanceof ServletWebRequest)) {
            throw new IllegalStateException("Request not of type ServletWebRequest, was: " + (req == null ? "null" : req.getClass().getName()));
        }
        return ((ServletWebRequest)req).getContainerRequest();
    }

    public void onApplicationEvent(ApplicationEvent event) {
        if ((event instanceof AuthenticationSuccessEvent || event instanceof InteractiveAuthenticationSuccessEvent) && Session.exists()) {
            WebSession.get().replaceSession();
        }
    }

    private static class FeedbackPanelAjaxListener
    implements IRequestCycleListener {
        private FeedbackPanelAjaxListener() {
        }

        public void onRequestHandlerResolved(RequestCycle cycle, IRequestHandler handler) {
            if (!(handler instanceof AjaxRequestTarget)) {
                return;
            }
            AjaxRequestTarget target = (AjaxRequestTarget)handler;
            IVisitor targetAdder = (component, visit) -> {
                if (component.getOutputMarkupId() && component.getMarkup() != null) {
                    target.add(new Component[]{component});
                }
            };
            Optional.ofNullable(target.getPage()).ifPresent(page -> page.visitChildren(FeedbackPanel.class, targetAdder));
        }
    }

    static class CallbackRequestCycleListener
    implements IRequestCycleListener {
        private List<WicketCallback> callbacks;

        public CallbackRequestCycleListener(GeoServerApplication app) {
            this.callbacks = app.getBeansOfType(WicketCallback.class);
        }

        public void onBeginRequest(RequestCycle cycle) {
            for (WicketCallback callback : this.callbacks) {
                callback.onBeginRequest();
            }
        }

        public void onEndRequest(RequestCycle cycle) {
            for (WicketCallback callback : this.callbacks) {
                callback.onEndRequest();
            }
        }

        public void onDetach(RequestCycle cycle) {
            for (WicketCallback callback : this.callbacks) {
                callback.onAfterTargetsDetached();
            }
        }

        public void onRequestHandlerScheduled(RequestCycle cycle, IRequestHandler handler) {
            this.processHandler(cycle, handler);
        }

        private void processHandler(RequestCycle cycle, IRequestHandler handler) {
            if (handler instanceof IPageRequestHandler) {
                IPageRequestHandler pageHandler = (IPageRequestHandler)handler;
                Class pageClass = pageHandler.getPageClass();
                for (WicketCallback callback : this.callbacks) {
                    callback.onRequestTargetSet(cycle, pageClass);
                }
            } else if (handler instanceof IRequestHandlerDelegate) {
                IRequestHandlerDelegate delegator = (IRequestHandlerDelegate)handler;
                this.processHandler(cycle, delegator.getDelegateHandler());
            }
        }

        public void onRequestHandlerResolved(RequestCycle cycle, IRequestHandler handler) {
            this.processHandler(cycle, handler);
        }

        public IRequestHandler onException(RequestCycle cycle, Exception ex) {
            for (WicketCallback callback : this.callbacks) {
                callback.onRuntimeException(cycle, ex);
            }
            return null;
        }
    }
}

