/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.web.wicket;

import java.io.Serializable;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;
import org.geoserver.web.wicket.SRSToCRSModel;
import org.geotools.referencing.CRS;
import org.junit.Assert;
import org.junit.Test;

public class SRSToCRSModelTest {
    @Test
    public void testNullSRS() throws Exception {
        Model srs = new Model(null);
        SRSToCRSModel crs = new SRSToCRSModel((IModel)srs);
        Assert.assertNull((Object)crs.getObject());
        crs.setObject(null);
        Assert.assertNull((Object)srs.getObject());
    }

    @Test
    public void testNonNullSRS() throws Exception {
        Model srs = new Model((Serializable)((Object)"EPSG:32632"));
        SRSToCRSModel crs = new SRSToCRSModel((IModel)srs);
        Assert.assertEquals((Object)CRS.decode((String)"EPSG:32632"), (Object)crs.getObject());
        crs.setObject(CRS.decode((String)"EPSG:4326"));
        Assert.assertEquals((Object)"EPSG:4326", (Object)srs.getObject());
    }

    @Test
    public void testPlanetary() throws Exception {
        Model srs = new Model((Serializable)((Object)"IAU:30100"));
        SRSToCRSModel crs = new SRSToCRSModel((IModel)srs);
        Assert.assertEquals((Object)CRS.decode((String)"IAU:30100"), (Object)crs.getObject());
        crs.setObject(CRS.decode((String)"IAU:1000"));
        Assert.assertEquals((Object)"IAU:1000", (Object)srs.getObject());
    }
}

