/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.web.wicket;

import java.util.ArrayList;
import java.util.List;
import org.apache.wicket.Page;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.util.ListModel;
import org.apache.wicket.util.tester.FormTester;
import org.apache.wicket.util.tester.WicketTester;
import org.geoserver.catalog.Keyword;
import org.geoserver.catalog.KeywordInfo;
import org.geoserver.web.FormTestPage;
import org.geoserver.web.GeoServerWicketTestSupport;
import org.geoserver.web.wicket.KeywordsEditor;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class KeywordsEditorTest {
    WicketTester tester;
    List<KeywordInfo> keywords;

    @Before
    public void setUp() throws Exception {
        this.tester = new WicketTester();
        GeoServerWicketTestSupport.initResourceSettings(this.tester);
        this.keywords = new ArrayList<KeywordInfo>();
        this.keywords.add((KeywordInfo)new Keyword("one"));
        this.keywords.add((KeywordInfo)new Keyword("two"));
        this.keywords.add((KeywordInfo)new Keyword("three"));
        this.tester.startPage((Page)new FormTestPage(id -> new KeywordsEditor(id, (IModel)new ListModel(this.keywords))));
    }

    @Test
    public void testRemove() throws Exception {
        FormTester ft = this.tester.newFormTester("form");
        ft.selectMultiple("panel:keywords", new int[]{0, 2});
        this.tester.executeAjaxEvent("form:panel:removeKeywords", "click");
        Assert.assertEquals((long)1L, (long)this.keywords.size());
        Assert.assertEquals((Object)"two", (Object)this.keywords.get(0).getValue());
    }

    @Test
    public void testAdd() throws Exception {
        FormTester ft = this.tester.newFormTester("form");
        ft.setValue("panel:newKeyword", "four");
        ft.setValue("panel:lang", "en");
        ft.setValue("panel:vocab", "foobar");
        this.tester.executeAjaxEvent("form:panel:addKeyword", "click");
        Assert.assertEquals((long)4L, (long)this.keywords.size());
        Assert.assertEquals((Object)"four", (Object)this.keywords.get(3).getValue());
        Assert.assertEquals((Object)"en", (Object)this.keywords.get(3).getLanguage());
        Assert.assertEquals((Object)"foobar", (Object)this.keywords.get(3).getVocabulary());
    }
}

