/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.web.data.workspace;

import java.io.IOException;
import java.io.Serializable;
import org.apache.wicket.extensions.markup.html.tabs.TabbedPanel;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.html.form.CheckBox;
import org.apache.wicket.markup.html.form.TextField;
import org.apache.wicket.markup.html.list.ListView;
import org.apache.wicket.util.tester.FormTester;
import org.geoserver.catalog.Catalog;
import org.geoserver.catalog.CatalogInfo;
import org.geoserver.catalog.WorkspaceInfo;
import org.geoserver.data.test.MockTestData;
import org.geoserver.platform.GeoServerExtensions;
import org.geoserver.platform.GeoServerExtensionsHelper;
import org.geoserver.security.ResourceAccessManager;
import org.geoserver.security.SecureCatalogImpl;
import org.geoserver.security.TestResourceAccessManager;
import org.geoserver.web.GeoServerWicketTestSupport;
import org.geoserver.web.data.workspace.WorkspaceNewPage;
import org.geoserver.web.data.workspace.WorkspacePage;
import org.geoserver.web.security.AccessDataRuleInfoManager;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.springframework.security.core.Authentication;

public class WorkspaceNewPageTest
extends GeoServerWicketTestSupport {
    @Before
    public void init() {
        this.login();
        tester.startPage(WorkspaceNewPage.class);
    }

    @Test
    public void testLoad() {
        tester.assertRenderedPage(WorkspaceNewPage.class);
        tester.assertNoErrorMessage();
        tester.assertComponent("form:tabs:panel:name", TextField.class);
        tester.assertComponent("form:tabs:panel:uri", TextField.class);
    }

    @Test
    public void testNameRequired() {
        FormTester form = tester.newFormTester("form");
        form.setValue("tabs:panel:uri", "http://www.geoserver.org");
        form.submit("submit");
        tester.assertRenderedPage(WorkspaceNewPage.class);
        tester.assertErrorMessages((Serializable[])new String[]{"Field 'Name' is required."});
    }

    @Test
    public void testURIRequired() {
        FormTester form = tester.newFormTester("form");
        form.setValue("tabs:panel:name", "test");
        form.submit("submit");
        tester.assertRenderedPage(WorkspaceNewPage.class);
        tester.assertErrorMessages((Serializable[])new String[]{"Field 'uri' is required."});
    }

    @Test
    public void testValid() {
        FormTester form = tester.newFormTester("form");
        form.setValue("tabs:panel:name", "abc");
        form.setValue("tabs:panel:uri", "http://www.geoserver.org");
        form.setValue("tabs:panel:default", "true");
        form.submit("submit");
        tester.assertRenderedPage(WorkspacePage.class);
        tester.assertNoErrorMessage();
        Assert.assertEquals((Object)"abc", (Object)this.getCatalog().getDefaultWorkspace().getName());
    }

    @Test
    public void testInvalidURI() {
        FormTester form = tester.newFormTester("form");
        form.setValue("tabs:panel:name", "def");
        form.setValue("tabs:panel:uri", "not a valid uri");
        form.submit("submit");
        tester.assertRenderedPage(WorkspaceNewPage.class);
        tester.assertErrorMessages((Serializable[])new String[]{"Invalid URI syntax: not a valid uri"});
    }

    @Test
    public void testInvalidName() {
        FormTester form = tester.newFormTester("form");
        form.setValue("tabs:panel:name", "default");
        form.setValue("tabs:panel:uri", "http://www.geoserver.org");
        form.submit("submit");
        tester.assertRenderedPage(WorkspaceNewPage.class);
        tester.assertErrorMessages((Serializable[])new String[]{"Invalid workspace name: \"default\" is a reserved keyword"});
    }

    @Test
    public void testDuplicateURI() {
        FormTester form = tester.newFormTester("form");
        form.setValue("tabs:panel:name", "def");
        form.setValue("tabs:panel:uri", MockTestData.CITE_URI);
        form.submit("submit");
        tester.assertRenderedPage(WorkspaceNewPage.class);
        tester.assertErrorMessages((Serializable[])new String[]{"Namespace with URI '" + MockTestData.CITE_URI + "' already exists."});
        Assert.assertNull((Object)this.getCatalog().getWorkspaceByName("def"));
        Assert.assertNull((Object)this.getCatalog().getNamespaceByPrefix("def"));
    }

    @Test
    public void testDuplicateName() {
        FormTester form = tester.newFormTester("form");
        form.setValue("tabs:panel:name", MockTestData.CITE_PREFIX);
        form.setValue("tabs:panel:uri", "http://www.geoserver.org");
        form.submit("submit");
        tester.assertRenderedPage(WorkspaceNewPage.class);
        tester.assertErrorMessages((Serializable[])new String[]{"Workspace named '" + MockTestData.CITE_PREFIX + "' already exists."});
    }

    @Test
    public void addIsolatedWorkspacesWithSameNameSpace() {
        Catalog catalog = this.getCatalog();
        this.createWorkspace("test_a", "http://www.test.org", false);
        tester.assertRenderedPage(WorkspacePage.class);
        tester.assertNoErrorMessage();
        MatcherAssert.assertThat((Object)catalog.getWorkspaceByName("test_a"), (Matcher)CoreMatchers.notNullValue());
        MatcherAssert.assertThat((Object)catalog.getWorkspaceByName("test_a").isIsolated(), (Matcher)CoreMatchers.is((Object)false));
        MatcherAssert.assertThat((Object)catalog.getNamespaceByPrefix("test_a"), (Matcher)CoreMatchers.notNullValue());
        MatcherAssert.assertThat((Object)catalog.getNamespaceByPrefix("test_a").isIsolated(), (Matcher)CoreMatchers.is((Object)false));
        MatcherAssert.assertThat((Object)catalog.getNamespaceByURI("http://www.test.org"), (Matcher)CoreMatchers.notNullValue());
        this.createWorkspace("test_b", "http://www.test.org", false);
        tester.assertRenderedPage(WorkspaceNewPage.class);
        tester.assertErrorMessages((Serializable[])new String[]{"Namespace with URI 'http://www.test.org' already exists."});
        MatcherAssert.assertThat((Object)catalog.getWorkspaceByName("test_b"), (Matcher)CoreMatchers.nullValue());
        MatcherAssert.assertThat((Object)catalog.getNamespaceByPrefix("test_b"), (Matcher)CoreMatchers.nullValue());
        MatcherAssert.assertThat((Object)catalog.getNamespaceByURI("http://www.test.org"), (Matcher)CoreMatchers.notNullValue());
        MatcherAssert.assertThat((Object)catalog.getNamespaceByURI("http://www.test.org").getPrefix(), (Matcher)CoreMatchers.is((Object)"test_a"));
        this.createWorkspace("test_b", "http://www.test.org", true);
        tester.assertRenderedPage(WorkspacePage.class);
        tester.assertNoErrorMessage();
        MatcherAssert.assertThat((Object)catalog.getWorkspaceByName("test_b"), (Matcher)CoreMatchers.notNullValue());
        MatcherAssert.assertThat((Object)catalog.getWorkspaceByName("test_b").isIsolated(), (Matcher)CoreMatchers.is((Object)true));
        MatcherAssert.assertThat((Object)catalog.getNamespaceByPrefix("test_b"), (Matcher)CoreMatchers.notNullValue());
        MatcherAssert.assertThat((Object)catalog.getNamespaceByPrefix("test_b").isIsolated(), (Matcher)CoreMatchers.is((Object)true));
        MatcherAssert.assertThat((Object)catalog.getNamespaceByPrefix("test_b").getURI(), (Matcher)CoreMatchers.is((Object)"http://www.test.org"));
        MatcherAssert.assertThat((Object)catalog.getNamespaceByURI("http://www.test.org").getPrefix(), (Matcher)CoreMatchers.is((Object)"test_a"));
        MatcherAssert.assertThat((Object)catalog.getNamespaceByURI("http://www.test.org").isIsolated(), (Matcher)CoreMatchers.is((Object)false));
    }

    private void createWorkspace(String name, String namespace, boolean isolated) {
        this.init();
        FormTester form = tester.newFormTester("form");
        form.setValue("tabs:panel:name", name);
        form.setValue("tabs:panel:uri", namespace);
        form.setValue("tabs:panel:isolated", isolated);
        form.submit("submit");
    }

    @Test
    public void testSecurityTabLoad() {
        FormTester form = tester.newFormTester("form");
        form.setValue("tabs:panel:name", "abc");
        form.setValue("tabs:panel:uri", "http://www.geoserver.org");
        tester.clickLink("form:tabs:tabs-container:tabs:1:link");
        tester.assertComponent("form:tabs:panel:listContainer", WebMarkupContainer.class);
        tester.assertComponent("form:tabs:panel:listContainer:selectAll", CheckBox.class);
        tester.assertComponent("form:tabs:panel:listContainer:rules", ListView.class);
        tester.assertRenderedPage(WorkspaceNewPage.class);
        tester.assertNoErrorMessage();
    }

    @Test
    public void testCreateWsWithAccessRules() throws IOException {
        AccessDataRuleInfoManager manager = new AccessDataRuleInfoManager();
        FormTester form = tester.newFormTester("form");
        form.setValue("tabs:panel:name", "cba");
        form.setValue("tabs:panel:uri", "http://www.geoserver2.org");
        tester.clickLink("form:tabs:tabs-container:tabs:1:link");
        form.setValue("tabs:panel:listContainer:rules:0:admin", true);
        form.submit("submit");
        tester.assertNoErrorMessage();
        WorkspaceInfo wsInfo = this.getCatalog().getWorkspaceByName("cba");
        Assert.assertEquals((Object)"cba", (Object)wsInfo.getName());
        Assert.assertEquals((long)1L, (long)manager.getResourceRule(wsInfo.getName(), (CatalogInfo)wsInfo).size());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testSecurityTabInactiveWithNoDeafaultAccessManager() {
        TestResourceAccessManager manager = new TestResourceAccessManager();
        SecureCatalogImpl oldSc = (SecureCatalogImpl)GeoServerExtensions.bean((String)"secureCatalog");
        SecureCatalogImpl sc = new SecureCatalogImpl(this.getCatalog(), (ResourceAccessManager)manager){

            protected boolean isAdmin(Authentication authentication) {
                return false;
            }
        };
        applicationContext.getBeanFactory().destroyBean((Object)"secureCatalog");
        GeoServerExtensionsHelper.clear();
        GeoServerExtensionsHelper.singleton((String)"secureCatalog", (Object)sc, (Class[])new Class[]{SecureCatalogImpl.class});
        tester.startPage(WorkspaceNewPage.class);
        try {
            tester.newFormTester("form");
            TabbedPanel tabs = (TabbedPanel)tester.getComponentFromLastRenderedPage("form:tabs");
            Assert.assertEquals((long)1L, (long)tabs.getTabs().size());
        }
        catch (Throwable throwable) {
            applicationContext.getBeanFactory().destroyBean((Object)"secureCatalog");
            GeoServerExtensionsHelper.clear();
            GeoServerExtensionsHelper.singleton((String)"secureCatalog", (Object)oldSc, (Class[])new Class[]{SecureCatalogImpl.class});
            throw throwable;
        }
        applicationContext.getBeanFactory().destroyBean((Object)"secureCatalog");
        GeoServerExtensionsHelper.clear();
        GeoServerExtensionsHelper.singleton((String)"secureCatalog", (Object)oldSc, (Class[])new Class[]{SecureCatalogImpl.class});
    }
}

