/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.web.data.workspace;

import java.io.IOException;
import java.io.Serializable;
import java.util.HashSet;
import java.util.List;
import org.apache.wicket.Page;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.html.form.CheckBox;
import org.apache.wicket.markup.html.form.ValidationErrorFeedback;
import org.apache.wicket.markup.html.list.ListView;
import org.apache.wicket.util.tester.FormTester;
import org.geoserver.catalog.Catalog;
import org.geoserver.catalog.CatalogInfo;
import org.geoserver.catalog.DataStoreInfo;
import org.geoserver.catalog.NamespaceInfo;
import org.geoserver.catalog.WorkspaceInfo;
import org.geoserver.catalog.impl.NamespaceInfoImpl;
import org.geoserver.catalog.impl.WorkspaceInfoImpl;
import org.geoserver.config.GeoServer;
import org.geoserver.config.SettingsInfo;
import org.geoserver.data.test.MockData;
import org.geoserver.security.AccessMode;
import org.geoserver.security.impl.DataAccessRule;
import org.geoserver.web.GeoServerWicketTestSupport;
import org.geoserver.web.data.workspace.WorkspaceEditPage;
import org.geoserver.web.data.workspace.WorkspacePage;
import org.geoserver.web.security.AccessDataRuleInfoManager;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class WorkspaceEditPageTest
extends GeoServerWicketTestSupport {
    private WorkspaceInfo citeWorkspace;

    @Before
    public void init() {
        this.login();
        this.citeWorkspace = this.getCatalog().getWorkspaceByName(MockData.CITE_PREFIX);
        GeoServer gs = this.getGeoServer();
        SettingsInfo s = gs.getSettings(this.citeWorkspace);
        if (s != null) {
            gs.remove(s);
        }
        NamespaceInfo citeNS = this.getCatalog().getNamespaceByPrefix(MockData.CITE_PREFIX);
        citeNS.setURI(MockData.CITE_URI);
        this.getCatalog().save(citeNS);
        tester.startPage((Page)new WorkspaceEditPage(this.citeWorkspace));
    }

    @Test
    public void testURIRequired() {
        FormTester form = tester.newFormTester("form");
        form.setValue("tabs:panel:uri", "");
        form.submit("save");
        tester.assertRenderedPage(WorkspaceEditPage.class);
        tester.assertErrorMessages((Serializable[])new String[]{"Field 'uri' is required."});
    }

    @Test
    public void testLoad() {
        tester.assertRenderedPage(WorkspaceEditPage.class);
        tester.assertNoErrorMessage();
        tester.assertModelValue("form:tabs:panel:name", (Object)MockData.CITE_PREFIX);
        tester.assertModelValue("form:tabs:panel:uri", (Object)MockData.CITE_URI);
    }

    @Test
    public void testValidURI() {
        FormTester form = tester.newFormTester("form");
        form.setValue("tabs:panel:uri", "http://www.geoserver.org");
        form.submit("save");
        tester.assertRenderedPage(WorkspacePage.class);
        tester.assertNoErrorMessage();
    }

    @Test
    public void testValidURIApply() {
        FormTester form = tester.newFormTester("form");
        String newTestURI = "http://www.geoserver.org/abcde";
        form.setValue("tabs:panel:uri", newTestURI);
        form.submit("apply");
        tester.assertRenderedPage(WorkspaceEditPage.class);
        tester.assertNoErrorMessage();
        Assert.assertEquals((Object)newTestURI, (Object)this.getCatalog().getNamespaceByPrefix(this.citeWorkspace.getName()).getURI());
    }

    @Test
    public void testInvalidURI() {
        FormTester form = tester.newFormTester("form");
        form.setValue("tabs:panel:uri", "not a valid uri");
        form.submit("save");
        tester.assertRenderedPage(WorkspaceEditPage.class);
        List messages = tester.getMessages(400);
        Assert.assertEquals((long)1L, (long)messages.size());
        Assert.assertEquals((Object)"Invalid URI syntax: not a valid uri", (Object)((ValidationErrorFeedback)messages.get(0)).getMessage());
    }

    @Test
    public void testInvalidURIApply() {
        FormTester form = tester.newFormTester("form");
        form.setValue("tabs:panel:uri", "not a valid uri");
        form.submit("apply");
        tester.assertRenderedPage(WorkspaceEditPage.class);
        List messages = tester.getMessages(400);
        Assert.assertEquals((long)1L, (long)messages.size());
        Assert.assertEquals((Object)"Invalid URI syntax: not a valid uri", (Object)((ValidationErrorFeedback)messages.get(0)).getMessage());
    }

    @Test
    public void testUpdatesDataStoresNamespace() {
        Catalog catalog = this.getCatalog();
        List storesInitial = catalog.getStoresByWorkspace(this.citeWorkspace, DataStoreInfo.class);
        NamespaceInfo citeNamespace = catalog.getNamespaceByPrefix(this.citeWorkspace.getName());
        for (DataStoreInfo store : storesInitial) {
            Assert.assertEquals((Object)citeNamespace.getURI(), store.getConnectionParameters().get("namespace"));
        }
        FormTester form = tester.newFormTester("form");
        String newNsURI = "http://www.geoserver.org/changed";
        form.setValue("tabs:panel:uri", "http://www.geoserver.org/changed");
        form.submit("save");
        tester.assertNoErrorMessage();
        List storesChanged = catalog.getStoresByWorkspace(this.citeWorkspace, DataStoreInfo.class);
        for (DataStoreInfo store : storesChanged) {
            Assert.assertEquals((Object)"http://www.geoserver.org/changed", store.getConnectionParameters().get("namespace"));
        }
    }

    @Test
    public void testDefaultCheckbox() {
        Assert.assertNotEquals((Object)this.getCatalog().getDefaultWorkspace().getName(), (Object)MockData.CITE_PREFIX);
        FormTester form = tester.newFormTester("form");
        form.setValue("tabs:panel:default", true);
        form.submit("save");
        tester.assertNoErrorMessage();
        Assert.assertEquals((Object)MockData.CITE_PREFIX, (Object)this.getCatalog().getDefaultWorkspace().getName());
    }

    @Test
    public void testEnableSettings() throws Exception {
        GeoServer gs = this.getGeoServer();
        Assert.assertNull((Object)gs.getSettings(this.citeWorkspace));
        FormTester form = tester.newFormTester("form");
        form.setValue("tabs:panel:settings:enabled", true);
        form.submit("save");
        tester.assertNoErrorMessage();
        Assert.assertNotNull((Object)gs.getSettings(this.citeWorkspace));
    }

    @Test
    public void testLocalworkspaceRemovePrefix() throws Exception {
        GeoServer gs = this.getGeoServer();
        SettingsInfo settings = gs.getFactory().createSettings();
        settings.setLocalWorkspaceIncludesPrefix(true);
        settings.setWorkspace(this.citeWorkspace);
        gs.add(settings);
        Assert.assertNotNull((Object)gs.getSettings(this.citeWorkspace));
        tester.startPage((Page)new WorkspaceEditPage(this.citeWorkspace));
        tester.assertRenderedPage(WorkspaceEditPage.class);
        FormTester form = tester.newFormTester("form");
        form.setValue("tabs:panel:settings:settingsContainer:otherSettings:localWorkspaceIncludesPrefix", false);
        form.submit("save");
        Assert.assertFalse((boolean)settings.isLocalWorkspaceIncludesPrefix());
    }

    @Test
    public void testDisableSettings() throws Exception {
        GeoServer gs = this.getGeoServer();
        SettingsInfo settings = gs.getFactory().createSettings();
        settings.setProxyBaseUrl("http://foo.org");
        settings.setWorkspace(this.citeWorkspace);
        gs.add(settings);
        Assert.assertNotNull((Object)gs.getSettings(this.citeWorkspace));
        tester.startPage((Page)new WorkspaceEditPage(this.citeWorkspace));
        tester.assertRenderedPage(WorkspaceEditPage.class);
        FormTester form = tester.newFormTester("form");
        Assert.assertEquals((Object)"http://foo.org", (Object)form.getTextComponentValue("tabs:panel:settings:settingsContainer:otherSettings:proxyBaseUrl"));
        form.setValue("tabs:panel:settings:enabled", false);
        form.submit("save");
        Assert.assertNull((Object)gs.getSettings(this.citeWorkspace));
    }

    @Test
    public void testDisablingIsolatedWorkspace() {
        this.createWorkspace("test_a1", "http://www.test_a.org", false);
        this.createWorkspace("test_a2", "http://www.test_a.org", true);
        this.updateWorkspace("test_a2", "test_a2", "http://www.test_a.org", false);
        tester.assertRenderedPage(WorkspaceEditPage.class);
        tester.assertErrorMessages((Serializable[])new String[]{"Namespace with URI 'http://www.test_a.org' already exists."});
        this.updateWorkspace("test_a1", "test_a1", "http://www.test_a.org", true);
        tester.assertRenderedPage(WorkspacePage.class);
        tester.assertNoErrorMessage();
        this.updateWorkspace("test_a2", "test_a2", "http://www.test_a.org", false);
        tester.assertRenderedPage(WorkspacePage.class);
        tester.assertNoErrorMessage();
        Catalog catalog = this.getCatalog();
        MatcherAssert.assertThat((Object)catalog.getWorkspaceByName("test_a1"), (Matcher)CoreMatchers.notNullValue());
        MatcherAssert.assertThat((Object)catalog.getWorkspaceByName("test_a1").isIsolated(), (Matcher)CoreMatchers.is((Object)true));
        MatcherAssert.assertThat((Object)catalog.getNamespaceByPrefix("test_a1"), (Matcher)CoreMatchers.notNullValue());
        MatcherAssert.assertThat((Object)catalog.getNamespaceByPrefix("test_a1").getURI(), (Matcher)CoreMatchers.is((Object)"http://www.test_a.org"));
        MatcherAssert.assertThat((Object)catalog.getNamespaceByPrefix("test_a1").isIsolated(), (Matcher)CoreMatchers.is((Object)true));
        MatcherAssert.assertThat((Object)catalog.getWorkspaceByName("test_a2"), (Matcher)CoreMatchers.notNullValue());
        MatcherAssert.assertThat((Object)catalog.getWorkspaceByName("test_a2").isIsolated(), (Matcher)CoreMatchers.is((Object)false));
        MatcherAssert.assertThat((Object)catalog.getNamespaceByPrefix("test_a2"), (Matcher)CoreMatchers.notNullValue());
        MatcherAssert.assertThat((Object)catalog.getNamespaceByPrefix("test_a2").getURI(), (Matcher)CoreMatchers.is((Object)"http://www.test_a.org"));
        MatcherAssert.assertThat((Object)catalog.getNamespaceByPrefix("test_a2").isIsolated(), (Matcher)CoreMatchers.is((Object)false));
        MatcherAssert.assertThat((Object)catalog.getNamespaceByURI("http://www.test_a.org").getPrefix(), (Matcher)CoreMatchers.is((Object)"test_a2"));
    }

    @Test
    public void testUpdatingIsolatedWorkspaceName() {
        this.createWorkspace("test_b1", "http://www.test_b.org", false);
        this.createWorkspace("test_b2", "http://www.test_b.org", true);
        this.updateWorkspace("test_b2", "test_b3", "http://www.test_b.org", false);
        tester.assertRenderedPage(WorkspaceEditPage.class);
        tester.assertErrorMessages((Serializable[])new String[]{"Namespace with URI 'http://www.test_b.org' already exists."});
        Catalog catalog = this.getCatalog();
        MatcherAssert.assertThat((Object)catalog.getWorkspaceByName("test_b1"), (Matcher)CoreMatchers.notNullValue());
        MatcherAssert.assertThat((Object)catalog.getWorkspaceByName("test_b1").isIsolated(), (Matcher)CoreMatchers.is((Object)false));
        MatcherAssert.assertThat((Object)catalog.getNamespaceByPrefix("test_b1"), (Matcher)CoreMatchers.notNullValue());
        MatcherAssert.assertThat((Object)catalog.getNamespaceByPrefix("test_b1").getURI(), (Matcher)CoreMatchers.is((Object)"http://www.test_b.org"));
        MatcherAssert.assertThat((Object)catalog.getNamespaceByPrefix("test_b1").isIsolated(), (Matcher)CoreMatchers.is((Object)false));
        MatcherAssert.assertThat((Object)catalog.getWorkspaceByName("test_b2"), (Matcher)CoreMatchers.notNullValue());
        MatcherAssert.assertThat((Object)catalog.getWorkspaceByName("test_b2").isIsolated(), (Matcher)CoreMatchers.is((Object)true));
        MatcherAssert.assertThat((Object)catalog.getNamespaceByPrefix("test_b2"), (Matcher)CoreMatchers.notNullValue());
        MatcherAssert.assertThat((Object)catalog.getNamespaceByPrefix("test_b2").getURI(), (Matcher)CoreMatchers.is((Object)"http://www.test_b.org"));
        MatcherAssert.assertThat((Object)catalog.getNamespaceByPrefix("test_b2").isIsolated(), (Matcher)CoreMatchers.is((Object)true));
        MatcherAssert.assertThat((Object)catalog.getNamespaceByURI("http://www.test_b.org").getPrefix(), (Matcher)CoreMatchers.is((Object)"test_b1"));
        MatcherAssert.assertThat((Object)catalog.getWorkspaceByName("test_b3"), (Matcher)CoreMatchers.nullValue());
    }

    private void createWorkspace(String prefix, String namespaceUri, boolean isolated) {
        Catalog catalog = this.getCatalog();
        NamespaceInfoImpl namespace = new NamespaceInfoImpl();
        namespace.setPrefix(prefix);
        namespace.setURI(namespaceUri);
        namespace.setIsolated(isolated);
        catalog.add((NamespaceInfo)namespace);
        WorkspaceInfoImpl workspace = new WorkspaceInfoImpl();
        workspace.setName(prefix);
        workspace.setIsolated(isolated);
        catalog.add((WorkspaceInfo)workspace);
    }

    private void updateWorkspace(String originalName, String name, String namespace, boolean isolated) {
        WorkspaceInfo originalWorkspace = this.getCatalog().getWorkspaceByName(originalName);
        tester.startPage((Page)new WorkspaceEditPage(originalWorkspace));
        FormTester form = tester.newFormTester("form");
        form.setValue("tabs:panel:name", name);
        form.setValue("tabs:panel:uri", namespace);
        form.setValue("tabs:panel:isolated", isolated);
        form.submit("save");
    }

    @Test
    public void testSecurityTabLoad() {
        FormTester form = tester.newFormTester("form");
        form.setValue("tabs:panel:name", "abc");
        form.setValue("tabs:panel:uri", "http://www.geoserver.org");
        tester.clickLink("form:tabs:tabs-container:tabs:1:link");
        tester.assertComponent("form:tabs:panel:listContainer", WebMarkupContainer.class);
        tester.assertComponent("form:tabs:panel:listContainer:selectAll", CheckBox.class);
        tester.assertComponent("form:tabs:panel:listContainer:rules", ListView.class);
        tester.assertRenderedPage(WorkspaceEditPage.class);
        tester.assertNoErrorMessage();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testUpdatesWsSecurityRules() throws IOException {
        AccessDataRuleInfoManager ruleMan = new AccessDataRuleInfoManager();
        try {
            Catalog catalog = this.getCatalog();
            List storesInitial = catalog.getStoresByWorkspace(this.citeWorkspace, DataStoreInfo.class);
            NamespaceInfo citeNamespace = catalog.getNamespaceByPrefix(this.citeWorkspace.getName());
            for (DataStoreInfo store : storesInitial) {
                Assert.assertEquals((Object)citeNamespace.getURI(), store.getConnectionParameters().get("namespace"));
            }
            Assert.assertTrue((boolean)ruleMan.getResourceRule(this.citeWorkspace.getName(), (CatalogInfo)this.citeWorkspace).isEmpty());
            FormTester form = tester.newFormTester("form");
            tester.clickLink("form:tabs:tabs-container:tabs:1:link");
            form.setValue("tabs:panel:listContainer:rules:0:admin", true);
            tester.clickLink("form:save");
            Assert.assertEquals((long)1L, (long)ruleMan.getResourceRule(this.citeWorkspace.getName(), (CatalogInfo)this.citeWorkspace).size());
            tester.assertNoErrorMessage();
        }
        finally {
            ruleMan.removeAllResourceRules(this.citeWorkspace.getName(), (CatalogInfo)this.citeWorkspace);
            Assert.assertTrue((boolean)ruleMan.getResourceRule(this.citeWorkspace.getName(), (CatalogInfo)this.citeWorkspace).isEmpty());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testWsSecurityRulesUI() throws IOException {
        AccessDataRuleInfoManager ruleMan = new AccessDataRuleInfoManager();
        try {
            Catalog catalog = this.getCatalog();
            List storesInitial = catalog.getStoresByWorkspace(this.citeWorkspace, DataStoreInfo.class);
            NamespaceInfo citeNamespace = catalog.getNamespaceByPrefix(this.citeWorkspace.getName());
            for (DataStoreInfo store : storesInitial) {
                Assert.assertEquals((Object)citeNamespace.getURI(), store.getConnectionParameters().get("namespace"));
            }
            DataAccessRule ruleLayer = new DataAccessRule(this.citeWorkspace.getName(), "Forests", AccessMode.READ, new String[]{"ADMIN"});
            DataAccessRule ruleWS = new DataAccessRule(this.citeWorkspace.getName(), "*", AccessMode.ADMIN, new String[]{"ADMIN"});
            HashSet<DataAccessRule> news = new HashSet<DataAccessRule>();
            news.add(ruleLayer);
            news.add(ruleWS);
            ruleMan.saveRules(new HashSet(), news);
            Assert.assertEquals((long)1L, (long)ruleMan.getResourceRule(this.citeWorkspace.getName(), (CatalogInfo)this.citeWorkspace).size());
            tester.clickLink("form:tabs:tabs-container:tabs:1:link");
            CheckBox checkboxFalse = (CheckBox)tester.getComponentFromLastRenderedPage("form:tabs:panel:listContainer:rules:0:read");
            CheckBox checkboxTrue = (CheckBox)tester.getComponentFromLastRenderedPage("form:tabs:panel:listContainer:rules:0:admin");
            Assert.assertFalse((boolean)((Boolean)checkboxFalse.getModelObject()));
            Assert.assertTrue((boolean)((Boolean)checkboxTrue.getModelObject()));
        }
        finally {
            ruleMan.removeAllResourceRules(this.citeWorkspace.getName(), (CatalogInfo)this.citeWorkspace);
            Assert.assertTrue((boolean)ruleMan.getResourceRule(this.citeWorkspace.getName(), (CatalogInfo)this.citeWorkspace).isEmpty());
        }
    }
}

