/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.web.data.store.panel;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.HashMap;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;
import org.geoserver.data.test.MockData;
import org.geoserver.platform.resource.Paths;
import org.geoserver.web.data.store.panel.FileModel;
import org.geoserver.web.util.MapModel;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class FileModelTest {
    File root;

    @Before
    public void init() throws IOException {
        this.root = File.createTempFile("file", "test", new File("target"));
        this.root.delete();
        this.root.mkdirs();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testAbsolute() throws IOException {
        File f = new File("target/fileModelTest.xml");
        try {
            f.createNewFile();
            FileModel model = new FileModel((IModel)new Model(), this.root);
            model.setObject(f.getAbsolutePath());
            String path = model.getObject();
            Assert.assertEquals((Object)("file://" + Paths.convert((String)f.getAbsolutePath())), (Object)path);
        }
        finally {
            f.delete();
        }
    }

    @Test
    public void testAbsoluteToRelative() throws IOException {
        File data = new File(this.root, "data");
        File cite = new File(data, MockData.CITE_PREFIX);
        File buildings = new File(cite, "Buildings.properties");
        FileModel model = new FileModel((IModel)new Model(), this.root);
        model.setObject(buildings.getAbsolutePath());
        String path = model.getObject();
        Assert.assertEquals((Object)"file:data/cite/Buildings.properties", (Object)path);
    }

    @Test
    public void testRelativeUnmodified() throws IOException {
        FileModel model = new FileModel((IModel)new Model(), this.root);
        model.setObject("file:data/cite/Buildings.properties");
        String path = model.getObject();
        Assert.assertEquals((Object)"file:data/cite/Buildings.properties", (Object)path);
    }

    @Test
    public void testURL() throws IOException {
        HashMap<String, URL> map = new HashMap<String, URL>();
        map.put("url", new URL("file:data/cite/Buildings.properties"));
        MapModel mapModel = new MapModel(map, "url");
        FileModel model = new FileModel((IModel)mapModel, this.root);
        String path = model.getObject();
        Assert.assertEquals((Object)"file:data/cite/Buildings.properties", (Object)path);
    }
}

