/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.web.data.store;

import java.io.IOException;
import java.io.Serializable;
import java.util.List;
import org.apache.wicket.Page;
import org.apache.wicket.util.tester.FormTester;
import org.geoserver.catalog.Catalog;
import org.geoserver.catalog.CatalogBuilder;
import org.geoserver.catalog.CoverageInfo;
import org.geoserver.catalog.CoverageStoreInfo;
import org.geoserver.catalog.StoreInfo;
import org.geoserver.catalog.WorkspaceInfo;
import org.geoserver.data.test.MockData;
import org.geoserver.data.test.SystemTestData;
import org.geoserver.web.GeoServerWicketTestSupport;
import org.geoserver.web.data.store.CoverageStoreEditPage;
import org.geoserver.web.data.store.StorePage;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class CoverageStoreEditPageTest
extends GeoServerWicketTestSupport {
    CoverageStoreInfo coverageStore;

    protected void setUpTestData(SystemTestData testData) throws Exception {
        super.setUpTestData(testData);
        testData.setUpDefaultRasterLayers();
    }

    @Before
    public void init() throws IOException {
        this.login();
        this.coverageStore = (CoverageStoreInfo)this.getCatalog().getStoreByName(MockData.TASMANIA_BM.getLocalPart(), CoverageStoreInfo.class);
        if (this.coverageStore == null) {
            Catalog cat = this.getCatalog();
            CoverageStoreInfo c = cat.getCoverageStoreByName("BlueMarbleModified");
            if (c != null) {
                c.setName("BlueMarble");
                cat.save((StoreInfo)c);
            }
            this.coverageStore = (CoverageStoreInfo)this.getCatalog().getStoreByName(MockData.TASMANIA_BM.getLocalPart(), CoverageStoreInfo.class);
        }
        tester.startPage((Page)new CoverageStoreEditPage(this.coverageStore.getId()));
    }

    @Test
    public void testLoad() {
        tester.assertRenderedPage(CoverageStoreEditPage.class);
        tester.assertNoErrorMessage();
        tester.assertLabel("rasterStoreForm:storeType", "GeoTIFF");
        tester.assertModelValue("rasterStoreForm:namePanel:border:border_body:paramValue", (Object)"BlueMarble");
    }

    @Test
    public void testChangeName() {
        FormTester form = tester.newFormTester("rasterStoreForm");
        form.setValue("namePanel:border:border_body:paramValue", "BlueMarbleModified");
        form.submit();
        tester.clickLink("rasterStoreForm:save");
        tester.assertNoErrorMessage();
        tester.assertRenderedPage(StorePage.class);
        Assert.assertNotNull((Object)this.getCatalog().getStoreByName("BlueMarbleModified", CoverageStoreInfo.class));
    }

    @Test
    public void testChangeNameApply() {
        FormTester form = tester.newFormTester("rasterStoreForm");
        form.setValue("namePanel:border:border_body:paramValue", "BlueMarbleModified");
        form.submit("apply");
        tester.assertNoErrorMessage();
        tester.assertRenderedPage(CoverageStoreEditPage.class);
        Assert.assertNotNull((Object)this.getCatalog().getStoreByName("BlueMarbleModified", CoverageStoreInfo.class));
    }

    @Test
    public void testNameRequired() {
        FormTester form = tester.newFormTester("rasterStoreForm");
        form.setValue("namePanel:border:border_body:paramValue", null);
        form.submit();
        tester.clickLink("rasterStoreForm:save");
        tester.assertRenderedPage(CoverageStoreEditPage.class);
        tester.assertErrorMessages((Serializable[])new String[]{"Field 'Data Source Name' is required."});
    }

    @Test
    public void testWorkspaceSyncsUpWithNamespace() {
        Catalog catalog = this.getCatalog();
        FormTester formTester = tester.newFormTester("rasterStoreForm");
        String wsDropdownPath = "rasterStoreForm:workspacePanel:border:border_body:paramValue";
        tester.assertModelValue("rasterStoreForm:workspacePanel:border:border_body:paramValue", (Object)catalog.getWorkspaceByName(MockData.WCS_PREFIX));
        formTester.select("workspacePanel:border:border_body:paramValue", 2);
        formTester.submit();
        boolean isAjax = true;
        tester.clickLink("rasterStoreForm:save", true);
        tester.assertRenderedPage(StorePage.class);
        CoverageStoreInfo store = catalog.getCoverageStore(this.coverageStore.getId());
        WorkspaceInfo workspace = store.getWorkspace();
        Assert.assertNotEquals((Object)MockData.WCS_PREFIX, (Object)workspace.getName());
        List resourcesByStore = catalog.getResourcesByStore((StoreInfo)store, CoverageInfo.class);
        Assert.assertFalse((boolean)resourcesByStore.isEmpty());
        for (CoverageInfo cv : resourcesByStore) {
            Assert.assertEquals((String)("Namespace for " + cv.getName() + " was not updated"), (Object)workspace.getName(), (Object)cv.getNamespace().getPrefix());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testEditDetached() throws Exception {
        Catalog catalog = this.getCatalog();
        CoverageStoreInfo store = catalog.getFactory().createCoverageStore();
        new CatalogBuilder(catalog).updateCoverageStore(store, this.coverageStore);
        Assert.assertNull((Object)store.getId());
        try {
            tester.startPage((Page)new CoverageStoreEditPage(store));
            tester.assertNoErrorMessage();
            FormTester form = tester.newFormTester("rasterStoreForm");
            form.setValue("namePanel:border:border_body:paramValue", "foo");
            form.submit();
            tester.clickLink("rasterStoreForm:save");
            tester.assertNoErrorMessage();
            Assert.assertNotNull((Object)store.getId());
            Assert.assertEquals((Object)"foo", (Object)store.getName());
            Assert.assertNotNull((Object)catalog.getStoreByName(this.coverageStore.getName(), CoverageStoreInfo.class));
            Assert.assertNotNull((Object)catalog.getStoreByName("foo", CoverageStoreInfo.class));
        }
        finally {
            catalog.remove((StoreInfo)store);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testCoverageStoreEdit() throws Exception {
        Catalog catalog = this.getCatalog();
        CoverageStoreInfo store = catalog.getFactory().createCoverageStore();
        new CatalogBuilder(catalog).updateCoverageStore(store, this.coverageStore);
        Assert.assertNull((Object)store.getId());
        try {
            tester.startPage((Page)new CoverageStoreEditPage(store));
            tester.assertNoErrorMessage();
            FormTester form = tester.newFormTester("rasterStoreForm");
            form.setValue("namePanel:border:border_body:paramValue", "foo");
            form.submit();
            tester.clickLink("rasterStoreForm:save");
            tester.assertNoErrorMessage();
            Assert.assertNotNull((Object)store.getId());
            CoverageStoreInfo expandedStore = catalog.getResourcePool().clone(store, true);
            Assert.assertNotNull((Object)expandedStore.getId());
            Assert.assertNotNull((Object)expandedStore.getCatalog());
            catalog.validate((StoreInfo)expandedStore, false).throwIfInvalid();
        }
        finally {
            catalog.remove((StoreInfo)store);
        }
    }
}

