/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.web.admin;

import java.util.ArrayList;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.wicket.request.mapper.parameter.PageParameters;
import org.awaitility.Awaitility;
import org.geoserver.GeoServerConfigurationLock;
import org.geoserver.platform.GeoServerExtensions;
import org.geoserver.web.GeoServerWicketTestSupport;
import org.geoserver.web.ServerBusyPage;
import org.geoserver.web.data.store.DataAccessEditPage;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.springframework.security.core.authority.SimpleGrantedAuthority;

public class ServerBusyPageTest
extends GeoServerWicketTestSupport {
    long defaultTimeout;

    @Before
    public void clearTimeout() {
        this.defaultTimeout = GeoServerConfigurationLock.DEFAULT_TRY_LOCK_TIMEOUT_MS;
        GeoServerConfigurationLock.DEFAULT_TRY_LOCK_TIMEOUT_MS = 1L;
    }

    @After
    public void reinstateTimeout() {
        GeoServerConfigurationLock.DEFAULT_TRY_LOCK_TIMEOUT_MS = this.defaultTimeout;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testStoreEditServerBusyPage() throws Exception {
        this.login();
        ArrayList<SimpleGrantedAuthority> l = new ArrayList<SimpleGrantedAuthority>();
        l.add(new SimpleGrantedAuthority("ROLE_ANONYMOUS"));
        final GeoServerConfigurationLock.LockType type = GeoServerConfigurationLock.LockType.WRITE;
        final GeoServerConfigurationLock locker = (GeoServerConfigurationLock)GeoServerExtensions.bean((String)"configurationLock");
        locker.setEnabled(true);
        locker.unlock();
        final AtomicBoolean acquired = new AtomicBoolean(false);
        final AtomicBoolean release = new AtomicBoolean(false);
        if (locker != null) {
            Thread configWriter = new Thread("Config-writer"){

                @Override
                public void run() {
                    locker.lock(type);
                    acquired.set(true);
                    try {
                        Awaitility.await().forever().until(() -> release.get());
                    }
                    finally {
                        locker.unlock();
                    }
                }
            };
            configWriter.start();
            try {
                while (!acquired.get()) {
                    Thread.sleep(50L);
                }
                tester.startPage(DataAccessEditPage.class, new PageParameters().add("wsName", (Object)"cite").add("storeName", (Object)"cite"));
                tester.assertRenderedPage(ServerBusyPage.class);
                tester.assertNoErrorMessage();
            }
            finally {
                release.set(true);
            }
        }
    }
}

