/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.web;

import java.util.Arrays;
import java.util.Collection;
import org.apache.wicket.Page;
import org.apache.wicket.protocol.http.WebApplication;
import org.apache.wicket.protocol.http.mock.MockHttpServletRequest;
import org.apache.wicket.request.mapper.parameter.PageParameters;
import org.apache.wicket.util.tester.FormTester;
import org.apache.wicket.util.tester.WicketTester;
import org.geoserver.catalog.NamespaceInfo;
import org.geoserver.catalog.WorkspaceInfo;
import org.geoserver.config.GeoServer;
import org.geoserver.config.SettingsInfo;
import org.geoserver.data.test.MockData;
import org.geoserver.web.GeoServerApplication;
import org.geoserver.web.GeoServerWicketTestSupport;
import org.geoserver.web.data.workspace.WorkspaceEditPage;
import org.geoserver.web.data.workspace.WorkspacePage;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class GeoServerWicketCsrfTest
extends GeoServerWicketTestSupport {
    @Parameterized.Parameter(value=0)
    public String csrfDisabled;
    @Parameterized.Parameter(value=1)
    public String csrfWhitelist;
    private WorkspaceInfo citeWorkspace;

    @Parameterized.Parameters
    public static Collection<Object[]> data() {
        return Arrays.asList({"true", "foo.com"}, {"false", "geoserver.org"}, {"false", ""});
    }

    @Before
    public void init() {
        System.setProperty("GEOSERVER_CSRF_WHITELIST", this.csrfWhitelist);
        System.setProperty("GEOSERVER_CSRF_DISABLED", this.csrfDisabled);
        GeoServerApplication app = (GeoServerApplication)applicationContext.getBean("webApplication");
        tester = new WicketTester((WebApplication)app, false);
        app.init();
        this.login();
        this.citeWorkspace = this.getCatalog().getWorkspaceByName(MockData.CITE_PREFIX);
        GeoServer gs = this.getGeoServer();
        SettingsInfo s = gs.getSettings(this.citeWorkspace);
        if (s != null) {
            gs.remove(s);
        }
        NamespaceInfo citeNS = this.getCatalog().getNamespaceByPrefix(MockData.CITE_PREFIX);
        citeNS.setURI(MockData.CITE_URI);
        this.getCatalog().save(citeNS);
        tester.startPage((Page)new WorkspaceEditPage(this.citeWorkspace));
    }

    @Test
    public void testFormSubmitWhitelistedDomain() {
        GeoServerWicketCsrfTest.submitWithBaseURL("http://www.geoserver.org");
        if ("".equals(this.csrfWhitelist)) {
            Assert.assertNull((Object)tester.getLastRenderedPage());
        } else {
            tester.assertRenderedPage(WorkspacePage.class);
            tester.assertNoErrorMessage();
        }
    }

    @Test
    public void testFormSubmitNotWhitelistedDomain() {
        GeoServerWicketCsrfTest.submitWithBaseURL("http://www.remote.com");
        if ("true".equals(this.csrfDisabled)) {
            tester.assertRenderedPage(WorkspacePage.class);
            tester.assertNoErrorMessage();
        } else {
            Assert.assertNull((Object)tester.getLastRenderedPage());
        }
    }

    private static void submitWithBaseURL(String url) {
        FormTester form = tester.newFormTester("form");
        MockHttpServletRequest request = tester.getRequest();
        String relativePath = form.getForm().getRootForm().urlForListener(new PageParameters()).toString().substring(1);
        request.setServerName("geoserver.org");
        request.setHeader("Origin", url);
        request.setHeader("Referer", url + relativePath);
        form.setValue("tabs:panel:uri", "http://www.geoserver.org");
        form.submit("save");
    }
}

