/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.web;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.math.BigInteger;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.KeyStore;
import java.security.Provider;
import java.security.SecureRandom;
import java.security.Security;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.Date;
import java.util.Enumeration;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.naming.NamingException;
import javax.security.auth.x500.X500Principal;
import org.apache.commons.dbcp.BasicDataSource;
import org.bouncycastle.asn1.x509.X509Name;
import org.bouncycastle.jce.X509Principal;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.x509.X509V3CertificateGenerator;
import org.eclipse.jetty.http.HttpVersion;
import org.eclipse.jetty.plus.jndi.Resource;
import org.eclipse.jetty.server.ConnectionFactory;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.HttpConfiguration;
import org.eclipse.jetty.server.HttpConnectionFactory;
import org.eclipse.jetty.server.SecureRequestCustomizer;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.ServerConnector;
import org.eclipse.jetty.server.SslConnectionFactory;
import org.eclipse.jetty.util.ssl.SslContextFactory;
import org.eclipse.jetty.webapp.WebAppContext;
import org.eclipse.jetty.xml.XmlConfiguration;
import org.geotools.util.logging.Logging;

public class Start {
    private static final Logger log = Logging.getLogger((String)Start.class.getName());

    public static void main(String[] args) {
        block26: {
            Server jettyServer = new Server();
            HttpConfiguration httpConfig = new HttpConfiguration();
            try (ServerConnector http = new ServerConnector(jettyServer, new ConnectionFactory[]{new HttpConnectionFactory(httpConfig)});){
                ServerConnector https = Start.getHTTPSConnector(jettyServer, httpConfig);
                try {
                    Connector[] connectorArray;
                    http.setPort(Integer.getInteger("jetty.port", 8080).intValue());
                    http.setAcceptQueueSize(100);
                    http.setIdleTimeout(3600000L);
                    http.setSoLingerTime(-1);
                    if (https != null) {
                        Connector[] connectorArray2 = new Connector[2];
                        connectorArray2[0] = http;
                        connectorArray = connectorArray2;
                        connectorArray2[1] = https;
                    } else {
                        Connector[] connectorArray3 = new Connector[1];
                        connectorArray = connectorArray3;
                        connectorArray3[0] = http;
                    }
                    jettyServer.setConnectors(connectorArray);
                    WebAppContext wah = new WebAppContext();
                    wah.setContextPath("/geoserver");
                    wah.setWar("src/main/webapp");
                    jettyServer.setHandler((Handler)wah);
                    wah.setTempDirectory(new File("target/work"));
                    wah.getServletContext().getContextHandler().setMaxFormContentSize(0x500000);
                    wah.getServletContext().getContextHandler().setMaxFormKeys(2000);
                    String jettyConfigFile = System.getProperty("jetty.config.file");
                    if (jettyConfigFile != null) {
                        log.info("Loading Jetty config from file: " + jettyConfigFile);
                        new XmlConfiguration((InputStream)new FileInputStream(jettyConfigFile)).configure((Object)jettyServer);
                    }
                    long start = System.currentTimeMillis();
                    log.severe("GeoServer starting");
                    jettyServer.start();
                    long end = System.currentTimeMillis();
                    log.severe("GeoServer startup complete in " + (double)(end - start) / 1000.0 + "s");
                    try {
                        BufferedReader reader = new BufferedReader(new InputStreamReader(System.in));
                        try {
                            while (true) {
                                String line;
                                if (!"stop".equals(line = reader.readLine())) {
                                    continue;
                                }
                                jettyServer.stop();
                                System.exit(0);
                            }
                        }
                        catch (Throwable throwable) {
                            try {
                                reader.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                            throw throwable;
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        System.exit(1);
                        if (https != null) {
                            https.close();
                        }
                    }
                }
                catch (Throwable throwable) {
                    if (https != null) {
                        try {
                            https.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                    }
                    throw throwable;
                }
            }
            catch (Exception e) {
                log.log(Level.SEVERE, "Could not start the Jetty server: " + e.getMessage(), e);
                if (jettyServer == null) break block26;
                try {
                    jettyServer.stop();
                }
                catch (Exception e1) {
                    log.log(Level.SEVERE, "Unable to stop the Jetty server:" + e1.getMessage(), e1);
                }
            }
        }
    }

    private static void addJNDIDataSource() throws NamingException {
        BasicDataSource dataSource = new BasicDataSource();
        dataSource.setDriverClassName("org.postgresql.Driver");
        dataSource.setUrl("jdbc:postgresql://localhost:5432/mydb");
        dataSource.setUsername("user");
        dataSource.setPassword("pwd");
        dataSource.setMaxActive(20);
        dataSource.setMaxIdle(5);
        dataSource.setMinIdle(2);
        dataSource.setInitialSize(5);
        dataSource.setAccessToUnderlyingConnectionAllowed(true);
        new Resource("java:comp/env/jdbc/myds", (Object)dataSource);
    }

    private static ServerConnector getHTTPSConnector(Server jettyServer, HttpConfiguration httpConfig) {
        String sslHost = System.getProperty("ssl.hostname");
        ServerConnector https = null;
        if (sslHost != null && !sslHost.isEmpty()) {
            Security.addProvider((Provider)new BouncyCastleProvider());
            SslContextFactory ssl = Start.createSSLContextFactory(sslHost);
            HttpConfiguration httpsConfig = new HttpConfiguration(httpConfig);
            httpsConfig.addCustomizer((HttpConfiguration.Customizer)new SecureRequestCustomizer());
            https = new ServerConnector(jettyServer, new ConnectionFactory[]{new SslConnectionFactory(ssl, HttpVersion.HTTP_1_1.asString()), new HttpConnectionFactory(httpsConfig)});
            https.setPort(Integer.getInteger("jetty.ssl.port", 8443).intValue());
        }
        return https;
    }

    private static SslContextFactory createSSLContextFactory(String hostname) {
        String password = System.getProperty("jetty.keystore.password", "changeit");
        String keyStoreLocation = System.getProperty("jetty.keystore");
        if (keyStoreLocation == null) {
            File userHome = new File(System.getProperty("user.home"));
            File geoserverDir = new File(userHome, ".geoserver");
            if (!geoserverDir.exists()) {
                geoserverDir.mkdir();
            }
            keyStoreLocation = new File(geoserverDir, "keystore.jks").getPath();
        }
        File keyStoreFile = new File(keyStoreLocation);
        try {
            Start.assureSelfSignedServerCertificate(hostname, keyStoreFile, password);
        }
        catch (Exception e) {
            log.log(Level.WARNING, "NO SSL available", e);
            return null;
        }
        SslContextFactory ssl = new SslContextFactory();
        ssl.setKeyStorePath(keyStoreFile.getAbsolutePath());
        ssl.setKeyStorePassword(password);
        File javaHome = new File(System.getProperty("java.home"));
        File cacerts = new File(javaHome, "lib").toPath().resolve("security/cacerts").toFile();
        if (!cacerts.exists()) {
            return null;
        }
        ssl.setTrustStorePath(cacerts.getAbsolutePath());
        ssl.setTrustStorePassword("changeit");
        return ssl;
    }

    private static void assureSelfSignedServerCertificate(String hostname, File keyStoreFile, String password) throws Exception {
        KeyStore privateKS = KeyStore.getInstance("JKS");
        if (keyStoreFile.exists()) {
            try (FileInputStream fis = new FileInputStream(keyStoreFile);){
                privateKS.load(fis, password.toCharArray());
            }
            if (Start.keyStoreContainsCertificate(privateKS, hostname)) {
                return;
            }
        } else {
            privateKS.load(null);
        }
        KeyPairGenerator keyPairGenerator = KeyPairGenerator.getInstance("RSA");
        keyPairGenerator.initialize(1024);
        KeyPair KPair = keyPairGenerator.generateKeyPair();
        X509V3CertificateGenerator v3CertGen = new X509V3CertificateGenerator();
        int random = new SecureRandom().nextInt();
        if (random < 0) {
            random *= -1;
        }
        v3CertGen.setSerialNumber(BigInteger.valueOf(random));
        v3CertGen.setIssuerDN((X509Name)new X509Principal("CN=" + hostname + ", OU=None, O=None L=None, C=None"));
        v3CertGen.setNotBefore(new Date(System.currentTimeMillis() - 2592000000L));
        v3CertGen.setNotAfter(new Date(System.currentTimeMillis() + 315360000000L));
        v3CertGen.setSubjectDN((X509Name)new X509Principal("CN=" + hostname + ", OU=None, O=None L=None, C=None"));
        v3CertGen.setPublicKey(KPair.getPublic());
        v3CertGen.setSignatureAlgorithm("MD5WithRSAEncryption");
        X509Certificate PKCertificate = v3CertGen.generateX509Certificate(KPair.getPrivate());
        File certFile = new File(keyStoreFile.getParentFile(), hostname + ".cert");
        try (FileOutputStream fos = new FileOutputStream(certFile.getAbsoluteFile());){
            fos.write(PKCertificate.getEncoded());
        }
        privateKS.setKeyEntry(hostname + ".key", KPair.getPrivate(), password.toCharArray(), new Certificate[]{PKCertificate});
        privateKS.setCertificateEntry(hostname + ".cert", PKCertificate);
        privateKS.store(new FileOutputStream(keyStoreFile), password.toCharArray());
    }

    private static boolean keyStoreContainsCertificate(KeyStore ks, String hostname) throws Exception {
        Enumeration<String> e = ks.aliases();
        while (e.hasMoreElements()) {
            X500Principal p;
            Certificate c;
            String alias = e.nextElement();
            if (!ks.isCertificateEntry(alias) || !((c = ks.getCertificate(alias)) instanceof X509Certificate) || !(p = ((X509Certificate)c).getSubjectX500Principal()).getName().contains(hostname)) continue;
            return true;
        }
        return false;
    }
}

