/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.security.validation;

import org.geoserver.security.config.PasswordPolicyConfig;
import org.geoserver.security.validation.PasswordPolicyException;
import org.geoserver.security.validation.PasswordValidatorImpl;
import org.geoserver.test.GeoServerMockTestSupport;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class PasswordValidatorTest
extends GeoServerMockTestSupport {
    PasswordPolicyConfig config;
    PasswordValidatorImpl validator;

    @Before
    public void init() throws Exception {
        this.config = new PasswordPolicyConfig();
        this.validator = new PasswordValidatorImpl(this.getSecurityManager());
        this.validator.setConfig(this.config);
    }

    @Test
    public void testPasswords() throws PasswordPolicyException {
        this.checkForException(null, "IS_NULL", new Object[0]);
        this.validator.validatePassword("".toCharArray());
        this.validator.validatePassword("a".toCharArray());
        this.checkForException("plain:a", "RESERVED_PREFIX", "plain:");
        this.checkForException("crypt1:a", "RESERVED_PREFIX", "crypt1:");
        this.checkForException("digest1:a", "RESERVED_PREFIX", "digest1:");
        this.validator.validatePassword("plain".toCharArray());
        this.validator.validatePassword("plaina".toCharArray());
        this.config.setMinLength(2);
        this.checkForException("a", "MIN_LENGTH", 2);
        this.validator.validatePassword("aa".toCharArray());
        this.config.setMaxLength(10);
        this.checkForException("01234567890", "MAX_LENGTH", 10);
        this.validator.validatePassword("0123456789".toCharArray());
        this.config.setDigitRequired(true);
        this.checkForException("abcdef", "NO_DIGIT", new Object[0]);
        this.validator.validatePassword("abcde4".toCharArray());
        this.config.setUppercaseRequired(true);
        this.checkForException("abcdef4", "NO_UPPERCASE", new Object[0]);
        this.validator.validatePassword("abcde4F".toCharArray());
        this.config.setLowercaseRequired(true);
        this.checkForException("ABCDE4F", "NO_LOWERCASE", new Object[0]);
        this.validator.validatePassword("abcde4F".toCharArray());
    }

    protected void checkForException(String password, String id, Object ... params) {
        try {
            this.validator.validatePassword(password != null ? password.toCharArray() : null);
        }
        catch (PasswordPolicyException ex) {
            Assert.assertEquals((Object)id, (Object)ex.getId());
            Assert.assertEquals((long)params.length, (long)ex.getArgs().length);
            for (int i = 0; i < params.length; ++i) {
                Assert.assertEquals((Object)params[i], (Object)ex.getArgs()[i]);
            }
        }
    }
}

