/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.security.impl;

import org.geoserver.catalog.LayerGroupInfo;
import org.geoserver.catalog.LayerGroupVisibilityPolicy;
import org.geoserver.catalog.impl.AdvertisedCatalog;
import org.geoserver.ows.Dispatcher;
import org.geoserver.ows.Request;
import org.geoserver.security.impl.AbstractAuthorizationTest;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class AdvertisedCatalogTest
extends AbstractAuthorizationTest {
    @Override
    @Before
    public void setUp() throws Exception {
        super.setUp();
        Dispatcher.REQUEST.set(new Request());
        ((Request)Dispatcher.REQUEST.get()).setRequest("GetCapabilities");
        this.populateCatalog();
    }

    @After
    public void tearDown() throws Exception {
        Dispatcher.REQUEST.set(null);
    }

    @Test
    public void testNotAdvertisedLayersInGroupWithHideGroupIfEmptyPolicy() throws Exception {
        AdvertisedCatalog sc = new AdvertisedCatalog(this.catalog);
        sc.setLayerGroupVisibilityPolicy(LayerGroupVisibilityPolicy.HIDE_EMPTY);
        Assert.assertNull((Object)sc.getLayerByName("topp:states"));
        Assert.assertNull((Object)sc.getLayerByName("topp:roads"));
        LayerGroupInfo layerGroup = sc.getLayerGroupByName("topp", "layerGroupWithSomeLockedLayer");
        Assert.assertNull((Object)layerGroup);
    }

    @Test
    public void testNotAdvertisedLayersInGroupWithNeverHideGroupPolicy() throws Exception {
        AdvertisedCatalog sc = new AdvertisedCatalog(this.catalog);
        sc.setLayerGroupVisibilityPolicy(LayerGroupVisibilityPolicy.HIDE_NEVER);
        Assert.assertNull((Object)sc.getLayerByName("topp:states"));
        Assert.assertNull((Object)sc.getLayerByName("topp:roads"));
        LayerGroupInfo layerGroup = sc.getLayerGroupByName("topp", "layerGroupWithSomeLockedLayer");
        Assert.assertNotNull((Object)layerGroup);
        Assert.assertEquals((long)0L, (long)layerGroup.getLayers().size());
    }

    @Test
    public void testNotAdvertisedLayerGroup() throws Exception {
        AdvertisedCatalog sc = new AdvertisedCatalog(this.catalog);
        Assert.assertFalse((boolean)this.namedTreeC.isAdvertised());
        Assert.assertNull((Object)sc.getLayerGroupByName(this.namedTreeC.getName()));
    }

    @Test
    public void testLayerSpecificCapabilities() throws Exception {
        AdvertisedCatalog sc = new AdvertisedCatalog(this.catalog);
        ((Request)Dispatcher.REQUEST.get()).setContext("topp/states");
        Assert.assertNotNull((Object)sc.getLayerByName("topp:states"));
    }
}

