/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.security.impl;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.stream.Stream;
import org.easymock.Capture;
import org.easymock.CaptureType;
import org.easymock.EasyMock;
import org.geoserver.catalog.Catalog;
import org.geoserver.catalog.CatalogInfo;
import org.geoserver.catalog.CoverageInfo;
import org.geoserver.catalog.CoverageStoreInfo;
import org.geoserver.catalog.DataStoreInfo;
import org.geoserver.catalog.FeatureTypeInfo;
import org.geoserver.catalog.LayerGroupHelper;
import org.geoserver.catalog.LayerGroupInfo;
import org.geoserver.catalog.LayerInfo;
import org.geoserver.catalog.NamespaceInfo;
import org.geoserver.catalog.PublishedInfo;
import org.geoserver.catalog.ResourceInfo;
import org.geoserver.catalog.StoreInfo;
import org.geoserver.catalog.StyleInfo;
import org.geoserver.catalog.WMSLayerInfo;
import org.geoserver.catalog.WMSStoreInfo;
import org.geoserver.catalog.WMTSLayerInfo;
import org.geoserver.catalog.WMTSStoreInfo;
import org.geoserver.catalog.WorkspaceInfo;
import org.geoserver.catalog.util.CloseableIterator;
import org.geoserver.catalog.util.CloseableIteratorAdapter;
import org.geoserver.ows.Dispatcher;
import org.geoserver.ows.Request;
import org.geoserver.platform.GeoServerExtensionsHelper;
import org.geoserver.security.ResourceAccessManager;
import org.geoserver.security.ResourceAccessManagerWrapper;
import org.geoserver.security.SecureCatalogImpl;
import org.geoserver.security.impl.DataAccessRuleDAO;
import org.geoserver.security.impl.DefaultResourceAccessManager;
import org.geoserver.security.impl.GeoServerRole;
import org.geoserver.security.impl.LayerGroupContainmentCache;
import org.geoserver.security.impl.MemoryDataAccessRuleDAO;
import org.geoserver.security.impl.SecureObjectsTest;
import org.geoserver.security.impl.SecureTreeNode;
import org.geotools.api.data.DataStore;
import org.geotools.api.data.FeatureStore;
import org.geotools.api.filter.Filter;
import org.geotools.api.filter.sort.SortBy;
import org.geotools.api.filter.sort.SortOrder;
import org.geotools.api.util.ProgressListener;
import org.geotools.util.factory.Hints;
import org.junit.After;
import org.junit.Before;
import org.springframework.beans.support.PropertyComparator;
import org.springframework.security.authentication.TestingAuthenticationToken;
import org.springframework.security.core.Authentication;

public abstract class AbstractAuthorizationTest
extends SecureObjectsTest {
    private static final String NULL_STRING = null;
    protected Authentication rwUser;
    protected Authentication roUser;
    protected Authentication anonymous;
    protected Authentication milUser;
    protected TestingAuthenticationToken root;
    protected Catalog catalog;
    protected WorkspaceInfo toppWs;
    protected WorkspaceInfo nurcWs;
    protected LayerInfo statesLayer;
    protected LayerInfo regionsLayer;
    protected LayerInfo landmarksLayer;
    protected LayerInfo basesLayer;
    protected LayerInfo arcGridLayer;
    protected LayerInfo roadsLayer;
    protected FeatureTypeInfo states;
    protected CoverageInfo arcGrid;
    protected FeatureTypeInfo roads;
    protected FeatureTypeInfo landmarks;
    protected FeatureTypeInfo bases;
    protected DataStoreInfo statesStore;
    protected DataStoreInfo roadsStore;
    protected CoverageStoreInfo arcGridStore;
    protected StyleInfo pointStyle;
    protected StyleInfo lineStyle;
    protected LayerGroupInfo layerGroupGlobal;
    protected LayerGroupInfo layerGroupTopp;
    protected LayerGroupInfo layerGroupWithSomeLockedLayer;
    protected List<LayerInfo> layers;
    protected List<FeatureTypeInfo> featureTypes;
    protected List<CoverageInfo> coverages;
    protected List<WorkspaceInfo> workspaces;
    protected SecureCatalogImpl sc;
    protected LayerInfo cascadedLayer;
    protected LayerInfo cascadedWmtsLayer;
    protected LayerInfo forestsLayer;
    protected WMSLayerInfo cascaded;
    protected List<WMSLayerInfo> wmsLayers;
    protected WMTSLayerInfo cascadedWmts;
    protected List<WMTSLayerInfo> wmtsLayers;
    protected LayerGroupInfo namedTreeA;
    protected LayerGroupInfo namedTreeB;
    protected LayerGroupInfo namedTreeC;
    protected LayerGroupInfo containerTreeB;
    protected LayerGroupInfo singleGroupC;
    protected LayerGroupInfo wsContainerD;
    protected LayerGroupInfo nestedContainerE;
    protected LayerInfo citiesLayer;
    protected FeatureTypeInfo cities;
    protected List<LayerGroupInfo> layerGroups;

    @Before
    public void setUp() throws Exception {
        this.rwUser = new TestingAuthenticationToken((Object)"rw", (Object)"supersecret", Arrays.asList(new GeoServerRole("READER"), new GeoServerRole("WRITER")));
        this.roUser = new TestingAuthenticationToken((Object)"ro", (Object)"supersecret", Arrays.asList(new GeoServerRole("READER")));
        this.anonymous = new TestingAuthenticationToken((Object)"anonymous", null);
        this.milUser = new TestingAuthenticationToken((Object)"military", (Object)"supersecret", Arrays.asList(new GeoServerRole("MILITARY")));
        this.root = new TestingAuthenticationToken((Object)"admin", (Object)"geoserver", Arrays.asList(new GeoServerRole(SecureTreeNode.ROOT_ROLE)));
        this.catalog = (Catalog)EasyMock.createNiceMock(Catalog.class);
        EasyMock.expect((Object)this.catalog.getWorkspace((String)EasyMock.anyObject())).andReturn((Object)((WorkspaceInfo)EasyMock.createNiceMock(WorkspaceInfo.class))).anyTimes();
        EasyMock.replay((Object[])new Object[]{this.catalog});
        this.toppWs = (WorkspaceInfo)EasyMock.createNiceMock(WorkspaceInfo.class);
        EasyMock.expect((Object)this.toppWs.getName()).andReturn((Object)"topp").anyTimes();
        EasyMock.replay((Object[])new Object[]{this.toppWs});
        this.nurcWs = (WorkspaceInfo)EasyMock.createNiceMock(WorkspaceInfo.class);
        EasyMock.expect((Object)this.nurcWs.getName()).andReturn((Object)"nurc").anyTimes();
        EasyMock.replay((Object[])new Object[]{this.nurcWs});
        this.statesLayer = this.buildLayer("states", this.toppWs, FeatureTypeInfo.class, false);
        this.roadsLayer = this.buildLayer("roads", this.toppWs, FeatureTypeInfo.class, false);
        this.citiesLayer = this.buildLayer("cities", this.nurcWs, FeatureTypeInfo.class);
        this.landmarksLayer = this.buildLayer("landmarks", this.toppWs, FeatureTypeInfo.class);
        this.basesLayer = this.buildLayer("bases", this.toppWs, FeatureTypeInfo.class);
        this.forestsLayer = this.buildLayer("forests", this.toppWs, FeatureTypeInfo.class);
        this.regionsLayer = this.buildLayer("regions", this.toppWs, FeatureTypeInfo.class);
        this.arcGridLayer = this.buildLayer("arc.grid", this.nurcWs, CoverageInfo.class);
        this.states = (FeatureTypeInfo)this.statesLayer.getResource();
        this.statesStore = this.states.getStore();
        this.arcGrid = (CoverageInfo)this.arcGridLayer.getResource();
        this.arcGridStore = this.arcGrid.getStore();
        this.roads = (FeatureTypeInfo)this.roadsLayer.getResource();
        this.cities = (FeatureTypeInfo)this.citiesLayer.getResource();
        this.roadsStore = this.roads.getStore();
        this.landmarks = (FeatureTypeInfo)this.landmarksLayer.getResource();
        this.bases = (FeatureTypeInfo)this.basesLayer.getResource();
        this.pointStyle = this.buildStyle("point", null);
        this.lineStyle = this.buildStyle("line", this.toppWs);
        this.layerGroupGlobal = this.buildLayerGroup("layerGroup", this.pointStyle, null, this.arcGridLayer);
        this.layerGroupTopp = this.buildLayerGroup("layerGroupTopp", this.lineStyle, this.toppWs, this.statesLayer);
        this.layerGroupWithSomeLockedLayer = this.buildLayerGroup("layerGroupWithSomeLockedLayer", this.lineStyle, this.toppWs, this.statesLayer, this.roadsLayer);
        this.namedTreeA = this.buildLayerGroup("namedTreeA", LayerGroupInfo.Mode.NAMED, null, new PublishedInfo[]{this.statesLayer, this.roadsLayer, this.citiesLayer});
        this.namedTreeB = this.buildLayerGroup("namedTreeB", LayerGroupInfo.Mode.NAMED, null, true, false, new PublishedInfo[]{this.regionsLayer});
        this.namedTreeC = this.buildLayerGroup("namedTreeC", LayerGroupInfo.Mode.NAMED, null, false, true, new PublishedInfo[]{this.regionsLayer});
        this.nestedContainerE = this.buildLayerGroup("nestedContainerE", LayerGroupInfo.Mode.CONTAINER, null, new PublishedInfo[]{this.forestsLayer});
        this.containerTreeB = this.buildLayerGroup("containerTreeB", LayerGroupInfo.Mode.CONTAINER, null, new PublishedInfo[]{this.roadsLayer, this.landmarksLayer, this.nestedContainerE});
        this.singleGroupC = this.buildLayerGroup("singleGroupC", LayerGroupInfo.Mode.SINGLE, null, new PublishedInfo[]{this.statesLayer, this.basesLayer});
        this.wsContainerD = this.buildLayerGroup("wsContainerD", LayerGroupInfo.Mode.CONTAINER, this.nurcWs, new PublishedInfo[]{this.arcGridLayer});
        this.layerGroups = Arrays.asList(this.layerGroupGlobal, this.layerGroupTopp, this.layerGroupWithSomeLockedLayer, this.namedTreeA, this.namedTreeB, this.namedTreeC, this.containerTreeB, this.singleGroupC, this.wsContainerD, this.nestedContainerE);
        this.cascadedLayer = this.buildLayer("cascaded", this.toppWs, WMSLayerInfo.class);
        this.cascaded = (WMSLayerInfo)this.cascadedLayer.getResource();
        this.cascadedWmtsLayer = this.buildLayer("cascadedWmts", this.toppWs, WMTSLayerInfo.class);
        this.cascadedWmts = (WMTSLayerInfo)this.cascadedWmtsLayer.getResource();
    }

    @After
    public void cleanupRequestThreadLocal() throws Exception {
        Dispatcher.REQUEST.remove();
    }

    protected void setupRequestThreadLocal(String service) {
        Request request = new Request();
        request.setService(service);
        Dispatcher.REQUEST.set(request);
    }

    protected LayerInfo buildLayer(String name, WorkspaceInfo ws, Class<? extends ResourceInfo> resourceClass) throws Exception {
        return this.buildLayer(name, ws, resourceClass, true);
    }

    protected LayerInfo buildLayer(String name, WorkspaceInfo ws, Class<? extends ResourceInfo> resourceClass, boolean advertised) throws Exception {
        StoreInfo store;
        FeatureStore fs = (FeatureStore)EasyMock.createNiceMock(FeatureStore.class);
        EasyMock.replay((Object[])new Object[]{fs});
        DataStore dstore = (DataStore)EasyMock.createNiceMock(DataStore.class);
        EasyMock.replay((Object[])new Object[]{dstore});
        if (resourceClass.equals(CoverageInfo.class)) {
            store = (StoreInfo)EasyMock.createNiceMock(CoverageStoreInfo.class);
        } else if (resourceClass.equals(WMSLayerInfo.class)) {
            store = (StoreInfo)EasyMock.createNiceMock(WMSStoreInfo.class);
        } else if (resourceClass.equals(WMTSLayerInfo.class)) {
            store = (StoreInfo)EasyMock.createNiceMock(WMTSStoreInfo.class);
        } else {
            store = (StoreInfo)EasyMock.createNiceMock(DataStoreInfo.class);
            EasyMock.expect((Object)((DataStore)((DataStoreInfo)store).getDataStore(null))).andReturn((Object)dstore);
        }
        EasyMock.expect((Object)store.getWorkspace()).andReturn((Object)ws).anyTimes();
        EasyMock.replay((Object[])new Object[]{store});
        NamespaceInfo ns = (NamespaceInfo)EasyMock.createNiceMock(NamespaceInfo.class);
        EasyMock.expect((Object)ns.getName()).andReturn((Object)ws.getName()).anyTimes();
        EasyMock.expect((Object)ns.getPrefix()).andReturn((Object)ws.getName()).anyTimes();
        EasyMock.expect((Object)ns.getURI()).andReturn((Object)("http://www.geoserver.org/test/" + ws.getName())).anyTimes();
        EasyMock.replay((Object[])new Object[]{ns});
        ResourceInfo resource = (ResourceInfo)EasyMock.createNiceMock(resourceClass);
        EasyMock.expect((Object)resource.getStore()).andReturn((Object)store).anyTimes();
        EasyMock.expect((Object)resource.getName()).andReturn((Object)name).anyTimes();
        EasyMock.expect((Object)resource.prefixedName()).andReturn((Object)(ws.getName() + ":" + name)).anyTimes();
        EasyMock.expect((Object)resource.getNamespace()).andReturn((Object)ns).anyTimes();
        if (resource instanceof FeatureTypeInfo) {
            EasyMock.expect((Object)((FeatureTypeInfo)resource).getFeatureSource((ProgressListener)EasyMock.anyObject(), (Hints)EasyMock.anyObject())).andReturn((Object)fs).anyTimes();
        }
        if (!advertised) {
            EasyMock.expect((Object)resource.isAdvertised()).andReturn((Object)advertised).anyTimes();
        }
        EasyMock.expect((Object)resource.getId()).andReturn((Object)(name + "-id")).anyTimes();
        EasyMock.replay((Object[])new Object[]{resource});
        LayerInfo layer = (LayerInfo)EasyMock.createNiceMock(LayerInfo.class);
        EasyMock.expect((Object)layer.getName()).andReturn((Object)name).anyTimes();
        EasyMock.expect((Object)layer.prefixedName()).andReturn((Object)(ws.getName() + ":" + name)).anyTimes();
        EasyMock.expect((Object)layer.getResource()).andReturn((Object)resource).anyTimes();
        EasyMock.expect((Object)layer.getId()).andReturn((Object)(name + "-lid")).anyTimes();
        if (!advertised) {
            EasyMock.expect((Object)layer.isAdvertised()).andReturn((Object)advertised).anyTimes();
        }
        EasyMock.replay((Object[])new Object[]{layer});
        return layer;
    }

    protected StyleInfo buildStyle(String name, WorkspaceInfo ws) {
        StyleInfo style = (StyleInfo)EasyMock.createNiceMock(StyleInfo.class);
        EasyMock.expect((Object)style.getName()).andReturn((Object)name).anyTimes();
        EasyMock.expect((Object)style.getFilename()).andReturn((Object)(name + ".sld")).anyTimes();
        EasyMock.expect((Object)style.getWorkspace()).andReturn((Object)ws).anyTimes();
        EasyMock.replay((Object[])new Object[]{style});
        return style;
    }

    protected LayerGroupInfo buildLayerGroup(String name, StyleInfo style, WorkspaceInfo ws, LayerInfo ... layer) {
        return this.buildLayerGroup(name, LayerGroupInfo.Mode.SINGLE, ws, (PublishedInfo[])layer);
    }

    protected LayerGroupInfo buildLayerGroup(String name, LayerGroupInfo.Mode type, WorkspaceInfo ws, PublishedInfo ... contents) {
        return this.buildLayerGroup(name, type, ws, true, true, contents);
    }

    protected LayerGroupInfo buildLayerGroup(String name, LayerGroupInfo.Mode type, WorkspaceInfo ws, boolean advertised, PublishedInfo ... contents) {
        return this.buildLayerGroup(name, type, ws, advertised, true, contents);
    }

    protected LayerGroupInfo buildLayerGroup(String name, LayerGroupInfo.Mode type, WorkspaceInfo ws, boolean advertised, boolean enabled, PublishedInfo ... contents) {
        LayerGroupInfo layerGroup = (LayerGroupInfo)EasyMock.createNiceMock(LayerGroupInfo.class);
        EasyMock.expect((Object)layerGroup.getName()).andReturn((Object)name).anyTimes();
        EasyMock.expect((Object)layerGroup.prefixedName()).andReturn((Object)((String)(ws != null ? ws.getName() + ":" : "") + name)).anyTimes();
        EasyMock.expect((Object)layerGroup.getMode()).andReturn((Object)type).anyTimes();
        EasyMock.expect((Object)layerGroup.getLayers()).andReturn(new ArrayList<PublishedInfo>(Arrays.asList(contents))).anyTimes();
        EasyMock.expect((Object)layerGroup.getStyles()).andReturn(this.buildUniqueStylesForLayers(contents)).anyTimes();
        EasyMock.expect((Object)layerGroup.getWorkspace()).andReturn((Object)ws).anyTimes();
        EasyMock.expect((Object)layerGroup.layers()).andAnswer(() -> new LayerGroupHelper(layerGroup).allLayers()).anyTimes();
        EasyMock.expect((Object)layerGroup.getId()).andAnswer(() -> (String)(ws == null ? name : ws.getName() + ":" + name) + "-id").anyTimes();
        EasyMock.expect((Object)layerGroup.isAdvertised()).andReturn((Object)advertised).anyTimes();
        EasyMock.replay((Object[])new Object[]{layerGroup});
        return layerGroup;
    }

    private List<StyleInfo> buildUniqueStylesForLayers(PublishedInfo[] contents) {
        if (contents == null) {
            return null;
        }
        ArrayList<StyleInfo> result = new ArrayList<StyleInfo>();
        for (PublishedInfo pi : contents) {
            if (pi instanceof LayerInfo) {
                StyleInfo style = this.buildStyle(pi.prefixedName().replace(':', '-') + "-style", null);
                result.add(style);
                continue;
            }
            result.add(null);
        }
        return result;
    }

    protected LayerGroupInfo buildEOLayerGroup(String name, LayerInfo rootLayer, StyleInfo style, WorkspaceInfo ws, PublishedInfo ... contents) {
        LayerGroupInfo layerGroup = (LayerGroupInfo)EasyMock.createNiceMock(LayerGroupInfo.class);
        EasyMock.expect((Object)layerGroup.getName()).andReturn((Object)name).anyTimes();
        EasyMock.expect((Object)layerGroup.prefixedName()).andReturn((Object)((String)(ws != null ? ws.getName() + ":" : "") + name)).anyTimes();
        EasyMock.expect((Object)layerGroup.getMode()).andReturn((Object)LayerGroupInfo.Mode.EO).anyTimes();
        EasyMock.expect((Object)layerGroup.getRootLayer()).andReturn((Object)rootLayer).anyTimes();
        EasyMock.expect((Object)layerGroup.getLayers()).andReturn(new ArrayList<PublishedInfo>(Arrays.asList(contents))).anyTimes();
        EasyMock.expect((Object)layerGroup.getStyles()).andReturn(Arrays.asList(style)).anyTimes();
        EasyMock.expect((Object)layerGroup.getWorkspace()).andReturn((Object)ws).anyTimes();
        EasyMock.expect((Object)layerGroup.layers()).andAnswer(() -> new LayerGroupHelper(layerGroup).allLayers()).anyTimes();
        EasyMock.expect((Object)layerGroup.getId()).andAnswer(() -> (String)(ws == null ? name : ws.getName() + ":" + name) + "-id").anyTimes();
        EasyMock.replay((Object[])new Object[]{layerGroup});
        return layerGroup;
    }

    protected ResourceAccessManager buildManager(String propertyFile) throws Exception {
        return this.buildManager(propertyFile, null);
    }

    protected ResourceAccessManager buildManager(String propertyFile, ResourceAccessManagerWrapper wrapper) throws Exception {
        DefaultResourceAccessManager manager = this.buildAccessManager(propertyFile);
        if (wrapper != null) {
            wrapper.setDelegate((ResourceAccessManager)manager);
            manager = wrapper;
        }
        this.sc = new SecureCatalogImpl(this.catalog, (ResourceAccessManager)manager){

            protected boolean isAdmin(Authentication authentication) {
                return false;
            }
        };
        GeoServerExtensionsHelper.singleton((String)"secureCatalog", (Object)this.sc, (Class[])new Class[]{SecureCatalogImpl.class});
        return manager;
    }

    protected DefaultResourceAccessManager buildAccessManager(String propertyFile) throws Exception {
        Properties props = new Properties();
        props.load(this.getClass().getResourceAsStream(propertyFile));
        DefaultResourceAccessManager defaultResourceAccessManager = new DefaultResourceAccessManager((DataAccessRuleDAO)new MemoryDataAccessRuleDAO(this.catalog, props), this.catalog);
        defaultResourceAccessManager.setGroupsCache(new LayerGroupContainmentCache(this.catalog));
        return defaultResourceAccessManager;
    }

    protected void populateCatalog() {
        this.layers = Arrays.asList(this.statesLayer, this.roadsLayer, this.landmarksLayer, this.basesLayer, this.arcGridLayer, this.cascadedLayer, this.cascadedWmtsLayer);
        this.featureTypes = new ArrayList<FeatureTypeInfo>();
        this.coverages = new ArrayList<CoverageInfo>();
        this.wmsLayers = new ArrayList<WMSLayerInfo>();
        this.wmtsLayers = new ArrayList<WMTSLayerInfo>();
        for (LayerInfo layer : this.layers) {
            if (layer.getResource() instanceof FeatureTypeInfo) {
                this.featureTypes.add((FeatureTypeInfo)layer.getResource());
                continue;
            }
            if (layer.getResource() instanceof WMSLayerInfo) {
                this.wmsLayers.add((WMSLayerInfo)layer.getResource());
                continue;
            }
            if (layer.getResource() instanceof WMTSLayerInfo) {
                this.wmtsLayers.add((WMTSLayerInfo)layer.getResource());
                continue;
            }
            this.coverages.add((CoverageInfo)layer.getResource());
        }
        this.workspaces = Arrays.asList(this.toppWs, this.nurcWs);
        this.catalog = (Catalog)EasyMock.createNiceMock(Catalog.class);
        EasyMock.expect((Object)this.catalog.getFeatureTypeByName("topp:states")).andReturn((Object)this.states).anyTimes();
        EasyMock.expect((Object)this.catalog.getLayerByName("topp:cascaded")).andReturn((Object)this.cascadedLayer).anyTimes();
        EasyMock.expect((Object)((WMSLayerInfo)this.catalog.getResourceByName("topp:cascaded", WMSLayerInfo.class))).andReturn((Object)this.cascaded).anyTimes();
        EasyMock.expect((Object)this.catalog.getLayerByName("topp:cascadedWmts")).andReturn((Object)this.cascadedWmtsLayer).anyTimes();
        EasyMock.expect((Object)((WMTSLayerInfo)this.catalog.getResourceByName("topp:cascadedWmts", WMTSLayerInfo.class))).andReturn((Object)this.cascadedWmts).anyTimes();
        EasyMock.expect((Object)((FeatureTypeInfo)this.catalog.getResourceByName("topp:states", FeatureTypeInfo.class))).andReturn((Object)this.states).anyTimes();
        EasyMock.expect((Object)this.catalog.getLayerByName("topp:states")).andReturn((Object)this.statesLayer).anyTimes();
        EasyMock.expect((Object)this.catalog.getCoverageByName("nurc:arcgrid")).andReturn((Object)this.arcGrid).anyTimes();
        EasyMock.expect((Object)((CoverageInfo)this.catalog.getResourceByName("nurc:arcgrid", CoverageInfo.class))).andReturn((Object)this.arcGrid).anyTimes();
        EasyMock.expect((Object)this.catalog.getFeatureTypeByName("topp:roads")).andReturn((Object)this.roads).anyTimes();
        EasyMock.expect((Object)this.catalog.getFeatureTypeByName("nurc:cities")).andReturn((Object)this.cities).anyTimes();
        EasyMock.expect((Object)this.catalog.getLayerByName("topp:roads")).andReturn((Object)this.roadsLayer).anyTimes();
        EasyMock.expect((Object)this.catalog.getLayerByName("nurc:cities")).andReturn((Object)this.citiesLayer).anyTimes();
        EasyMock.expect((Object)this.catalog.getFeatureTypeByName("topp:landmarks")).andReturn((Object)this.landmarks).anyTimes();
        EasyMock.expect((Object)this.catalog.getFeatureTypeByName("topp:bases")).andReturn((Object)this.bases).anyTimes();
        EasyMock.expect((Object)this.catalog.getDataStoreByName("states")).andReturn((Object)this.statesStore).anyTimes();
        EasyMock.expect((Object)this.catalog.getDataStoreByName("roads")).andReturn((Object)this.roadsStore).anyTimes();
        EasyMock.expect((Object)this.catalog.getCoverageStoreByName("arcGrid")).andReturn((Object)this.arcGridStore).anyTimes();
        EasyMock.expect((Object)this.catalog.getLayerByName("topp:landmarks")).andReturn((Object)this.landmarksLayer).anyTimes();
        EasyMock.expect((Object)this.catalog.getLayerByName("topp:bases")).andReturn((Object)this.basesLayer).anyTimes();
        EasyMock.expect((Object)this.catalog.getLayerByName("nurc:arc.grid")).andReturn((Object)this.arcGridLayer).anyTimes();
        EasyMock.expect((Object)this.catalog.getLayerByName("topp:forests")).andReturn((Object)this.forestsLayer).anyTimes();
        EasyMock.expect((Object)this.catalog.getLayers()).andReturn(this.layers).anyTimes();
        this.stubList(this.catalog, LayerInfo.class, this.layers);
        EasyMock.expect((Object)this.catalog.getFeatureTypes()).andReturn(this.featureTypes).anyTimes();
        this.stubList(this.catalog, FeatureTypeInfo.class, this.featureTypes);
        EasyMock.expect((Object)this.catalog.getCoverages()).andReturn(this.coverages).anyTimes();
        this.stubList(this.catalog, CoverageInfo.class, this.coverages);
        EasyMock.expect((Object)this.catalog.getWorkspaces()).andReturn(this.workspaces).anyTimes();
        this.stubList(this.catalog, WorkspaceInfo.class, this.workspaces);
        this.stubList(this.catalog, StyleInfo.class, Arrays.asList(this.pointStyle, this.lineStyle));
        EasyMock.expect((Object)this.catalog.getWorkspaceByName("topp")).andReturn((Object)this.toppWs).anyTimes();
        EasyMock.expect((Object)this.catalog.getWorkspaceByName("nurc")).andReturn((Object)this.nurcWs).anyTimes();
        EasyMock.expect((Object)this.catalog.getStyles()).andReturn(Arrays.asList(this.pointStyle, this.lineStyle)).anyTimes();
        EasyMock.expect((Object)this.catalog.getStylesByWorkspace(this.toppWs)).andReturn(Arrays.asList(this.pointStyle, this.lineStyle)).anyTimes();
        EasyMock.expect((Object)this.catalog.getStylesByWorkspace(this.nurcWs)).andReturn(Arrays.asList(this.pointStyle)).anyTimes();
        EasyMock.expect((Object)this.catalog.getLayerGroups()).andReturn(this.layerGroups).anyTimes();
        for (LayerGroupInfo lg : this.layerGroups) {
            EasyMock.expect((Object)this.catalog.getLayerGroup(lg.getId())).andReturn((Object)lg).anyTimes();
            if (lg.getWorkspace() == null) {
                EasyMock.expect((Object)this.catalog.getLayerGroupByName(lg.getName())).andReturn((Object)lg).anyTimes();
                EasyMock.expect((Object)this.catalog.getLayerGroupByName(NULL_STRING, lg.getName())).andReturn((Object)lg).anyTimes();
                continue;
            }
            EasyMock.expect((Object)this.catalog.getLayerGroupByName(lg.getWorkspace(), lg.getName())).andReturn((Object)lg).anyTimes();
            EasyMock.expect((Object)this.catalog.getLayerGroupByName(lg.getWorkspace().getName(), lg.getName())).andReturn((Object)lg).anyTimes();
            EasyMock.expect((Object)this.catalog.getLayerGroupByName(lg.getWorkspace().getName() + ":" + lg.getName())).andReturn((Object)lg).anyTimes();
        }
        EasyMock.expect((Object)this.catalog.getLayerGroupsByWorkspace("topp")).andReturn(Arrays.asList(this.layerGroupTopp, this.layerGroupWithSomeLockedLayer)).anyTimes();
        EasyMock.expect((Object)this.catalog.getLayerGroupsByWorkspace("nurc")).andReturn(Arrays.asList(this.layerGroupGlobal)).anyTimes();
        EasyMock.expect((Object)this.catalog.list((Class)EasyMock.eq(LayerGroupInfo.class), (Filter)EasyMock.anyObject(Filter.class))).andAnswer(() -> {
            List groups = this.catalog.getLayerGroups();
            Filter f = (Filter)EasyMock.getCurrentArguments()[1];
            Iterator it = groups.stream().filter(lg -> f.evaluate(lg)).iterator();
            return new CloseableIteratorAdapter(it);
        }).anyTimes();
        EasyMock.expect((Object)this.catalog.list((Class)EasyMock.eq(LayerGroupInfo.class), (Filter)EasyMock.anyObject(Filter.class), (Integer)EasyMock.anyObject(), (Integer)EasyMock.anyObject(), (SortBy)EasyMock.anyObject())).andAnswer(() -> {
            SortBy sortBy;
            Integer count;
            List groups = this.catalog.getLayerGroups();
            Filter f = (Filter)EasyMock.getCurrentArguments()[1];
            Stream<LayerGroupInfo> stream = groups.stream().filter(lg -> f.evaluate(lg));
            Integer offset = (Integer)EasyMock.getCurrentArguments()[2];
            if (offset != null) {
                stream = stream.skip(offset.intValue());
            }
            if ((count = (Integer)EasyMock.getCurrentArguments()[3]) != null) {
                stream = stream.limit(count.intValue());
            }
            if ((sortBy = (SortBy)EasyMock.getCurrentArguments()[4]) != null) {
                PropertyComparator comparator = new PropertyComparator(sortBy.getPropertyName().getPropertyName(), false, sortBy.getSortOrder() == SortOrder.ASCENDING);
                stream = stream.sorted((Comparator<LayerGroupInfo>)comparator);
            }
            Iterator it = stream.iterator();
            return new CloseableIteratorAdapter(it);
        }).anyTimes();
        EasyMock.replay((Object[])new Object[]{this.catalog});
        GeoServerExtensionsHelper.singleton((String)"catalog", (Object)this.catalog, (Class[])new Class[0]);
    }

    <T extends CatalogInfo> void stubList(Catalog mock, Class<T> clazz, List<T> source) {
        Capture cap = Capture.newInstance((CaptureType)CaptureType.LAST);
        EasyMock.expect((Object)this.catalog.list((Class)EasyMock.eq(clazz), (Filter)EasyMock.capture((Capture)cap))).andStubAnswer(() -> AbstractAuthorizationTest.makeCIterator(source, (Filter)cap.getValue()));
        EasyMock.expect((Object)this.catalog.list((Class)EasyMock.eq(clazz), (Filter)EasyMock.capture((Capture)cap), Integer.valueOf(EasyMock.anyInt()), Integer.valueOf(EasyMock.anyInt()), (SortBy)EasyMock.anyObject())).andStubAnswer(() -> AbstractAuthorizationTest.makeCIterator(source, (Filter)cap.getValue()));
    }

    static <T> CloseableIterator<T> makeCIterator(List<T> source, Filter f) {
        return CloseableIteratorAdapter.filter(source.iterator(), (Filter)f);
    }
}

