/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.security;

import java.io.ByteArrayInputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import org.apache.commons.io.output.ByteArrayOutputStream;
import org.geoserver.security.AccessLimits;
import org.geoserver.security.CatalogMode;
import org.geoserver.security.CoverageAccessLimits;
import org.geoserver.security.DataAccessLimits;
import org.geoserver.security.VectorAccessLimits;
import org.geoserver.security.WMSAccessLimits;
import org.geoserver.security.WorkspaceAccessLimits;
import org.geotools.api.filter.Filter;
import org.geotools.api.filter.FilterFactory;
import org.geotools.api.filter.expression.Expression;
import org.geotools.api.filter.expression.PropertyName;
import org.geotools.factory.CommonFactoryFinder;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.locationtech.jts.geom.MultiPolygon;
import org.locationtech.jts.io.WKTReader;

public class TestAccessLimitsSerialization {
    FilterFactory ff;
    Filter filter;
    MultiPolygon g;

    @Before
    public void setUp() throws Exception {
        this.ff = CommonFactoryFinder.getFilterFactory(null);
        this.filter = this.ff.equal((Expression)this.ff.property("attribute"), (Expression)this.ff.literal(3), true);
        this.g = (MultiPolygon)new WKTReader().read("MULTIPOLYGON(((0 0, 0 10, 10 10, 10 0, 0 0)))");
    }

    @Test
    public void testAccessLimits() throws Exception {
        AccessLimits limits = new AccessLimits(CatalogMode.MIXED);
        this.testObjectSerialization((Serializable)limits);
    }

    @Test
    public void testSerializeWorkspaceAccessLimits() throws Exception {
        WorkspaceAccessLimits limits = new WorkspaceAccessLimits(CatalogMode.HIDE, true, true, true);
        this.testObjectSerialization((Serializable)limits);
    }

    @Test
    public void testSerializeDataAccessLimits() throws Exception {
        DataAccessLimits limits = new DataAccessLimits(CatalogMode.CHALLENGE, this.filter);
        this.testObjectSerialization((Serializable)limits);
    }

    @Test
    public void testSerializeFilterIncludeAsObject() throws Exception {
        DataAccessLimits limits = new DataAccessLimits(CatalogMode.CHALLENGE, (Filter)Filter.INCLUDE);
        this.testObjectSerialization((Serializable)limits);
    }

    @Test
    public void testSerializeFilterExcludeAsObject() throws Exception {
        DataAccessLimits limits = new DataAccessLimits(CatalogMode.CHALLENGE, (Filter)Filter.EXCLUDE);
        this.testObjectSerialization((Serializable)limits);
    }

    @Test
    public void testCoverageAccessLimits() throws Exception {
        CoverageAccessLimits limits = new CoverageAccessLimits(CatalogMode.MIXED, this.filter, this.g, null);
        this.testObjectSerialization((Serializable)limits);
    }

    @Test
    public void testVectorAccessLimits() throws Exception {
        ArrayList<PropertyName> properties = new ArrayList<PropertyName>();
        properties.add(this.ff.property("test"));
        VectorAccessLimits limits = new VectorAccessLimits(CatalogMode.MIXED, properties, this.filter, properties, this.filter);
        this.testObjectSerialization((Serializable)limits);
    }

    @Test
    public void testWMSAccessLimits() throws Exception {
        ArrayList<PropertyName> properties = new ArrayList<PropertyName>();
        properties.add(this.ff.property("test"));
        WMSAccessLimits limits = new WMSAccessLimits(CatalogMode.MIXED, this.filter, this.g, true);
        this.testObjectSerialization((Serializable)limits);
    }

    private void testObjectSerialization(Serializable object) throws Exception {
        try (ByteArrayOutputStream bos = new ByteArrayOutputStream();
             ObjectOutputStream oos = new ObjectOutputStream((OutputStream)bos);){
            oos.writeObject(object);
            try (ObjectInputStream ois = new ObjectInputStream(new ByteArrayInputStream(bos.toByteArray()));){
                Object clone = ois.readObject();
                Assert.assertNotSame((Object)object, (Object)clone);
                Assert.assertEquals((Object)object, (Object)clone);
            }
        }
    }
}

