/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.security.validation;

import java.io.IOException;
import org.geoserver.security.GeoServerAuthenticationProvider;
import org.geoserver.security.GeoServerRoleService;
import org.geoserver.security.GeoServerSecurityFilterChain;
import org.geoserver.security.GeoServerUserGroupService;
import org.geoserver.security.ServiceLoginFilterChain;
import org.geoserver.security.auth.UsernamePasswordAuthenticationProvider;
import org.geoserver.security.config.BaseSecurityNamedServiceConfig;
import org.geoserver.security.config.PasswordPolicyConfig;
import org.geoserver.security.config.SecurityAuthProviderConfig;
import org.geoserver.security.config.SecurityManagerConfig;
import org.geoserver.security.config.SecurityNamedServiceConfig;
import org.geoserver.security.config.SecurityRoleServiceConfig;
import org.geoserver.security.config.SecurityUserGroupServiceConfig;
import org.geoserver.security.config.UsernamePasswordAuthenticationProviderConfig;
import org.geoserver.security.config.impl.MemoryRoleServiceConfigImpl;
import org.geoserver.security.config.impl.MemoryUserGroupServiceConfigImpl;
import org.geoserver.security.filter.GeoServerSecurityFilter;
import org.geoserver.security.impl.GeoServerRole;
import org.geoserver.security.impl.MemoryRoleService;
import org.geoserver.security.impl.MemoryUserGroupService;
import org.geoserver.security.password.PasswordValidator;
import org.geoserver.security.validation.PasswordValidatorImpl;
import org.geoserver.security.validation.SecurityConfigException;
import org.geoserver.security.validation.SecurityConfigValidator;
import org.geoserver.security.xml.XMLRoleService;
import org.geoserver.security.xml.XMLUserGroupService;
import org.geoserver.test.GeoServerSystemTestSupport;
import org.junit.Assert;
import org.junit.Test;

public class SecurityConfigValidatorTest
extends GeoServerSystemTestSupport {
    @Test
    public void testMasterConfigValidation() throws Exception {
        SecurityManagerConfig config = new SecurityManagerConfig();
        config.setRoleServiceName(XMLRoleService.DEFAULT_NAME);
        config.setConfigPasswordEncrypterName(this.getPBEPasswordEncoder().getName());
        config.getAuthProviderNames().add(GeoServerAuthenticationProvider.DEFAULT_NAME);
        SecurityConfigValidator validator = new SecurityConfigValidator(this.getSecurityManager());
        validator.validateManagerConfig(config, new SecurityManagerConfig());
        try {
            config.setConfigPasswordEncrypterName("abc");
            validator.validateManagerConfig(config, new SecurityManagerConfig());
            Assert.fail((String)"invalid password encoder should fail");
        }
        catch (SecurityConfigException ex) {
            Assert.assertEquals((Object)"INVALID_PASSWORD_ENCODER", (Object)ex.getId());
        }
        try {
            config.setConfigPasswordEncrypterName(null);
            validator.validateManagerConfig(config, new SecurityManagerConfig());
            Assert.fail((String)"no password encoder should fail");
        }
        catch (SecurityConfigException ex) {
            Assert.assertEquals((Object)"PASSWORD_ENCODER_REQUIRED", (Object)ex.getId());
        }
        if (!this.getSecurityManager().isStrongEncryptionAvailable()) {
            config.setConfigPasswordEncrypterName(this.getStrongPBEPasswordEncoder().getName());
            try {
                validator.validateManagerConfig(config, new SecurityManagerConfig());
                Assert.fail((String)"invalid strong password encoder should fail");
            }
            catch (SecurityConfigException ex) {
                Assert.assertEquals((Object)"INVALID_STRONG_CONFIG_PASSWORD_ENCODER", (Object)ex.getId());
            }
        }
        config.setConfigPasswordEncrypterName(this.getPBEPasswordEncoder().getName());
        config.setRoleServiceName("XX");
        try {
            validator.validateManagerConfig(config, new SecurityManagerConfig());
            Assert.fail((String)"unknown role service should fail");
        }
        catch (SecurityConfigException ex) {
            Assert.assertEquals((Object)"ROLE_SERVICE_NOT_FOUND", (Object)ex.getId());
        }
        config.setRoleServiceName(null);
        try {
            validator.validateManagerConfig(config, new SecurityManagerConfig());
            Assert.fail((String)"null role service should fail");
        }
        catch (SecurityConfigException ex) {
            Assert.assertEquals((Object)"ROLE_SERVICE_NOT_FOUND", (Object)ex.getId());
        }
        config.setRoleServiceName(XMLRoleService.DEFAULT_NAME);
        config.getAuthProviderNames().add("XX");
        try {
            validator.validateManagerConfig(config, new SecurityManagerConfig());
            Assert.fail((String)"unknown auth provider should fail");
        }
        catch (SecurityConfigException ex) {
            Assert.assertEquals((Object)"AUTH_PROVIDER_NOT_FOUND", (Object)ex.getId());
        }
        config.getAuthProviderNames().remove("XX");
        GeoServerSecurityFilterChain filterChain = new GeoServerSecurityFilterChain();
        config.setFilterChain(filterChain);
        ServiceLoginFilterChain chain = new ServiceLoginFilterChain(new String[0]);
        filterChain.getRequestChains().add(chain);
        try {
            validator.validateManagerConfig(config, new SecurityManagerConfig());
            Assert.fail((String)"chain with no name should fail");
        }
        catch (SecurityConfigException ex) {
            Assert.assertEquals((Object)"FILTER_CHAIN_NAME_MANDATORY", (Object)ex.getId());
            Assert.assertEquals((long)0L, (long)ex.getArgs().length);
        }
        String chainName = "testChain";
        chain.setName(chainName);
        try {
            validator.validateManagerConfig(config, new SecurityManagerConfig());
            Assert.fail((String)"chain with no patterns should fail");
        }
        catch (SecurityConfigException ex) {
            Assert.assertEquals((Object)"PATTERN_LIST_EMPTY", (Object)ex.getId());
            Assert.assertEquals((long)1L, (long)ex.getArgs().length);
            Assert.assertEquals((Object)chainName, (Object)ex.getArgs()[0]);
        }
        chain.getPatterns().add("/**");
        chain.setDisabled(true);
        validator.validateManagerConfig(config, new SecurityManagerConfig());
        chain.setDisabled(false);
        try {
            validator.validateManagerConfig(config, new SecurityManagerConfig());
            Assert.fail((String)"enabled authentication chain with no filter should fail");
        }
        catch (SecurityConfigException ex) {
            Assert.assertEquals((Object)"FILTER_CHAIN_EMPTY", (Object)ex.getId());
            Assert.assertEquals((long)1L, (long)ex.getArgs().length);
            Assert.assertEquals((Object)chainName, (Object)ex.getArgs()[0]);
        }
        String unknownFilter = "unknown";
        chain.getFilterNames().add(unknownFilter);
        chain.setRoleFilterName("XX");
        try {
            validator.validateManagerConfig(config, new SecurityManagerConfig());
            Assert.fail((String)"unknown role filter should fail");
        }
        catch (SecurityConfigException ex) {
            Assert.assertEquals((Object)"UNKNOWN_ROLE_FILTER", (Object)ex.getId());
            Assert.assertEquals((long)2L, (long)ex.getArgs().length);
            Assert.assertEquals((Object)chainName, (Object)ex.getArgs()[0]);
            Assert.assertEquals((Object)"XX", (Object)ex.getArgs()[1]);
        }
        chain.setRoleFilterName("roleFilter");
        chain.getFilterNames().add(0, "anonymous");
        try {
            validator.validateManagerConfig(config, new SecurityManagerConfig());
            Assert.fail((String)"anonymous not last should fail");
        }
        catch (SecurityConfigException ex) {
            Assert.assertEquals((Object)"ANONYMOUS_NOT_LAST", (Object)ex.getId());
            Assert.assertEquals((long)1L, (long)ex.getArgs().length);
            Assert.assertEquals((Object)chainName, (Object)ex.getArgs()[0]);
        }
        chain.getFilterNames().remove("anonymous");
        chain.getFilterNames().add("anonymous");
        try {
            validator.validateManagerConfig(config, new SecurityManagerConfig());
            Assert.fail((String)"unknown  filter should fail");
        }
        catch (SecurityConfigException ex) {
            Assert.assertEquals((Object)"UNKNOWN_FILTER", (Object)ex.getId());
            Assert.assertEquals((long)2L, (long)ex.getArgs().length);
            Assert.assertEquals((Object)chainName, (Object)ex.getArgs()[0]);
            Assert.assertEquals((Object)unknownFilter, (Object)ex.getArgs()[1]);
        }
        chain.getFilterNames().remove(unknownFilter);
        chain.getFilterNames().add(0, "roleFilter");
        try {
            validator.validateManagerConfig(config, new SecurityManagerConfig());
            Assert.fail((String)"no authentication filter should fail");
        }
        catch (SecurityConfigException ex) {
            Assert.assertEquals((Object)"NOT_AN_AUTHENTICATION_FILTER", (Object)ex.getId());
            Assert.assertEquals((long)2L, (long)ex.getArgs().length);
            Assert.assertEquals((Object)chainName, (Object)ex.getArgs()[0]);
            Assert.assertEquals((Object)"roleFilter", (Object)ex.getArgs()[1]);
        }
        chain.getFilterNames().remove("roleFilter");
        chain.getFilterNames().add(0, "form");
        try {
            validator.validateManagerConfig(config, new SecurityManagerConfig());
            Assert.fail((String)"form login filter should fail");
        }
        catch (SecurityConfigException ex) {
            Assert.assertEquals((Object)"NOT_A_SERVICE_AUTHENTICATION_FILTER", (Object)ex.getId());
            Assert.assertEquals((long)2L, (long)ex.getArgs().length);
            Assert.assertEquals((Object)chainName, (Object)ex.getArgs()[0]);
            Assert.assertEquals((Object)"form", (Object)ex.getArgs()[1]);
        }
        chain.getFilterNames().remove("form");
        chain.getFilterNames().add(0, "basic");
        validator.validateManagerConfig(config, new SecurityManagerConfig());
    }

    @Test
    public void testNamedServices() {
        Class[] extensionPoints;
        SecurityConfigValidator validator = new SecurityConfigValidator(this.getSecurityManager());
        for (Class ep : extensionPoints = new Class[]{GeoServerUserGroupService.class, GeoServerRoleService.class, PasswordValidator.class, GeoServerAuthenticationProvider.class, GeoServerSecurityFilter.class}) {
            try {
                validator.checkExtensionPont(ep, "a.b.c");
                Assert.fail((String)"unknown class should fail");
            }
            catch (SecurityConfigException ex) {
                Assert.assertEquals((Object)ex.getId(), (Object)"CLASS_NOT_FOUND");
                Assert.assertEquals((Object)ex.getArgs()[0], (Object)"a.b.c");
            }
            try {
                validator.checkExtensionPont(ep, "java.lang.String");
                Assert.fail((String)"wrong class should fail");
            }
            catch (SecurityConfigException ex) {
                Assert.assertEquals((Object)ex.getId(), (Object)"CLASS_WRONG_TYPE");
                Assert.assertEquals((Object)ex.getArgs()[0], (Object)ep);
                Assert.assertEquals((Object)ex.getArgs()[1], (Object)"java.lang.String");
            }
            String className = ep == GeoServerUserGroupService.class ? null : "";
            try {
                validator.checkExtensionPont(ep, className);
                Assert.fail((String)"no class should fail");
            }
            catch (SecurityConfigException ex) {
                Assert.assertEquals((Object)ex.getId(), (Object)"CLASSNAME_REQUIRED");
                Assert.assertEquals((long)0L, (long)ex.getArgs().length);
            }
            String name = ep == GeoServerUserGroupService.class ? null : "";
            try {
                validator.checkServiceName(ep, name);
                Assert.fail((String)"no name should fail");
            }
            catch (SecurityConfigException ex) {
                Assert.assertEquals((Object)ex.getId(), (Object)"NAME_REQUIRED");
                Assert.assertEquals((long)0L, (long)ex.getArgs().length);
            }
        }
        try {
            validator.validateAddPasswordPolicy(this.createPolicyConfig("default", PasswordValidatorImpl.class, 1, 10));
            Assert.fail((String)"passwd policy already exists should fail");
        }
        catch (SecurityConfigException ex) {
            Assert.assertEquals((Object)"PASSWD_POLICY_ALREADY_EXISTS", (Object)ex.getId());
            Assert.assertEquals((Object)ex.getArgs()[0], (Object)"default");
        }
        PasswordPolicyConfig pwConfig = this.createPolicyConfig("default2", PasswordValidatorImpl.class, 1, 10);
        try {
            validator.validateModifiedPasswordPolicy(pwConfig, pwConfig);
            Assert.fail((String)"unknown passwd policy should fail");
        }
        catch (SecurityConfigException ex) {
            Assert.assertEquals((Object)"PASSWD_POLICY_NOT_FOUND", (Object)ex.getId());
            Assert.assertEquals((Object)ex.getArgs()[0], (Object)"default2");
        }
        try {
            validator.validateAddUserGroupService(this.createUGConfig(XMLUserGroupService.DEFAULT_NAME, GeoServerUserGroupService.class, this.getPlainTextPasswordEncoder().getName(), "default"));
            Assert.fail((String)"user group service already exists should fail");
        }
        catch (SecurityConfigException ex) {
            Assert.assertEquals((Object)ex.getId(), (Object)"USERGROUP_SERVICE_ALREADY_EXISTS");
            Assert.assertEquals((Object)ex.getArgs()[0], (Object)XMLUserGroupService.DEFAULT_NAME);
        }
        SecurityUserGroupServiceConfig ugConfig = this.createUGConfig("default2", GeoServerUserGroupService.class, this.getPlainTextPasswordEncoder().getName(), "default");
        try {
            validator.validateModifiedUserGroupService(ugConfig, ugConfig);
            Assert.fail((String)"unknown user group service should fail");
        }
        catch (SecurityConfigException ex) {
            Assert.assertEquals((Object)ex.getId(), (Object)"USERGROUP_SERVICE_NOT_FOUND");
            Assert.assertEquals((Object)ex.getArgs()[0], (Object)"default2");
        }
        try {
            validator.validateAddRoleService(this.createRoleConfig(XMLRoleService.DEFAULT_NAME, GeoServerRoleService.class, GeoServerRole.ADMIN_ROLE.getAuthority()));
            Assert.fail((String)"role service already exists should fail");
        }
        catch (SecurityConfigException ex) {
            Assert.assertEquals((Object)ex.getId(), (Object)"ROLE_SERVICE_ALREADY_EXISTS");
            Assert.assertEquals((Object)ex.getArgs()[0], (Object)XMLRoleService.DEFAULT_NAME);
        }
        SecurityRoleServiceConfig config = this.createRoleConfig("default2", GeoServerRoleService.class, GeoServerRole.ADMIN_ROLE.getAuthority());
        try {
            validator.validateModifiedRoleService(config, config);
            Assert.fail((String)"unknown role service should fail");
        }
        catch (SecurityConfigException ex) {
            Assert.assertEquals((Object)ex.getId(), (Object)"ROLE_SERVICE_NOT_FOUND");
            Assert.assertEquals((Object)ex.getArgs()[0], (Object)"default2");
        }
        try {
            validator.validateAddAuthProvider(this.createAuthConfig(GeoServerAuthenticationProvider.DEFAULT_NAME, UsernamePasswordAuthenticationProvider.class, XMLUserGroupService.DEFAULT_NAME));
            Assert.fail((String)"auth provider already exists should fail");
        }
        catch (SecurityConfigException ex) {
            Assert.assertEquals((Object)ex.getId(), (Object)"AUTH_PROVIDER_ALREADY_EXISTS");
            Assert.assertEquals((Object)ex.getArgs()[0], (Object)GeoServerAuthenticationProvider.DEFAULT_NAME);
        }
        SecurityAuthProviderConfig aConfig = this.createAuthConfig("default2", UsernamePasswordAuthenticationProvider.class, XMLUserGroupService.DEFAULT_NAME);
        try {
            validator.validateModifiedAuthProvider(aConfig, aConfig);
            Assert.fail((String)"unknown auth provider should fail");
        }
        catch (SecurityConfigException ex) {
            Assert.assertEquals((Object)ex.getId(), (Object)"AUTH_PROVIDER_NOT_FOUND");
            Assert.assertEquals((Object)ex.getArgs()[0], (Object)"default2");
        }
    }

    protected SecurityAuthProviderConfig createAuthConfig(String name, Class<?> aClass, String userGroupServiceName) {
        UsernamePasswordAuthenticationProviderConfig config = new UsernamePasswordAuthenticationProviderConfig();
        config.setName(name);
        config.setClassName(aClass.getName());
        config.setUserGroupServiceName(userGroupServiceName);
        return config;
    }

    protected SecurityUserGroupServiceConfig createUGConfig(String name, Class<?> aClass, String encoder, String policyName) {
        MemoryUserGroupServiceConfigImpl config = new MemoryUserGroupServiceConfigImpl();
        config.setName(name);
        config.setClassName(aClass.getName());
        config.setPasswordEncoderName(encoder);
        config.setPasswordPolicyName(policyName);
        return config;
    }

    protected SecurityRoleServiceConfig createRoleConfig(String name, Class<?> aClass, String adminRole) {
        MemoryRoleServiceConfigImpl config = new MemoryRoleServiceConfigImpl();
        config.setName(name);
        config.setClassName(aClass.getName());
        config.setAdminRoleName(adminRole);
        return config;
    }

    protected PasswordPolicyConfig createPolicyConfig(String name, Class<?> aClass, int min, int max) {
        PasswordPolicyConfig config = new PasswordPolicyConfig();
        config.setName(name);
        config.setClassName(aClass.getName());
        config.setMinLength(min);
        config.setMaxLength(max);
        return config;
    }

    protected SecurityNamedServiceConfig createFilterConfig(String name, Class<?> aClass) {
        BaseSecurityNamedServiceConfig config = new BaseSecurityNamedServiceConfig();
        config.setName(name);
        config.setClassName(aClass.getName());
        return config;
    }

    @Test
    public void testPasswordPolicy() throws IOException {
        SecurityConfigValidator validator = new SecurityConfigValidator(this.getSecurityManager());
        PasswordPolicyConfig config = this.createPolicyConfig("default", PasswordValidatorImpl.class, -1, 10);
        try {
            config.setName("default2");
            validator.validateAddPasswordPolicy(config);
            Assert.fail((String)"invalid min length should fail");
        }
        catch (SecurityConfigException ex) {
            Assert.assertEquals((Object)"INVALID_MIN_LENGTH", (Object)ex.getId());
            Assert.assertEquals((long)0L, (long)ex.getArgs().length);
        }
        try {
            validator.validateAddPasswordPolicy(config);
            Assert.fail((String)"invalid min length should fail");
        }
        catch (SecurityConfigException ex) {
            Assert.assertEquals((Object)"INVALID_MIN_LENGTH", (Object)ex.getId());
            Assert.assertEquals((long)0L, (long)ex.getArgs().length);
        }
        config.setMinLength(1);
        config.setMaxLength(0);
        try {
            validator.validateAddPasswordPolicy(config);
            Assert.fail((String)"invalid max length should fail");
            this.getSecurityManager().savePasswordPolicy(config);
        }
        catch (SecurityConfigException ex) {
            Assert.assertEquals((Object)"INVALID_MAX_LENGTH", (Object)ex.getId());
            Assert.assertEquals((long)0L, (long)ex.getArgs().length);
        }
        try {
            validator.validateAddPasswordPolicy(config);
            Assert.fail((String)"invalid max length should fail");
        }
        catch (SecurityConfigException ex) {
            Assert.assertEquals((Object)"INVALID_MAX_LENGTH", (Object)ex.getId());
            Assert.assertEquals((long)0L, (long)ex.getArgs().length);
        }
        config.setMaxLength(-1);
        try {
            config.setName("");
            validator.validateRemovePasswordPolicy(config);
            Assert.fail((String)"no name should fail");
        }
        catch (SecurityConfigException ex) {
            Assert.assertEquals((Object)"NAME_REQUIRED", (Object)ex.getId());
            Assert.assertEquals((long)0L, (long)ex.getArgs().length);
        }
        try {
            config.setName("default");
            validator.validateRemovePasswordPolicy(config);
            Assert.fail((String)"remove active should fail");
        }
        catch (SecurityConfigException ex) {
            Assert.assertEquals((Object)"PASSWD_POLICY_ACTIVE", (Object)ex.getId());
            Assert.assertEquals((Object)"default", (Object)ex.getArgs()[0]);
            Assert.assertEquals((Object)XMLUserGroupService.DEFAULT_NAME, (Object)ex.getArgs()[1]);
        }
        try {
            config.setName("master");
            validator.validateRemovePasswordPolicy(config);
            Assert.fail((String)"remove master should fail");
        }
        catch (SecurityConfigException ex) {
            Assert.assertEquals((Object)"PASSWD_POLICY_MASTER_DELETE", (Object)ex.getId());
            Assert.assertEquals((long)0L, (long)ex.getArgs().length);
        }
    }

    @Test
    public void testRoleConfig() throws IOException {
        SecurityRoleServiceConfig config = this.createRoleConfig(XMLRoleService.DEFAULT_NAME, MemoryRoleService.class, GeoServerRole.ADMIN_ROLE.getAuthority());
        SecurityConfigValidator validator = new SecurityConfigValidator(this.getSecurityManager());
        try {
            config.setName(null);
            validator.validateRemoveRoleService(config);
            Assert.fail((String)"no name should fail");
        }
        catch (SecurityConfigException ex) {
            Assert.assertEquals((Object)"NAME_REQUIRED", (Object)ex.getId());
            Assert.assertEquals((long)0L, (long)ex.getArgs().length);
        }
        config.setName("abcd");
        for (GeoServerRole role : GeoServerRole.SystemRoles) {
            config.setAdminRoleName(role.getAuthority());
            try {
                validator.validateAddRoleService(config);
                Assert.fail((String)"reserved role name should fail");
            }
            catch (SecurityConfigException ex) {
                Assert.assertEquals((Object)"RESERVED_ROLE_NAME", (Object)ex.getId());
                Assert.assertEquals((Object)role.getAuthority(), (Object)ex.getArgs()[0]);
            }
        }
        for (GeoServerRole role : GeoServerRole.SystemRoles) {
            config.setGroupAdminRoleName(role.getAuthority());
            try {
                validator.validateAddRoleService(config);
                Assert.fail((String)"resoerved role name should fail");
            }
            catch (SecurityConfigException ex) {
                Assert.assertEquals((Object)"RESERVED_ROLE_NAME", (Object)ex.getId());
                Assert.assertEquals((Object)role.getAuthority(), (Object)ex.getArgs()[0]);
            }
        }
        try {
            config.setName(XMLRoleService.DEFAULT_NAME);
            validator.validateRemoveRoleService(config);
            Assert.fail((String)"role service active should fail");
        }
        catch (SecurityConfigException ex) {
            Assert.assertEquals((Object)"ROLE_SERVICE_ACTIVE", (Object)ex.getId());
            Assert.assertEquals((Object)XMLRoleService.DEFAULT_NAME, (Object)ex.getArgs()[0]);
        }
    }

    @Test
    public void testAuthenticationProvider() throws IOException {
        SecurityAuthProviderConfig config = this.createAuthConfig(GeoServerAuthenticationProvider.DEFAULT_NAME, UsernamePasswordAuthenticationProvider.class, "default2");
        SecurityConfigValidator validator = new SecurityConfigValidator(this.getSecurityManager());
        try {
            config.setName("default2");
            validator.validateAddAuthProvider(config);
            Assert.fail((String)"user group service not found should fail");
        }
        catch (SecurityConfigException ex) {
            Assert.assertEquals((Object)"USERGROUP_SERVICE_NOT_FOUND", (Object)ex.getId());
            Assert.assertEquals((Object)"default2", (Object)ex.getArgs()[0]);
        }
        try {
            config.setName("other");
            validator.validateAddAuthProvider(config);
            Assert.fail((String)"user group service not found should fail");
        }
        catch (SecurityConfigException ex) {
            Assert.assertEquals((Object)"USERGROUP_SERVICE_NOT_FOUND", (Object)ex.getId());
            Assert.assertEquals((Object)"default2", (Object)ex.getArgs()[0]);
        }
        try {
            config.setName("");
            validator.validateRemoveAuthProvider(config);
            Assert.fail((String)"no name should fail");
        }
        catch (SecurityConfigException ex) {
            Assert.assertEquals((Object)"NAME_REQUIRED", (Object)ex.getId());
            Assert.assertEquals((long)0L, (long)ex.getArgs().length);
        }
        try {
            config.setName(GeoServerAuthenticationProvider.DEFAULT_NAME);
            validator.validateRemoveAuthProvider(config);
            Assert.fail((String)"active auth provieder should fail");
        }
        catch (SecurityConfigException ex) {
            Assert.assertEquals((Object)"AUTH_PROVIDER_ACTIVE", (Object)ex.getId());
            Assert.assertEquals((Object)GeoServerAuthenticationProvider.DEFAULT_NAME, (Object)ex.getArgs()[0]);
        }
    }

    @Test
    public void testUserGroupConfig() throws IOException {
        SecurityUserGroupServiceConfig config = this.createUGConfig(XMLUserGroupService.DEFAULT_NAME, MemoryUserGroupService.class, this.getPlainTextPasswordEncoder().getName(), "default");
        SecurityConfigValidator validator = new SecurityConfigValidator(this.getSecurityManager());
        try {
            config.setName("default2");
            config.setPasswordEncoderName("xxx");
            validator.validateAddUserGroupService(config);
            Assert.fail((String)"invalid config password encoder should fail");
        }
        catch (SecurityConfigException ex) {
            Assert.assertEquals((Object)"INVALID_CONFIG_PASSWORD_ENCODER", (Object)ex.getId());
            Assert.assertEquals((Object)"xxx", (Object)ex.getArgs()[0]);
        }
        if (!this.getSecurityManager().isStrongEncryptionAvailable()) {
            config.setPasswordEncoderName(this.getStrongPBEPasswordEncoder().getName());
            try {
                validator.validateAddUserGroupService(config);
                Assert.fail((String)"invalid strong password encoder should fail");
            }
            catch (SecurityConfigException ex) {
                Assert.assertEquals((Object)"INVALID_CONFIG_PASSWORD_ENCODER", (Object)ex.getId());
            }
        }
        try {
            config.setName("other");
            config.setPasswordEncoderName("xxx");
            validator.validateAddUserGroupService(config);
            Assert.fail((String)"invalid config password encoder should fail");
        }
        catch (SecurityConfigException ex) {
            Assert.assertEquals((Object)"INVALID_CONFIG_PASSWORD_ENCODER", (Object)ex.getId());
            Assert.assertEquals((Object)"xxx", (Object)ex.getArgs()[0]);
        }
        try {
            config.setName("default2");
            config.setPasswordEncoderName("");
            validator.validateAddUserGroupService(config);
            Assert.fail((String)"no password encoder should fail");
        }
        catch (SecurityConfigException ex) {
            Assert.assertEquals((Object)"PASSWD_ENCODER_REQUIRED", (Object)ex.getId());
            Assert.assertEquals((Object)"default2", (Object)ex.getArgs()[0]);
        }
        try {
            config.setName("default3");
            config.setPasswordEncoderName(null);
            validator.validateAddUserGroupService(config);
            Assert.fail((String)"no password encoder should fail");
        }
        catch (SecurityConfigException ex) {
            Assert.assertEquals((Object)"PASSWD_ENCODER_REQUIRED", (Object)ex.getId());
            Assert.assertEquals((Object)"default3", (Object)ex.getArgs()[0]);
        }
        config.setPasswordEncoderName(this.getPlainTextPasswordEncoder().getName());
        try {
            config.setName("default2");
            config.setPasswordPolicyName("default2");
            validator.validateAddUserGroupService(config);
            Assert.fail((String)"unknown password policy should fail");
        }
        catch (SecurityConfigException ex) {
            Assert.assertEquals((Object)"PASSWD_POLICY_NOT_FOUND", (Object)ex.getId());
            Assert.assertEquals((Object)"default2", (Object)ex.getArgs()[0]);
        }
        try {
            config.setName("default3");
            config.setPasswordPolicyName("default2");
            validator.validateAddUserGroupService(config);
            Assert.fail((String)"unkonwn password policy encoder should fail");
        }
        catch (SecurityConfigException ex) {
            Assert.assertEquals((Object)"PASSWD_POLICY_NOT_FOUND", (Object)ex.getId());
            Assert.assertEquals((Object)"default2", (Object)ex.getArgs()[0]);
        }
        try {
            config.setName("default2");
            config.setPasswordPolicyName("");
            validator.validateAddUserGroupService(config);
            Assert.fail((String)"no password policy should fail");
        }
        catch (SecurityConfigException ex) {
            Assert.assertEquals((Object)"PASSWD_POLICY_REQUIRED", (Object)ex.getId());
            Assert.assertEquals((Object)"default2", (Object)ex.getArgs()[0]);
        }
        try {
            config.setName("default3");
            config.setPasswordPolicyName(null);
            validator.validateAddUserGroupService(config);
            Assert.fail((String)"invalidate password policy should fail");
        }
        catch (SecurityConfigException ex) {
            Assert.assertEquals((Object)"PASSWD_POLICY_REQUIRED", (Object)ex.getId());
            Assert.assertEquals((Object)"default3", (Object)ex.getArgs()[0]);
        }
        try {
            config.setName(null);
            validator.validateRemoveUserGroupService(config);
            Assert.fail((String)"no name should fail");
            this.getSecurityManager().removeUserGroupService(config);
        }
        catch (SecurityConfigException ex) {
            Assert.assertEquals((Object)"NAME_REQUIRED", (Object)ex.getId());
            Assert.assertEquals((long)0L, (long)ex.getArgs().length);
        }
        try {
            config.setName(XMLUserGroupService.DEFAULT_NAME);
            validator.validateRemoveUserGroupService(config);
            Assert.fail((String)"active user group service should fail");
        }
        catch (SecurityConfigException ex) {
            Assert.assertEquals((Object)"USERGROUP_SERVICE_ACTIVE", (Object)ex.getId());
            Assert.assertEquals((Object)XMLUserGroupService.DEFAULT_NAME, (Object)ex.getArgs()[0]);
            Assert.assertEquals((Object)GeoServerAuthenticationProvider.DEFAULT_NAME, (Object)ex.getArgs()[1]);
        }
    }
}

