/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.security.password;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import org.apache.commons.io.IOUtils;
import org.geoserver.security.GeoServerSecurityTestSupport;
import org.geoserver.security.config.SecurityNamedServiceConfig;
import org.geoserver.security.password.URLMasterPasswordProvider;
import org.geoserver.security.password.URLMasterPasswordProviderConfig;
import org.geoserver.test.SystemTest;
import org.geotools.util.URLs;
import org.junit.Assert;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={SystemTest.class})
public class URLMasterPasswordProviderTest
extends GeoServerSecurityTestSupport {
    @Test
    public void testEncryption() throws Exception {
        File tmp = File.createTempFile("passwd", "tmp", new File("target"));
        tmp = tmp.getCanonicalFile();
        URLMasterPasswordProviderConfig config = new URLMasterPasswordProviderConfig();
        config.setName("test");
        config.setReadOnly(false);
        config.setLoginEnabled(true);
        config.setClassName(URLMasterPasswordProvider.class.getCanonicalName());
        config.setURL(URLs.fileToUrl((File)tmp));
        config.setEncrypting(true);
        URLMasterPasswordProvider mpp = new URLMasterPasswordProvider();
        mpp.setSecurityManager(this.getSecurityManager());
        mpp.initializeFromConfig((SecurityNamedServiceConfig)config);
        mpp.setName(config.getName());
        mpp.doSetMasterPassword("geoserver".toCharArray());
        String encoded = IOUtils.toString((InputStream)new FileInputStream(tmp), (Charset)StandardCharsets.UTF_8);
        Assert.assertNotEquals((Object)"geoserver", (Object)encoded);
        char[] passwd = mpp.doGetMasterPassword();
        Assert.assertArrayEquals((char[])"geoserver".toCharArray(), (char[])passwd);
    }
}

