/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.security.password;

import org.geoserver.security.password.AbstractGeoserverPasswordEncoder;
import org.geoserver.security.password.PasswordEncodingType;
import org.springframework.security.crypto.factory.PasswordEncoderFactories;
import org.springframework.security.crypto.password.PasswordEncoder;

public class GeoserverTestPasswordEncoder
extends AbstractGeoserverPasswordEncoder {
    public String getPrefix() {
        return "plain4711";
    }

    protected PasswordEncoder createStringEncoder() {
        return PasswordEncoderFactories.createDelegatingPasswordEncoder();
    }

    protected AbstractGeoserverPasswordEncoder.CharArrayPasswordEncoder createCharEncoder() {
        return new AbstractGeoserverPasswordEncoder.CharArrayPasswordEncoder(){

            public boolean isPasswordValid(String encPass, char[] rawPass, Object salt) {
                return encPass.equals(String.valueOf(rawPass));
            }

            public String encodePassword(char[] rawPass, Object salt) {
                return String.valueOf(rawPass);
            }
        };
    }

    public PasswordEncodingType getEncodingType() {
        return PasswordEncodingType.PLAIN;
    }

    public String encode(CharSequence rawPassword) {
        return PasswordEncoderFactories.createDelegatingPasswordEncoder().encode(rawPassword);
    }
}

