/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.security.impl;

import java.util.Collections;
import java.util.Properties;
import org.geoserver.security.impl.AbstractAccesRuleDAOConcurrencyTest;
import org.geoserver.security.impl.ServiceAccessRule;
import org.geoserver.security.impl.ServiceAccessRuleDAO;
import org.junit.Assert;

public class ServiceAccessRuleDAOTest
extends AbstractAccesRuleDAOConcurrencyTest<ServiceAccessRuleDAO> {
    @Override
    protected ServiceAccessRuleDAO buildDAO() throws Exception {
        Properties props = new Properties();
        props.put("*.*", "*");
        return new MemoryServiceAccessRuleDAO(props);
    }

    @Override
    protected Void manipulate(int c) {
        String service = "ows" + c;
        String method = "operation" + c;
        String customRole = "R_TEST" + c;
        ((ServiceAccessRuleDAO)this.dao).getRules();
        ServiceAccessRule rule = new ServiceAccessRule(service, method, new String[]{customRole});
        ((ServiceAccessRuleDAO)this.dao).addRule((Comparable)rule);
        Assert.assertEquals(Collections.singleton(rule), (Object)((ServiceAccessRuleDAO)this.dao).getRulesAssociatedWithRole(customRole));
        ((ServiceAccessRuleDAO)this.dao).getRules();
        ((ServiceAccessRuleDAO)this.dao).removeRule((Comparable)rule);
        return null;
    }

    static class MemoryServiceAccessRuleDAO
    extends ServiceAccessRuleDAO {
        public MemoryServiceAccessRuleDAO(Properties props) {
            super(null);
            this.loadRules(props);
        }

        protected void checkPropertyFile(boolean force) {
            this.lastModified = Long.MAX_VALUE;
        }
    }
}

