/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.security.impl;

import org.geoserver.security.AccessMode;
import org.geoserver.security.impl.SecureTreeNode;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.springframework.security.authentication.TestingAuthenticationToken;
import org.springframework.security.core.Authentication;

public class SecureTreeNodeTest {
    private TestingAuthenticationToken anonymous;

    @Before
    public void setUp() throws Exception {
        this.anonymous = new TestingAuthenticationToken((Object)"anonymous", null);
    }

    @Test
    public void testEmptyRoot() {
        SecureTreeNode root = new SecureTreeNode();
        Assert.assertNull((Object)root.getChild("NotThere"));
        Assert.assertEquals((Object)SecureTreeNode.EVERYBODY, (Object)root.getAuthorizedRoles(AccessMode.READ));
        Assert.assertEquals((Object)SecureTreeNode.EVERYBODY, (Object)root.getAuthorizedRoles(AccessMode.WRITE));
        SecureTreeNode node = root.getDeepestNode(new String[]{"a", "b"});
        Assert.assertSame((Object)root, (Object)node);
        Assert.assertTrue((boolean)root.canAccess((Authentication)this.anonymous, AccessMode.WRITE));
        Assert.assertTrue((boolean)root.canAccess((Authentication)this.anonymous, AccessMode.READ));
        Assert.assertTrue((boolean)root.canAccess(null, AccessMode.WRITE));
        Assert.assertTrue((boolean)root.canAccess(null, AccessMode.READ));
    }
}

