/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.security.impl;

import org.geoserver.catalog.Catalog;
import org.geoserver.catalog.LayerGroupInfo;
import org.geoserver.catalog.ResourceInfo;
import org.geoserver.catalog.WorkspaceInfo;
import org.geoserver.data.test.SystemTestData;
import org.geoserver.security.AccessMode;
import org.geoserver.security.SecuredResourceNameChangeListener;
import org.geoserver.security.impl.DataAccessRule;
import org.geoserver.security.impl.DataAccessRuleDAO;
import org.geoserver.test.GeoServerSystemTestSupport;
import org.junit.Assert;
import org.junit.Test;

public class RuleSyncedNameChangeTest
extends GeoServerSystemTestSupport {
    protected SecuredResourceNameChangeListener securedResourceNameChangeListener;
    static DataAccessRuleDAO dao;
    static Catalog catalog;

    protected void onSetUp(SystemTestData testData) throws Exception {
        super.onSetUp(testData);
        catalog = this.getCatalog();
        this.addLayerGroup();
        this.setRules();
        dao = DataAccessRuleDAO.get();
        this.securedResourceNameChangeListener = new SecuredResourceNameChangeListener(catalog, dao);
    }

    @Test
    public void testChangeWorkspaceNameWithDataSecurityRule() throws Exception {
        String oldWorkspaceName = "cgf";
        String newWorkspaceName = "cgf_123";
        WorkspaceInfo wp1 = catalog.getWorkspaceByName(oldWorkspaceName);
        wp1.setName(newWorkspaceName);
        catalog.save(wp1);
        int countOfRulesUpdated = 0;
        for (DataAccessRule rule : dao.getRules()) {
            if (!rule.getRoot().equalsIgnoreCase(newWorkspaceName)) continue;
            ++countOfRulesUpdated;
        }
        Assert.assertEquals((long)3L, (long)countOfRulesUpdated);
    }

    @Test
    public void testChangLayerNameWithDataSecurityRule() throws Exception {
        String oldLayerName = "Lines";
        String newLayerName = "Lines_123";
        ResourceInfo resourceInfo = catalog.getLayerByName(oldLayerName).getResource();
        resourceInfo.setName(newLayerName);
        catalog.save(resourceInfo);
        String workspaceName = resourceInfo.getStore().getWorkspace().getName();
        int countOfRulesUpdated = 0;
        for (DataAccessRule rule : dao.getRules()) {
            if (!rule.getRoot().equalsIgnoreCase(workspaceName) || !rule.getLayer().equalsIgnoreCase(newLayerName)) continue;
            ++countOfRulesUpdated;
        }
        Assert.assertEquals((long)1L, (long)countOfRulesUpdated);
    }

    @Test
    public void testChangLayerGroupNameWithDataSecurityRule() throws Exception {
        String newLayerName = "lyr_group_modified";
        LayerGroupInfo layerGrpInfo = catalog.getLayerGroupByName("cgf:lyr_group");
        layerGrpInfo.setName(newLayerName);
        catalog.save(layerGrpInfo);
        String workspaceName = layerGrpInfo.getWorkspace().getName();
        int countOfRulesUpdated = 0;
        for (DataAccessRule rule : dao.getRules()) {
            if (!rule.getRoot().equalsIgnoreCase(workspaceName) || !rule.getLayer().equalsIgnoreCase(newLayerName)) continue;
            ++countOfRulesUpdated;
        }
        Assert.assertEquals((long)1L, (long)countOfRulesUpdated);
    }

    private void setRules() throws Exception {
        this.addLayerAccessRule("cgf", "*", AccessMode.WRITE, new String[]{"*"});
        this.addLayerAccessRule("cgf", "Lines", AccessMode.WRITE, new String[]{"*"});
        this.addLayerAccessRule("wp2", "Lines", AccessMode.WRITE, new String[]{"*"});
        this.addLayerAccessRule("cgf", "lyr_group", AccessMode.WRITE, new String[]{"*"});
    }

    private void addLayerGroup() throws Exception {
        LayerGroupInfo lg = catalog.getFactory().createLayerGroup();
        lg.setName("lyr_group");
        lg.setWorkspace(catalog.getWorkspaceByName("cgf"));
        lg.getLayers().add(catalog.getLayerByName("Lines"));
        lg.getLayers().add(catalog.getLayerByName("MLines"));
        catalog.add(lg);
    }
}

