/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.security.impl;

import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Properties;
import org.geoserver.platform.resource.Files;
import org.geoserver.security.PropertyFileWatcher;
import org.geoserver.security.impl.GeoServerUserDao;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.springframework.dao.DataAccessResourceFailureException;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.authority.SimpleGrantedAuthority;
import org.springframework.security.core.userdetails.User;
import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.security.core.userdetails.UsernameNotFoundException;

public class GeoServerUserDaoTest {
    Properties props;
    TestableUserDao dao;

    @Before
    public void setUp() throws Exception {
        this.props = new Properties();
        this.props.put("admin", "gs,ROLE_ADMINISTRATOR");
        this.props.put("wfs", "webFeatureService,ROLE_WFS_READ,ROLE_WFS_WRITE");
        this.props.put("disabledUser", "nah,ROLE_TEST,disabled");
        this.dao = new TestableUserDao(this.props);
    }

    @Test
    public void testGetUsers() throws Exception {
        List users = this.dao.getUsers();
        Assert.assertEquals((long)3L, (long)users.size());
    }

    @Test
    public void testLoadUser() throws Exception {
        UserDetails admin = this.dao.loadUserByUsername("admin");
        Assert.assertEquals((Object)"admin", (Object)admin.getUsername());
        Assert.assertEquals((Object)"gs", (Object)admin.getPassword());
        Assert.assertEquals((long)1L, (long)admin.getAuthorities().size());
        Assert.assertEquals((Object)"ROLE_ADMINISTRATOR", (Object)((GrantedAuthority)admin.getAuthorities().iterator().next()).getAuthority());
    }

    @Test
    public void testMissingUser() throws Exception {
        try {
            this.dao.loadUserByUsername("notThere");
            Assert.fail((String)"This user should not be there");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Test
    public void testSetUser() throws Exception {
        this.dao.setUser(new User("wfs", "pwd", true, true, true, true, Arrays.asList(new SimpleGrantedAuthority("ROLE_WFS_ALL"), new SimpleGrantedAuthority("ROLE_WMS_ALL"))));
        UserDetails user = this.dao.loadUserByUsername("wfs");
        Assert.assertEquals((Object)"wfs", (Object)user.getUsername());
        Assert.assertEquals((Object)"pwd", (Object)user.getPassword());
        Assert.assertEquals((long)2L, (long)user.getAuthorities().size());
        HashSet<String> authorities = new HashSet<String>();
        for (GrantedAuthority ga : user.getAuthorities()) {
            authorities.add(ga.getAuthority());
        }
        Assert.assertTrue((boolean)authorities.contains("ROLE_WFS_ALL"));
        Assert.assertTrue((boolean)authorities.contains("ROLE_WMS_ALL"));
    }

    @Test
    public void testSetMissingUser() throws Exception {
        try {
            this.dao.setUser(new User("notther", "pwd", true, true, true, true, Arrays.asList(new SimpleGrantedAuthority("ROLE_WFS_ALL"))));
            Assert.fail((String)"The user is not there, setUser should fail");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void testAddUser() throws Exception {
        this.dao.putUser(new User("newuser", "pwd", true, true, true, true, Arrays.asList(new SimpleGrantedAuthority("ROLE_WFS_ALL"))));
        Assert.assertNotNull((Object)this.dao.loadUserByUsername("newuser"));
    }

    @Test
    public void addExistingUser() throws Exception {
        try {
            this.dao.putUser(new User("admin", "pwd", true, true, true, true, Arrays.asList(new SimpleGrantedAuthority("ROLE_WFS_ALL"))));
            Assert.fail((String)"The user is already there, addUser should fail");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void testRemoveUser() throws Exception {
        Assert.assertFalse((boolean)this.dao.removeUser("notthere"));
        Assert.assertTrue((boolean)this.dao.removeUser("wfs"));
        try {
            this.dao.loadUserByUsername("wfs");
            Assert.fail((String)"The user is not there, loadUserByName should fail");
        }
        catch (UsernameNotFoundException usernameNotFoundException) {
            // empty catch block
        }
    }

    @Test
    public void testStoreReload() throws Exception {
        File temp = File.createTempFile("sectest", "", new File("target"));
        temp.delete();
        temp.mkdir();
        File propFile = new File(temp, "users.properties");
        try {
            this.dao.userDefinitionsFile = new PropertyFileWatcher(Files.asResource((File)propFile));
            this.dao.storeUsers();
            this.dao.userMap.clear();
            this.dao.loadUserMap();
        }
        finally {
            temp.delete();
        }
        Assert.assertEquals((long)3L, (long)this.dao.getUsers().size());
        this.testLoadUser();
    }

    static class TestableUserDao
    extends GeoServerUserDao {
        public TestableUserDao(Properties p) throws IOException {
            this.userMap = this.loadUsersFromProperties(p);
        }

        void checkUserMap() throws DataAccessResourceFailureException {
        }

        void loadUserMap() {
            super.checkUserMap();
        }
    }
}

