/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.security.impl;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.Properties;
import org.easymock.EasyMock;
import org.geoserver.catalog.Catalog;
import org.geoserver.catalog.impl.LayerInfoImpl;
import org.geoserver.catalog.impl.WorkspaceInfoImpl;
import org.geoserver.security.AccessMode;
import org.geoserver.security.impl.DataAccessRule;
import org.geoserver.security.impl.DataAccessRuleDAO;
import org.geoserver.security.impl.MemoryDataAccessRuleDAO;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class DataAccessRuleDAOTest {
    DataAccessRuleDAO dao;
    Properties props;

    @Before
    public void setUp() throws Exception {
        Catalog catalog = (Catalog)EasyMock.createNiceMock(Catalog.class);
        EasyMock.expect((Object)catalog.getWorkspaceByName((String)EasyMock.anyObject())).andReturn((Object)new WorkspaceInfoImpl()).anyTimes();
        EasyMock.expect((Object)catalog.getLayerByName((String)EasyMock.anyObject())).andReturn((Object)new LayerInfoImpl()).anyTimes();
        EasyMock.replay((Object[])new Object[]{catalog});
        this.props = new Properties();
        this.props.put("mode", "CHALLENGE");
        this.props.put("topp.states.w", "ROLE_TSW");
        this.props.put("topp.*.w", "ROLE_TW");
        this.props.put("*.*.r", "*");
        this.props.put("group.r", "ROLE_GROUP");
        this.dao = new MemoryDataAccessRuleDAO(catalog, this.props);
    }

    @Test
    public void testRulesForRole() {
        Assert.assertEquals((long)0L, (long)this.dao.getRulesAssociatedWithRole("CHALLENGE").size());
        Assert.assertEquals((long)0L, (long)this.dao.getRulesAssociatedWithRole("NOTEXISTEND").size());
        Assert.assertEquals((long)1L, (long)this.dao.getRulesAssociatedWithRole("ROLE_TSW").size());
        Assert.assertEquals((long)1L, (long)this.dao.getRulesAssociatedWithRole("ROLE_TW").size());
        Assert.assertEquals((long)1L, (long)this.dao.getRulesAssociatedWithRole("ROLE_GROUP").size());
    }

    @Test
    public void testParseGlobalLayerGroupRule() {
        DataAccessRule r = this.dao.parseDataAccessRule("group.r", "ROLE_GROUP_OWNER");
        Assert.assertEquals((Object)r.getRoot(), (Object)"group");
        Assert.assertNull((Object)r.getLayer());
        Assert.assertTrue((boolean)r.isGlobalGroupRule());
        Assert.assertEquals((Object)AccessMode.READ, (Object)r.getAccessMode());
    }

    @Test
    public void testParse() {
        Assert.assertEquals((long)4L, (long)this.dao.getRules().size());
        DataAccessRule rule = (DataAccessRule)this.dao.getRules().get(0);
        Assert.assertEquals((Object)"*.*.r", (Object)rule.getKey());
        Assert.assertEquals((long)1L, (long)rule.getRoles().size());
        Assert.assertEquals((Object)"*", rule.getRoles().iterator().next());
    }

    @Test
    public void testAdd() {
        Assert.assertEquals((long)4L, (long)this.dao.getRules().size());
        DataAccessRule newRule = this.dao.parseDataAccessRule("*.*.w", "ROLE_GENERIC_W");
        Assert.assertTrue((boolean)this.dao.addRule((Comparable)newRule));
        Assert.assertEquals((long)5L, (long)this.dao.getRules().size());
        Assert.assertEquals((Object)newRule, this.dao.getRules().get(1));
        Assert.assertFalse((boolean)this.dao.addRule((Comparable)newRule));
    }

    @Test
    public void testRemove() {
        Assert.assertEquals((long)4L, (long)this.dao.getRules().size());
        DataAccessRule newRule = this.dao.parseDataAccessRule("*.*.w", "ROLE_GENERIC_W");
        Assert.assertFalse((boolean)this.dao.removeRule((Comparable)newRule));
        DataAccessRule first = (DataAccessRule)this.dao.getRules().get(0);
        Assert.assertTrue((boolean)this.dao.removeRule((Comparable)first));
        Assert.assertFalse((boolean)this.dao.removeRule((Comparable)first));
        Assert.assertEquals((long)3L, (long)this.dao.getRules().size());
    }

    @Test
    public void testStore() {
        Properties newProps = this.dao.toProperties();
        Assert.assertEquals((long)newProps.size(), (long)this.props.size());
        for (Object key : newProps.keySet()) {
            Object newValue = newProps.get(key);
            Object oldValue = newProps.get(key);
            Assert.assertEquals((Object)newValue, (Object)oldValue);
        }
    }

    @Test
    public void testParsePlain() {
        DataAccessRule rule = this.dao.parseDataAccessRule("a.b.r", "ROLE_WHO_CARES");
        Assert.assertEquals((Object)"a", (Object)rule.getRoot());
        Assert.assertEquals((Object)"b", (Object)rule.getLayer());
        Assert.assertFalse((boolean)rule.isGlobalGroupRule());
        Assert.assertEquals((Object)AccessMode.READ, (Object)rule.getAccessMode());
    }

    @Test
    public void testParseSpaces() {
        DataAccessRule rule = this.dao.parseDataAccessRule(" a  . b . r ", "ROLE_WHO_CARES");
        Assert.assertEquals((Object)"a", (Object)rule.getRoot());
        Assert.assertEquals((Object)"b", (Object)rule.getLayer());
        Assert.assertFalse((boolean)rule.isGlobalGroupRule());
        Assert.assertEquals((Object)AccessMode.READ, (Object)rule.getAccessMode());
    }

    @Test
    public void testParseEscapedDots() {
        DataAccessRule rule = this.dao.parseDataAccessRule("w. a\\.b . r ", "ROLE_WHO_CARES");
        Assert.assertEquals((Object)"w", (Object)rule.getRoot());
        Assert.assertEquals((Object)"a.b", (Object)rule.getLayer());
        Assert.assertFalse((boolean)rule.isGlobalGroupRule());
        Assert.assertEquals((Object)AccessMode.READ, (Object)rule.getAccessMode());
    }

    @Test
    public void testStoreEscapedDots() throws Exception {
        this.dao.clear();
        this.dao.addRule((Comparable)new DataAccessRule("it.geosolutions", "layer.dots", AccessMode.READ, Collections.singleton("ROLE_ABC")));
        Properties ps = this.dao.toProperties();
        Assert.assertEquals((long)2L, (long)ps.size());
        Assert.assertEquals((Object)"ROLE_ABC", (Object)ps.getProperty("it\\.geosolutions.layer\\.dots.r"));
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        ps.store(bos, null);
    }

    @Test
    public void testFileSystemSandbox() throws IOException {
        File sandbox = new File("./target/sandbox").getCanonicalFile();
        String path = sandbox.getAbsolutePath();
        this.dao.setFilesystemSandbox(path);
        this.dao.reload();
        Assert.assertEquals((Object)path, (Object)this.dao.getFilesystemSandbox());
        this.dao.setFilesystemSandbox(null);
        this.dao.reload();
        Assert.assertNull((Object)this.dao.getFilesystemSandbox());
    }
}

