/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.security.impl;

import org.geoserver.data.test.SystemTestData;
import org.geoserver.security.AbstractSecurityServiceTest;
import org.geoserver.security.GeoServerUserGroupService;
import org.geoserver.security.GeoServerUserGroupStore;
import org.geoserver.security.config.SecurityNamedServiceConfig;
import org.geoserver.security.config.SecurityUserGroupServiceConfig;
import org.geoserver.security.impl.GeoServerUser;
import org.geoserver.security.impl.GeoServerUserGroup;
import org.geoserver.security.impl.Util;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public abstract class AbstractUserGroupServiceTest
extends AbstractSecurityServiceTest {
    protected GeoServerUserGroupService service;
    protected GeoServerUserGroupStore store;

    protected void onSetUp(SystemTestData testData) throws Exception {
        super.onSetUp(testData);
        this.service = this.createUserGroupService("test");
    }

    @Before
    public void setServiceAndStore() throws Exception {
        this.service = this.getSecurityManager().loadUserGroupService("test");
        this.store = this.createStore(this.service);
    }

    protected abstract SecurityUserGroupServiceConfig createConfigObject(String var1);

    @Test
    public void testInsert() throws Exception {
        this.checkEmpty(this.service);
        this.checkEmpty((GeoServerUserGroupService)this.store);
        this.insertValues(this.store);
        if (!this.isJDBCTest()) {
            this.checkEmpty(this.service);
        }
        this.checkValuesInserted((GeoServerUserGroupService)this.store);
        this.store.load();
        this.checkEmpty((GeoServerUserGroupService)this.store);
        this.checkEmpty(this.service);
        this.insertValues(this.store);
        this.store.store();
        this.checkValuesInserted((GeoServerUserGroupService)this.store);
        this.checkValuesInserted(this.service);
    }

    @Test
    public void testModify() throws Exception {
        this.checkEmpty(this.service);
        this.checkEmpty((GeoServerUserGroupService)this.store);
        this.insertValues(this.store);
        this.store.store();
        this.checkValuesInserted((GeoServerUserGroupService)this.store);
        this.checkValuesInserted(this.service);
        this.modifyValues(this.store);
        if (!this.isJDBCTest()) {
            this.checkValuesInserted(this.service);
        }
        this.checkValuesModified((GeoServerUserGroupService)this.store);
        this.store.load();
        this.checkValuesInserted((GeoServerUserGroupService)this.store);
        this.checkValuesInserted(this.service);
        this.modifyValues(this.store);
        this.store.store();
        this.checkValuesModified((GeoServerUserGroupService)this.store);
        this.checkValuesModified(this.service);
    }

    @Test
    public void testRemove() throws Exception {
        this.checkEmpty(this.service);
        this.checkEmpty((GeoServerUserGroupService)this.store);
        this.insertValues(this.store);
        this.store.store();
        this.checkValuesInserted((GeoServerUserGroupService)this.store);
        this.checkValuesInserted(this.service);
        this.removeValues(this.store);
        if (!this.isJDBCTest()) {
            this.checkValuesInserted(this.service);
        }
        this.checkValuesRemoved((GeoServerUserGroupService)this.store);
        this.store.load();
        this.checkValuesInserted((GeoServerUserGroupService)this.store);
        this.checkValuesInserted(this.service);
        this.removeValues(this.store);
        this.store.store();
        this.checkValuesRemoved((GeoServerUserGroupService)this.store);
        this.checkValuesRemoved(this.service);
    }

    @Test
    public void testIsModified() throws Exception {
        Assert.assertFalse((boolean)this.store.isModified());
        this.insertValues(this.store);
        Assert.assertTrue((boolean)this.store.isModified());
        this.store.load();
        Assert.assertFalse((boolean)this.store.isModified());
        this.insertValues(this.store);
        this.store.store();
        Assert.assertFalse((boolean)this.store.isModified());
        GeoServerUser user = this.store.createUserObject("uuuu", "", true);
        GeoServerUserGroup group = this.store.createGroupObject("gggg", true);
        Assert.assertFalse((boolean)this.store.isModified());
        this.store.addUser(user);
        Assert.assertTrue((boolean)this.store.isModified());
        this.store.store();
        Assert.assertFalse((boolean)this.store.isModified());
        this.store.addGroup(group);
        Assert.assertTrue((boolean)this.store.isModified());
        this.store.store();
        Assert.assertFalse((boolean)this.store.isModified());
        this.store.updateUser(user);
        Assert.assertTrue((boolean)this.store.isModified());
        this.store.load();
        Assert.assertFalse((boolean)this.store.isModified());
        this.store.updateGroup(group);
        Assert.assertTrue((boolean)this.store.isModified());
        this.store.load();
        Assert.assertFalse((boolean)this.store.isModified());
        this.store.removeUser(user);
        Assert.assertTrue((boolean)this.store.isModified());
        this.store.load();
        Assert.assertFalse((boolean)this.store.isModified());
        this.store.removeGroup(group);
        Assert.assertTrue((boolean)this.store.isModified());
        this.store.load();
        Assert.assertFalse((boolean)this.store.isModified());
        this.store.associateUserToGroup(user, group);
        Assert.assertTrue((boolean)this.store.isModified());
        this.store.store();
        Assert.assertFalse((boolean)this.store.isModified());
        this.store.disAssociateUserFromGroup(user, group);
        Assert.assertTrue((boolean)this.store.isModified());
        this.store.load();
        Assert.assertFalse((boolean)this.store.isModified());
        this.store.clear();
        Assert.assertTrue((boolean)this.store.isModified());
        this.store.load();
    }

    @Test
    public void testEmptyPassword() throws Exception {
        this.checkEmpty(this.service);
        this.checkEmpty((GeoServerUserGroupService)this.store);
        GeoServerUser user = this.store.createUserObject("userNoPasswd", null, true);
        this.store.addUser(user);
        this.store.store();
        Assert.assertEquals((long)1L, (long)this.service.getUserCount());
        user = this.service.getUserByUsername("userNoPasswd");
        Assert.assertNull((Object)user.getPassword());
        user = (GeoServerUser)this.service.loadUserByUsername("userNoPasswd");
        Assert.assertNull((Object)user.getPassword());
    }

    @Test
    public void testEraseCredentials() throws Exception {
        GeoServerUser user = this.store.createUserObject("user", "foobar", true);
        this.store.addUser(user);
        this.store.store();
        user = this.store.getUserByUsername("user");
        Assert.assertNotNull((Object)user.getPassword());
        user.eraseCredentials();
        user = this.store.getUserByUsername("user");
        Assert.assertNotNull((Object)user.getPassword());
    }

    @Test
    public void testPasswordRecoding() throws Exception {
        SecurityUserGroupServiceConfig config = this.getSecurityManager().loadUserGroupServiceConfig(this.service.getName());
        config.setPasswordEncoderName(this.getPlainTextPasswordEncoder().getName());
        this.getSecurityManager().saveUserGroupService(config);
        this.service.initializeFromConfig((SecurityNamedServiceConfig)config);
        this.store = this.service.createStore();
        this.store.addUser(this.store.createUserObject("u1", "p1", true));
        this.store.addUser(this.store.createUserObject("u2", "p2", true));
        this.store.store();
        Util.recodePasswords((GeoServerUserGroupStore)this.service.createStore());
        Assert.assertTrue((boolean)this.service.loadUserByUsername("u1").getPassword().startsWith(this.getPlainTextPasswordEncoder().getPrefix()));
        Assert.assertTrue((boolean)this.service.loadUserByUsername("u2").getPassword().startsWith(this.getPlainTextPasswordEncoder().getPrefix()));
        config.setPasswordEncoderName(this.getPBEPasswordEncoder().getName());
        this.getSecurityManager().saveUserGroupService(config);
        this.service.initializeFromConfig((SecurityNamedServiceConfig)config);
        Util.recodePasswords((GeoServerUserGroupStore)this.service.createStore());
        Assert.assertTrue((boolean)this.service.loadUserByUsername("u1").getPassword().startsWith(this.getPBEPasswordEncoder().getPrefix()));
        Assert.assertTrue((boolean)this.service.loadUserByUsername("u2").getPassword().startsWith(this.getPBEPasswordEncoder().getPrefix()));
        config.setPasswordEncoderName(this.getDigestPasswordEncoder().getName());
        this.getSecurityManager().saveUserGroupService(config);
        this.service.initializeFromConfig((SecurityNamedServiceConfig)config);
        Util.recodePasswords((GeoServerUserGroupStore)this.service.createStore());
        Assert.assertTrue((boolean)this.service.loadUserByUsername("u1").getPassword().startsWith(this.getDigestPasswordEncoder().getPrefix()));
        Assert.assertTrue((boolean)this.service.loadUserByUsername("u2").getPassword().startsWith(this.getDigestPasswordEncoder().getPrefix()));
        config.setPasswordEncoderName(this.getPBEPasswordEncoder().getName());
        this.getSecurityManager().saveUserGroupService(config);
        this.service.initializeFromConfig((SecurityNamedServiceConfig)config);
        Util.recodePasswords((GeoServerUserGroupStore)this.service.createStore());
        Assert.assertTrue((boolean)this.service.loadUserByUsername("u1").getPassword().startsWith(this.getDigestPasswordEncoder().getPrefix()));
        Assert.assertTrue((boolean)this.service.loadUserByUsername("u2").getPassword().startsWith(this.getDigestPasswordEncoder().getPrefix()));
        this.store = this.service.createStore();
        this.store.addUser(this.store.createUserObject("u3", "p3", true));
        this.store.store();
        Assert.assertTrue((boolean)this.service.loadUserByUsername("u1").getPassword().startsWith(this.getDigestPasswordEncoder().getPrefix()));
        Assert.assertTrue((boolean)this.service.loadUserByUsername("u2").getPassword().startsWith(this.getDigestPasswordEncoder().getPrefix()));
        Assert.assertTrue((boolean)this.service.loadUserByUsername("u3").getPassword().startsWith(this.getPBEPasswordEncoder().getPrefix()));
        config.setPasswordEncoderName(this.getEmptyEncoder().getName());
        this.getSecurityManager().saveUserGroupService(config);
        this.service.initializeFromConfig((SecurityNamedServiceConfig)config);
        Util.recodePasswords((GeoServerUserGroupStore)this.service.createStore());
        Assert.assertTrue((boolean)this.service.loadUserByUsername("u1").getPassword().startsWith(this.getDigestPasswordEncoder().getPrefix()));
        Assert.assertTrue((boolean)this.service.loadUserByUsername("u2").getPassword().startsWith(this.getDigestPasswordEncoder().getPrefix()));
        Assert.assertTrue((boolean)this.service.loadUserByUsername("u3").getPassword().startsWith(this.getEmptyEncoder().getPrefix()));
        config.setPasswordEncoderName(this.getPBEPasswordEncoder().getName());
        this.getSecurityManager().saveUserGroupService(config);
        this.service.initializeFromConfig((SecurityNamedServiceConfig)config);
        Util.recodePasswords((GeoServerUserGroupStore)this.service.createStore());
        Assert.assertTrue((boolean)this.service.loadUserByUsername("u1").getPassword().startsWith(this.getDigestPasswordEncoder().getPrefix()));
        Assert.assertTrue((boolean)this.service.loadUserByUsername("u2").getPassword().startsWith(this.getDigestPasswordEncoder().getPrefix()));
        Assert.assertTrue((boolean)this.service.loadUserByUsername("u3").getPassword().startsWith(this.getEmptyEncoder().getPrefix()));
    }
}

