/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.security.impl;

import java.io.IOException;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.geoserver.security.AbstractSecurityServiceTest;
import org.geoserver.security.GeoServerRoleService;
import org.geoserver.security.GeoServerRoleStore;
import org.geoserver.security.GeoServerUserGroupService;
import org.geoserver.security.GeoServerUserGroupStore;
import org.geoserver.security.impl.GeoServerRole;
import org.geoserver.security.impl.GeoServerUser;
import org.geoserver.security.impl.GeoServerUserGroup;
import org.junit.Assert;
import org.junit.Test;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.security.core.userdetails.UsernameNotFoundException;

public abstract class AbstractUserDetailsServiceTest
extends AbstractSecurityServiceTest {
    protected GeoServerRoleService roleService;
    protected GeoServerUserGroupService usergroupService;
    protected GeoServerRoleStore roleStore;
    protected GeoServerUserGroupStore usergroupStore;

    protected void setServices(String serviceName) throws Exception {
        this.roleService = this.createRoleService(serviceName);
        this.usergroupService = this.createUserGroupService(serviceName);
        this.roleStore = this.createStore(this.roleService);
        this.usergroupStore = this.createStore(this.usergroupService);
        this.getSecurityManager().setActiveRoleService(this.roleService);
    }

    @Test
    public void testConfiguration() throws Exception {
        this.setServices("config");
        Assert.assertEquals((Object)this.roleService, (Object)this.getSecurityManager().getActiveRoleService());
        Assert.assertEquals((Object)this.usergroupService.getName(), (Object)this.getSecurityManager().loadUserGroupService("config").getName());
        Assert.assertTrue((boolean)this.roleService.canCreateStore());
        Assert.assertTrue((boolean)this.usergroupService.canCreateStore());
    }

    @Test
    public void testRoleCalculation() throws Exception {
        this.setServices("rolecalulation");
        this.insertValues(this.roleStore);
        this.insertValues(this.usergroupStore);
        String username = "theUser";
        GeoServerUser theUser = null;
        boolean fail = true;
        try {
            theUser = (GeoServerUser)this.usergroupService.loadUserByUsername(username);
        }
        catch (UsernameNotFoundException ex) {
            fail = false;
        }
        if (fail) {
            Assert.fail((String)"No UsernameNotFoundException thrown");
        }
        theUser = this.usergroupStore.createUserObject(username, "", true);
        this.usergroupStore.addUser(theUser);
        HashSet<GeoServerRole> roles = new HashSet<GeoServerRole>();
        this.checkRoles(username, roles);
        GeoServerRole role = this.roleStore.createRoleObject("userrole1");
        this.roleStore.addRole(role);
        this.roleStore.associateRoleToUser(role, username);
        roles.add(role);
        this.checkRoles(username, roles);
        role = this.roleStore.createRoleObject("userrole2");
        this.roleStore.addRole(role);
        this.roleStore.associateRoleToUser(role, username);
        roles.add(role);
        this.checkRoles(username, roles);
        GeoServerUserGroup theGroup1 = this.usergroupStore.createGroupObject("theGroup1", true);
        this.usergroupStore.addGroup(theGroup1);
        this.usergroupStore.associateUserToGroup(theUser, theGroup1);
        role = this.roleStore.createRoleObject("grouprole1a");
        this.roleStore.addRole(role);
        this.roleStore.associateRoleToGroup(role, "theGroup1");
        roles.add(role);
        this.checkRoles(username, roles);
        role = this.roleStore.createRoleObject("grouprole1b");
        this.roleStore.addRole(role);
        this.roleStore.associateRoleToGroup(role, "theGroup1");
        roles.add(role);
        this.checkRoles(username, roles);
        GeoServerUserGroup theGroup2 = this.usergroupStore.createGroupObject("theGroup2", false);
        this.usergroupStore.addGroup(theGroup2);
        this.usergroupStore.associateUserToGroup(theUser, theGroup2);
        role = this.roleStore.createRoleObject("grouprole2a");
        this.roleStore.addRole(role);
        this.roleStore.associateRoleToGroup(role, "theGroup2");
        this.checkRoles(username, roles);
        theGroup2.setEnabled(true);
        this.usergroupStore.updateGroup(theGroup2);
        roles.add(role);
        this.checkRoles(username, roles);
        GeoServerRole tmp = role;
        role = this.roleStore.createRoleObject("grouprole2aa");
        this.roleStore.addRole(role);
        this.roleStore.setParentRole(tmp, role);
        roles.add(role);
        this.checkRoles(username, roles);
        tmp = role;
        role = this.roleStore.createRoleObject("grouprole2aaa");
        this.roleStore.addRole(role);
        this.roleStore.setParentRole(tmp, role);
        roles.add(role);
        this.checkRoles(username, roles);
        tmp = this.roleStore.getRoleByName("grouprole2aa");
        this.roleStore.setParentRole(tmp, null);
        roles.remove(role);
        this.checkRoles(username, roles);
        this.roleStore.removeRole(tmp);
        roles.remove(tmp);
        this.checkRoles(username, roles);
        this.usergroupStore.removeGroup(theGroup2);
        tmp = this.roleStore.getRoleByName("grouprole2a");
        roles.remove(tmp);
        this.checkRoles(username, roles);
        tmp = this.roleStore.getRoleByName("grouprole1b");
        this.roleStore.disAssociateRoleFromGroup(tmp, theGroup1.getGroupname());
        roles.remove(tmp);
        this.checkRoles(username, roles);
        tmp = this.roleStore.getRoleByName("userrole2");
        this.roleStore.disAssociateRoleFromUser(tmp, theUser.getUsername());
        roles.remove(tmp);
        this.checkRoles(username, roles);
    }

    @Test
    public void testPersonalizedRoles() throws Exception {
        this.setServices("personalizedRoles");
        this.insertValues(this.roleStore);
        this.insertValues(this.usergroupStore);
        String username = "persUser";
        GeoServerUser theUser = this.usergroupStore.createUserObject(username, "", true);
        theUser.getProperties().put("propertyA", "A");
        theUser.getProperties().put("propertyB", "B");
        theUser.getProperties().put("propertyC", "C");
        this.usergroupStore.addUser(theUser);
        GeoServerRole role = this.roleStore.createRoleObject("persrole1");
        role.getProperties().put("propertyA", "");
        role.getProperties().put("propertyX", "X");
        this.roleStore.addRole(role);
        this.roleStore.associateRoleToUser(role, username);
        role = this.roleStore.createRoleObject("persrole2");
        role.getProperties().put("propertyB", "");
        role.getProperties().put("propertyY", "Y");
        this.roleStore.addRole(role);
        this.roleStore.associateRoleToUser(role, username);
        this.syncbackends();
        UserDetails details = this.usergroupService.loadUserByUsername(username);
        Collection authColl = details.getAuthorities();
        for (GrantedAuthority auth : authColl) {
            role = (GeoServerRole)auth;
            if ("persrole1".equals(role.getAuthority())) {
                Assert.assertEquals((Object)"A", (Object)role.getProperties().get("propertyA"));
                Assert.assertEquals((Object)"X", (Object)role.getProperties().get("propertyX"));
                GeoServerRole anonymousRole = this.roleStore.getRoleByName(role.getAuthority());
                Assert.assertFalse((boolean)role.isAnonymous());
                Assert.assertTrue((boolean)anonymousRole.isAnonymous());
                Assert.assertNotSame((Object)role, (Object)anonymousRole);
                Assert.assertNotEquals((Object)role, (Object)anonymousRole);
                Assert.assertEquals((Object)theUser.getUsername(), (Object)role.getUserName());
                Assert.assertNull((Object)anonymousRole.getUserName());
                continue;
            }
            if ("persrole2".equals(role.getAuthority())) {
                Assert.assertEquals((Object)"B", (Object)role.getProperties().get("propertyB"));
                Assert.assertEquals((Object)"Y", (Object)role.getProperties().get("propertyY"));
                continue;
            }
            Assert.fail((String)("Unknown role " + role.getAuthority() + "for user " + username));
        }
    }

    protected void checkRoles(String username, Set<GeoServerRole> roles) throws IOException {
        this.syncbackends();
        UserDetails details = this.usergroupService.loadUserByUsername(username);
        Collection authColl = details.getAuthorities();
        Assert.assertEquals((long)roles.size(), (long)authColl.size());
        for (GeoServerRole role : roles) {
            Assert.assertTrue((boolean)authColl.contains(role));
        }
    }

    protected void syncbackends() throws IOException {
        this.roleStore.store();
        this.usergroupStore.store();
    }
}

