/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.security.impl;

import java.io.IOException;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.geoserver.security.impl.AbstractAccessRuleDAO;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;

public abstract class AbstractAccesRuleDAOConcurrencyTest<D extends AbstractAccessRuleDAO> {
    protected static final int DEFAULT_LOOPS = 10000;
    private static final int THREADS = 4;
    D dao;
    private ExecutorService executors;

    @Before
    public void setUp() throws Exception {
        this.dao = this.buildDAO();
        this.executors = Executors.newFixedThreadPool(4);
    }

    protected abstract D buildDAO() throws Exception;

    @After
    public void shutdown() {
        this.executors.shutdown();
    }

    @Test
    public void testConcurrentModifications() throws Exception {
        List manipulators = IntStream.range(1, this.getLoops()).mapToObj(c -> () -> this.manipulate(c)).collect(Collectors.toList());
        List futures = this.executors.invokeAll(manipulators);
        for (Future future : futures) {
            future.get();
        }
    }

    protected int getLoops() {
        return 10000;
    }

    protected abstract Void manipulate(int var1) throws IOException;
}

