/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.security.decorators;

import org.easymock.EasyMock;
import org.geoserver.security.AccessLimits;
import org.geoserver.security.CatalogMode;
import org.geoserver.security.VectorAccessLimits;
import org.geoserver.security.WrapperPolicy;
import org.geoserver.security.decorators.SecuredFeatureStore;
import org.geoserver.security.decorators.SecuredSimpleFeatureStore;
import org.geoserver.security.impl.SecureObjectsTest;
import org.geotools.api.data.FeatureStore;
import org.geotools.api.data.SimpleFeatureStore;
import org.geotools.api.feature.type.Name;
import org.geotools.api.filter.Filter;
import org.geotools.api.filter.IncludeFilter;
import org.geotools.feature.NameImpl;
import org.junit.Test;

public class SecuredFeatureStoreTest
extends SecureObjectsTest {
    @Test
    public void testUpdateTwiceComplex() throws Exception {
        SimpleFeatureStore fs = (SimpleFeatureStore)EasyMock.createMock(SimpleFeatureStore.class);
        Name[] names = new Name[]{new NameImpl("foo")};
        Object[] values = new Object[]{"abc"};
        IncludeFilter filter = Filter.INCLUDE;
        fs.modifyFeatures((Name[])EasyMock.eq((Object)names), (Object[])EasyMock.eq((Object)values), (Filter)EasyMock.eq((Object)filter));
        EasyMock.expectLastCall().once();
        EasyMock.replay((Object[])new Object[]{fs});
        VectorAccessLimits limits = new VectorAccessLimits(CatalogMode.HIDE, null, (Filter)Filter.INCLUDE, null, (Filter)Filter.INCLUDE);
        SecuredFeatureStore store = new SecuredFeatureStore((FeatureStore)fs, WrapperPolicy.readWrite((AccessLimits)limits));
        store.modifyFeatures(names, values, (Filter)filter);
        EasyMock.verify((Object[])new Object[]{fs});
    }

    @Test
    public void testUpdateTwiceSimple() throws Exception {
        SimpleFeatureStore fs = (SimpleFeatureStore)EasyMock.createMock(SimpleFeatureStore.class);
        String[] names = new String[]{"foo"};
        Object[] values = new Object[]{"abc"};
        IncludeFilter filter = Filter.INCLUDE;
        fs.modifyFeatures((String[])EasyMock.eq((Object)names), (Object[])EasyMock.eq((Object)values), (Filter)EasyMock.eq((Object)filter));
        EasyMock.expectLastCall().once();
        EasyMock.replay((Object[])new Object[]{fs});
        VectorAccessLimits limits = new VectorAccessLimits(CatalogMode.HIDE, null, (Filter)Filter.INCLUDE, null, (Filter)Filter.INCLUDE);
        SecuredSimpleFeatureStore store = new SecuredSimpleFeatureStore(fs, WrapperPolicy.readWrite((AccessLimits)limits));
        store.modifyFeatures(names, values, (Filter)filter);
        EasyMock.verify((Object[])new Object[]{fs});
    }
}

