/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.security.decorators;

import java.util.ArrayList;
import java.util.List;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import org.easymock.EasyMock;
import org.geoserver.security.WrapperPolicy;
import org.geoserver.security.decorators.ReadOnlyDataAccess;
import org.geoserver.security.decorators.ReadOnlyDataStore;
import org.geoserver.security.decorators.ReadOnlyDataStoreTest;
import org.geoserver.security.decorators.SecuredFeatureCollection;
import org.geoserver.security.decorators.SecuredFeatureSource;
import org.geoserver.security.decorators.SecuredFeatureStore;
import org.geoserver.security.impl.SecureObjectsTest;
import org.geotools.api.data.DataAccess;
import org.geotools.api.data.DataStore;
import org.geotools.api.data.FeatureSource;
import org.geotools.api.data.FeatureStore;
import org.geotools.api.data.Query;
import org.geotools.api.data.SimpleFeatureSource;
import org.geotools.api.data.SimpleFeatureStore;
import org.geotools.api.feature.Feature;
import org.geotools.api.feature.simple.SimpleFeatureType;
import org.geotools.api.feature.type.FeatureType;
import org.geotools.api.filter.Filter;
import org.geotools.api.filter.FilterFactory;
import org.geotools.api.filter.expression.PropertyName;
import org.geotools.data.complex.feature.type.ComplexFeatureTypeImpl;
import org.geotools.data.simple.SimpleFeatureCollection;
import org.geotools.factory.CommonFactoryFinder;
import org.geotools.feature.FeatureCollection;
import org.geotools.feature.NameImpl;
import org.geotools.util.logging.Logging;
import org.junit.Assert;
import org.junit.Test;

public class SecuredFeatureSourceTest
extends SecureObjectsTest {
    @Test
    public void testReadOnlyFeatureSourceDataStore() throws Exception {
        DataStore ds = (DataStore)EasyMock.createNiceMock(DataStore.class);
        EasyMock.replay((Object[])new Object[]{ds});
        SimpleFeatureSource fs = (SimpleFeatureSource)EasyMock.createNiceMock(SimpleFeatureSource.class);
        SimpleFeatureCollection fc = (SimpleFeatureCollection)EasyMock.createNiceMock(SimpleFeatureCollection.class);
        EasyMock.expect((Object)((SimpleFeatureType)fc.getSchema())).andReturn((Object)((SimpleFeatureType)EasyMock.createNiceMock(SimpleFeatureType.class)));
        EasyMock.replay((Object[])new Object[]{fc});
        EasyMock.expect((Object)fs.getDataStore()).andReturn((Object)ds);
        EasyMock.expect((Object)fs.getFeatures()).andReturn((Object)fc).anyTimes();
        EasyMock.expect((Object)fs.getFeatures((Filter)EasyMock.anyObject())).andReturn((Object)fc).anyTimes();
        EasyMock.expect((Object)fs.getFeatures((Query)EasyMock.anyObject())).andReturn((Object)fc).anyTimes();
        EasyMock.replay((Object[])new Object[]{fs});
        SecuredFeatureSource ro = new SecuredFeatureSource((FeatureSource)fs, WrapperPolicy.hide(null));
        Assert.assertTrue((boolean)(ro.getDataStore() instanceof ReadOnlyDataStore));
        ro.getFeatures();
        Assert.assertTrue((boolean)ro.policy.isHide());
        Assert.assertTrue((boolean)(ro.getFeatures((Filter)Filter.INCLUDE) instanceof SecuredFeatureCollection));
        Assert.assertTrue((boolean)(ro.getFeatures(new Query()) instanceof SecuredFeatureCollection));
    }

    @Test
    public void testReadOnlyFeatureStore() throws Exception {
        block2: {
            SimpleFeatureType schema = (SimpleFeatureType)EasyMock.createNiceMock(SimpleFeatureType.class);
            EasyMock.expect((Object)schema.getName()).andReturn((Object)new NameImpl("testFT"));
            EasyMock.replay((Object[])new Object[]{schema});
            SimpleFeatureStore fs = (SimpleFeatureStore)EasyMock.createNiceMock(SimpleFeatureStore.class);
            EasyMock.expect((Object)((SimpleFeatureType)fs.getSchema())).andReturn((Object)schema);
            EasyMock.replay((Object[])new Object[]{fs});
            SecuredFeatureStore ro = new SecuredFeatureStore((FeatureStore)fs, WrapperPolicy.readOnlyChallenge(null));
            try {
                ro.addFeatures((FeatureCollection)EasyMock.createNiceMock(SimpleFeatureCollection.class));
                Assert.fail((String)"This should have thrown a security exception");
            }
            catch (Exception e) {
                if (ReadOnlyDataStoreTest.isSpringSecurityException(e)) break block2;
                Assert.fail((String)"Should have failed with a security exception");
            }
        }
    }

    @Test
    public <T extends FeatureType, F extends Feature> void testReadOnlyFeatureSourceDataAccess() throws Exception {
        DataAccess da = (DataAccess)EasyMock.createNiceMock(DataAccess.class);
        EasyMock.replay((Object[])new Object[]{da});
        FeatureSource fs = (FeatureSource)EasyMock.createNiceMock(FeatureSource.class);
        EasyMock.expect((Object)fs.getDataStore()).andReturn((Object)da);
        EasyMock.replay((Object[])new Object[]{fs});
        SecuredFeatureSource ro = new SecuredFeatureSource(fs, WrapperPolicy.readOnlyChallenge(null));
        Assert.assertTrue((boolean)(ro.getDataStore() instanceof ReadOnlyDataAccess));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public <T extends FeatureType, F extends Feature> void testSecuredFeatureSourceLoggingWithComplex() throws Exception {
        FeatureType schema = (FeatureType)EasyMock.createNiceMock(ComplexFeatureTypeImpl.class);
        EasyMock.expect((Object)schema.getName()).andReturn((Object)new NameImpl("testComplexFt"));
        List descriptors = (List)EasyMock.createNiceMock(List.class);
        EasyMock.expect((Object)descriptors.size()).andReturn((Object)3).anyTimes();
        EasyMock.replay((Object[])new Object[]{descriptors});
        EasyMock.expect((Object)schema.getDescriptors()).andReturn((Object)descriptors).anyTimes();
        EasyMock.replay((Object[])new Object[]{schema});
        DataAccess store = (DataAccess)EasyMock.createNiceMock(DataAccess.class);
        EasyMock.replay((Object[])new Object[]{store});
        FeatureStore fStore = (FeatureStore)EasyMock.createNiceMock(FeatureStore.class);
        EasyMock.expect((Object)fStore.getSchema()).andReturn((Object)schema).anyTimes();
        FeatureCollection fc = (FeatureCollection)EasyMock.createNiceMock(FeatureCollection.class);
        EasyMock.expect((Object)fStore.getDataStore()).andReturn((Object)store);
        EasyMock.expect((Object)fStore.getFeatures()).andReturn((Object)fc).anyTimes();
        EasyMock.expect((Object)fStore.getFeatures((Filter)EasyMock.anyObject())).andReturn((Object)fc).anyTimes();
        EasyMock.expect((Object)fStore.getFeatures((Query)EasyMock.anyObject())).andReturn((Object)fc).anyTimes();
        EasyMock.expect((Object)fc.getSchema()).andReturn((Object)schema).anyTimes();
        EasyMock.replay((Object[])new Object[]{fStore});
        EasyMock.replay((Object[])new Object[]{fc});
        Logger logger = Logging.getLogger(SecuredFeatureSource.class);
        class LogHandler
        extends Handler {
            List<String> messages = new ArrayList<String>();

            LogHandler() {
            }

            @Override
            public void publish(LogRecord record) {
                this.messages.add(record.getMessage());
            }

            @Override
            public void flush() {
            }

            @Override
            public void close() throws SecurityException {
            }
        }
        LogHandler customLogHandler = new LogHandler();
        logger.addHandler(customLogHandler);
        customLogHandler.setLevel(Level.SEVERE);
        logger.addHandler(customLogHandler);
        try {
            SecuredFeatureStore ro = new SecuredFeatureStore(fStore, WrapperPolicy.readOnlyHide(null));
            Query q = new Query("testComplextFt");
            ArrayList<PropertyName> pnames = new ArrayList<PropertyName>(1);
            FilterFactory ff = CommonFactoryFinder.getFilterFactory();
            pnames.add(ff.property("someProperty"));
            q.setProperties(pnames);
            ro.getFeatures(q);
            String notExpectedMessage = "Complex store returned more properties than allowed by security (because they are required by the schema). Either the security setup is broken or you have a security breach";
            Assert.assertFalse((boolean)customLogHandler.messages.contains(notExpectedMessage));
        }
        finally {
            logger.removeHandler(customLogHandler);
        }
    }
}

