/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.security.decorators;

import org.easymock.EasyMock;
import org.geoserver.security.SecurityUtils;
import org.geoserver.security.WrapperPolicy;
import org.geoserver.security.decorators.ReadOnlyDataAccess;
import org.geoserver.security.decorators.SecuredFeatureSource;
import org.geoserver.security.impl.SecureObjectsTest;
import org.geotools.api.data.DataAccess;
import org.geotools.api.data.FeatureSource;
import org.geotools.api.feature.Feature;
import org.geotools.api.feature.type.FeatureType;
import org.geotools.api.feature.type.Name;
import org.geotools.feature.NameImpl;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class ReadOnlyDataAccessTest<T extends FeatureType, F extends Feature>
extends SecureObjectsTest {
    private DataAccess<T, F> da;
    private NameImpl name;

    @Before
    public void setUp() throws Exception {
        FeatureSource fs = (FeatureSource)EasyMock.createNiceMock(FeatureSource.class);
        EasyMock.replay((Object[])new Object[]{fs});
        FeatureType schema = (FeatureType)EasyMock.createNiceMock(FeatureType.class);
        EasyMock.replay((Object[])new Object[]{schema});
        this.da = (DataAccess)EasyMock.createNiceMock(DataAccess.class);
        this.name = new NameImpl("blah");
        EasyMock.expect((Object)this.da.getFeatureSource((Name)this.name)).andReturn((Object)fs);
        EasyMock.replay((Object[])new Object[]{this.da});
    }

    @Test
    public void testDontChallenge() throws Exception {
        ReadOnlyDataAccess ro = new ReadOnlyDataAccess(this.da, WrapperPolicy.hide(null));
        SecuredFeatureSource fs = (SecuredFeatureSource)ro.getFeatureSource((Name)this.name);
        Assert.assertTrue((boolean)fs.policy.isHide());
        try {
            ro.createSchema(null);
            Assert.fail((String)"Should have failed with an unsupported operation exception");
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
        try {
            ro.updateSchema(null, null);
            Assert.fail((String)"Should have failed with an unsupported operation exception");
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
    }

    @Test
    public void testChallenge() throws Exception {
        block5: {
            ReadOnlyDataAccess ro;
            block4: {
                ro = new ReadOnlyDataAccess(this.da, WrapperPolicy.readOnlyChallenge(null));
                SecuredFeatureSource fs = (SecuredFeatureSource)ro.getFeatureSource((Name)this.name);
                Assert.assertTrue((boolean)fs.policy.isReadOnlyChallenge());
                try {
                    ro.createSchema(null);
                    Assert.fail((String)"Should have failed with a security exception");
                }
                catch (Throwable e) {
                    if (SecurityUtils.isSecurityException((Throwable)e)) break block4;
                    Assert.fail((String)"Should have thrown a security exception...");
                }
            }
            try {
                ro.updateSchema(null, null);
                Assert.fail((String)"Should have failed with a security exception");
            }
            catch (Throwable e) {
                if (SecurityUtils.isSecurityException((Throwable)e)) break block5;
                Assert.fail((String)"Should have thrown a security exception...");
            }
        }
    }
}

