/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.security.auth;

import java.io.IOException;
import org.geoserver.data.test.SystemTestData;
import org.geoserver.platform.GeoServerEnvironment;
import org.geoserver.security.GeoServerAuthenticationProvider;
import org.geoserver.security.GeoServerUserGroupService;
import org.geoserver.security.GeoServerUserGroupStore;
import org.geoserver.security.auth.AbstractAuthenticationProviderTest;
import org.geoserver.security.auth.UsernamePasswordAuthenticationProvider;
import org.geoserver.security.config.SecurityAuthProviderConfig;
import org.geoserver.security.config.UsernamePasswordAuthenticationProviderConfig;
import org.geoserver.security.impl.GeoServerUser;
import org.geoserver.security.validation.PasswordPolicyException;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.springframework.security.authentication.UsernamePasswordAuthenticationToken;
import org.springframework.security.core.Authentication;

public class PwdEnvParametrizationTest
extends AbstractAuthenticationProviderTest {
    private static final String PLAIN_TXT_PRV = "plainProvider";
    private static final String PBE_PRV = "pbeProvider";
    private static final String STRONG_PBE_PRV = "strongProvider";
    private static final String PLAIN_UG_SRV = "plainTextUgSrv";
    private static final String PBE_UG_SRV = "pbeUgSrv";
    private static final String STRONG_PBE_UG_SRV = "strongPbeUgSrv";

    @BeforeClass
    public static void setupClass() {
        System.setProperty("ALLOW_ENV_PARAMETRIZATION", "true");
        GeoServerEnvironment.reloadAllowEnvParametrization();
    }

    @AfterClass
    public static void tearDownClass() {
        System.clearProperty("ALLOW_ENV_PARAMETRIZATION");
        GeoServerEnvironment.reloadAllowEnvParametrization();
    }

    protected void onSetUp(SystemTestData testData) throws Exception {
        super.onSetUp(testData);
        this.createUserGroupService(PLAIN_UG_SRV, this.getPlainTextPasswordEncoder().getName());
        this.createUserGroupService(PBE_UG_SRV, this.getPBEPasswordEncoder().getName());
        this.createUserGroupService(STRONG_PBE_UG_SRV, this.getStrongPBEPasswordEncoder().getName());
        UsernamePasswordAuthenticationProviderConfig plainTxt = new UsernamePasswordAuthenticationProviderConfig();
        plainTxt.setUserGroupServiceName(PLAIN_UG_SRV);
        plainTxt.setName(PLAIN_TXT_PRV);
        plainTxt.setClassName(UsernamePasswordAuthenticationProvider.class.getName());
        this.getSecurityManager().saveAuthenticationProvider((SecurityAuthProviderConfig)plainTxt);
        UsernamePasswordAuthenticationProviderConfig pbe = new UsernamePasswordAuthenticationProviderConfig();
        pbe.setUserGroupServiceName(PBE_UG_SRV);
        pbe.setName(PBE_PRV);
        pbe.setClassName(UsernamePasswordAuthenticationProvider.class.getName());
        this.getSecurityManager().saveAuthenticationProvider((SecurityAuthProviderConfig)pbe);
        UsernamePasswordAuthenticationProviderConfig strongPbe = new UsernamePasswordAuthenticationProviderConfig();
        strongPbe.setUserGroupServiceName(STRONG_PBE_UG_SRV);
        strongPbe.setName(STRONG_PBE_PRV);
        strongPbe.setClassName(UsernamePasswordAuthenticationProvider.class.getName());
        this.getSecurityManager().saveAuthenticationProvider((SecurityAuthProviderConfig)strongPbe);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testPbeUgSrvWithPlainTxtPwd() throws IOException, PasswordPolicyException {
        String key = "env.pwd1";
        System.setProperty(key, "plain:my_password");
        try {
            this.createGeoServerUser("test_env1", "${env.pwd1}", PBE_UG_SRV);
            GeoServerAuthenticationProvider provider = this.getSecurityManager().loadAuthenticationProvider(PBE_PRV);
            UsernamePasswordAuthenticationToken authentication = new UsernamePasswordAuthenticationToken((Object)"test_env1", (Object)"my_password");
            authentication = provider.authenticate((Authentication)authentication);
            Assert.assertNotNull((Object)authentication);
        }
        finally {
            this.removePwdEnv(key);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testPbeUgSrvWithDigestPwd() throws IOException, PasswordPolicyException {
        String key = "env.pwd2";
        System.setProperty(key, "digest1:D9miJH/hVgfxZJscMafEtbtliG0ROxhLfsznyWfG38X2pda2JOSV4POi55PQI4tw");
        try {
            this.createGeoServerUser("test_env2", "${env.pwd2}", PBE_UG_SRV);
            GeoServerAuthenticationProvider provider = this.getSecurityManager().loadAuthenticationProvider(PBE_PRV);
            UsernamePasswordAuthenticationToken authentication = new UsernamePasswordAuthenticationToken((Object)"test_env2", (Object)"geoserver");
            authentication = provider.authenticate((Authentication)authentication);
            Assert.assertNotNull((Object)authentication);
        }
        finally {
            this.removePwdEnv(key);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testPlainTxtUgSrvWithPlainTxtPwd() throws IOException, PasswordPolicyException {
        String key = "env.pwd3";
        System.setProperty(key, "plain:my_password");
        try {
            this.createGeoServerUser("test_env3", "${env.pwd3}", PLAIN_UG_SRV);
            GeoServerAuthenticationProvider provider = this.getSecurityManager().loadAuthenticationProvider(PLAIN_TXT_PRV);
            UsernamePasswordAuthenticationToken authentication = new UsernamePasswordAuthenticationToken((Object)"test_env3", (Object)"my_password");
            authentication = provider.authenticate((Authentication)authentication);
            Assert.assertNotNull((Object)authentication);
        }
        finally {
            this.removePwdEnv(key);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testPlainTxtUgSrvWithDigestPwd() throws IOException, PasswordPolicyException {
        String key = "env.pwd4";
        System.setProperty(key, "digest1:D9miJH/hVgfxZJscMafEtbtliG0ROxhLfsznyWfG38X2pda2JOSV4POi55PQI4tw");
        try {
            this.createGeoServerUser("test_env4", "${env.pwd4}", PLAIN_UG_SRV);
            GeoServerAuthenticationProvider provider = this.getSecurityManager().loadAuthenticationProvider(PLAIN_TXT_PRV);
            UsernamePasswordAuthenticationToken authentication = new UsernamePasswordAuthenticationToken((Object)"test_env4", (Object)"geoserver");
            authentication = provider.authenticate((Authentication)authentication);
            Assert.assertNotNull((Object)authentication);
        }
        finally {
            this.removePwdEnv(key);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testStrongPBETxtUgSrvWithPlainTxtPwd() throws IOException, PasswordPolicyException {
        String key = "env.pwd5";
        System.setProperty(key, "plain:my_password");
        try {
            this.createGeoServerUser("test_env5", "${env.pwd5}", STRONG_PBE_UG_SRV);
            GeoServerAuthenticationProvider provider = this.getSecurityManager().loadAuthenticationProvider(STRONG_PBE_PRV);
            UsernamePasswordAuthenticationToken authentication = new UsernamePasswordAuthenticationToken((Object)"test_env5", (Object)"my_password");
            authentication = provider.authenticate((Authentication)authentication);
            Assert.assertNotNull((Object)authentication);
        }
        finally {
            this.removePwdEnv(key);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testStrongPBEUgSrvWithDigestPwd() throws IOException, PasswordPolicyException {
        String key = "env.pwd6";
        System.setProperty(key, "digest1:D9miJH/hVgfxZJscMafEtbtliG0ROxhLfsznyWfG38X2pda2JOSV4POi55PQI4tw");
        try {
            this.createGeoServerUser("test_env6", "${env.pwd6}", PLAIN_UG_SRV);
            GeoServerAuthenticationProvider provider = this.getSecurityManager().loadAuthenticationProvider(PLAIN_TXT_PRV);
            UsernamePasswordAuthenticationToken authentication = new UsernamePasswordAuthenticationToken((Object)"test_env6", (Object)"geoserver");
            authentication = provider.authenticate((Authentication)authentication);
            Assert.assertNotNull((Object)authentication);
        }
        finally {
            this.removePwdEnv(key);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testStrongPBEUgSrvAuthFails() throws IOException, PasswordPolicyException {
        String key = "env.pwd7";
        System.setProperty(key, "digest1:D9miJH/hVgfxZJscMafEtbtliG0ROxhLfsznyWfG38X2pda2JOSV4POi55PQI4tw");
        try {
            this.createGeoServerUser("test_env7", "${env.pwd7}", PLAIN_UG_SRV);
            GeoServerAuthenticationProvider provider = this.getSecurityManager().loadAuthenticationProvider(PLAIN_TXT_PRV);
            UsernamePasswordAuthenticationToken authentication = new UsernamePasswordAuthenticationToken((Object)"test_env7", (Object)"wrong");
            authentication = provider.authenticate((Authentication)authentication);
            Assert.assertNull((Object)authentication);
        }
        finally {
            this.removePwdEnv(key);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testPlainTxtUgSrvAuthFails() throws IOException, PasswordPolicyException {
        String key = "env.pwd8";
        System.setProperty(key, "digest1:D9miJH/hVgfxZJscMafEtbtliG0ROxhLfsznyWfG38X2pda2JOSV4POi55PQI4tw");
        try {
            this.createGeoServerUser("test_env8", "${env.pwd8}", PLAIN_UG_SRV);
            GeoServerAuthenticationProvider provider = this.getSecurityManager().loadAuthenticationProvider(PLAIN_TXT_PRV);
            UsernamePasswordAuthenticationToken authentication = new UsernamePasswordAuthenticationToken((Object)"test_env8", (Object)"wrong");
            authentication = provider.authenticate((Authentication)authentication);
            Assert.assertNull((Object)authentication);
        }
        finally {
            this.removePwdEnv(key);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testPbeUgSrvAuthFails() throws IOException, PasswordPolicyException {
        String key = "env.pwd9";
        System.setProperty(key, "plain:my_password");
        try {
            this.createGeoServerUser("test_env9", "${env.pwd9}", PBE_UG_SRV);
            GeoServerAuthenticationProvider provider = this.getSecurityManager().loadAuthenticationProvider(PBE_PRV);
            UsernamePasswordAuthenticationToken authentication = new UsernamePasswordAuthenticationToken((Object)"test_env9", (Object)"wrong");
            authentication = provider.authenticate((Authentication)authentication);
            Assert.assertNull((Object)authentication);
        }
        finally {
            this.removePwdEnv(key);
        }
    }

    private void createGeoServerUser(String username, String pwd, String ugSrvName) throws IOException, PasswordPolicyException {
        GeoServerUserGroupService groupService = this.getSecurityManager().loadUserGroupService(ugSrvName);
        GeoServerUserGroupStore userGroupStore = groupService.createStore();
        GeoServerUser user = userGroupStore.createUserObject(username, pwd, true);
        userGroupStore.addUser(user);
        userGroupStore.store();
    }

    private void removePwdEnv(String env_var) {
        System.clearProperty(env_var);
    }
}

