/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.security.auth;

import java.security.Principal;
import java.util.Map;
import javax.servlet.FilterChain;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.Cookie;
import org.geoserver.data.test.SystemTestData;
import org.geoserver.security.auth.AbstractAuthenticationProviderTest;
import org.geoserver.security.auth.TestingAuthenticationCache;
import org.geoserver.security.config.BasicAuthenticationFilterConfig;
import org.geoserver.security.config.DigestAuthenticationFilterConfig;
import org.geoserver.security.config.J2eeAuthenticationBaseFilterConfig;
import org.geoserver.security.config.J2eeAuthenticationFilterConfig;
import org.geoserver.security.config.PreAuthenticatedUserNameFilterConfig;
import org.geoserver.security.config.RequestHeaderAuthenticationFilterConfig;
import org.geoserver.security.config.RoleSource;
import org.geoserver.security.config.SecurityNamedServiceConfig;
import org.geoserver.security.config.X509CertificateAuthenticationFilterConfig;
import org.geoserver.security.filter.GeoServerBasicAuthenticationFilter;
import org.geoserver.security.filter.GeoServerDigestAuthenticationFilter;
import org.geoserver.security.filter.GeoServerJ2eeAuthenticationFilter;
import org.geoserver.security.filter.GeoServerRequestHeaderAuthenticationFilter;
import org.geoserver.security.filter.GeoServerX509CertificateAuthenticationFilter;
import org.geoserver.security.impl.GeoServerRole;
import org.geoserver.security.password.MasterPasswordProviderConfig;
import org.geoserver.test.RunTestSetup;
import org.geoserver.test.SystemTest;
import org.geotools.util.Base64;
import org.junit.Assert;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.springframework.mock.web.MockFilterChain;
import org.springframework.mock.web.MockHttpServletRequest;
import org.springframework.mock.web.MockHttpServletResponse;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.web.bind.annotation.RequestMethod;

@Category(value={SystemTest.class})
public class AuthenticationCacheFilterTest
extends AbstractAuthenticationProviderTest {
    public static final String testFilterName = "basicAuthTestFilter";
    public static final String testFilterName2 = "digestAuthTestFilter";
    public static final String testFilterName3 = "j2eeAuthTestFilter";
    public static final String testFilterName4 = "requestHeaderTestFilter";
    public static final String testFilterName5 = "basicAuthTestFilterWithRememberMe";
    public static final String testFilterName8 = "x509TestFilter";

    protected void onSetUp(SystemTestData testData) throws Exception {
        super.onSetUp(testData);
        BasicAuthenticationFilterConfig config = new BasicAuthenticationFilterConfig();
        config.setClassName(GeoServerBasicAuthenticationFilter.class.getName());
        config.setUseRememberMe(false);
        config.setName(testFilterName);
        this.getSecurityManager().saveFilter((SecurityNamedServiceConfig)config);
    }

    Authentication getAuth(String filterName, String user, Integer idleTime, Integer liveTime) {
        Map map = (Map)this.getCache().cache.get(filterName);
        if (map == null) {
            return null;
        }
        Authentication result = null;
        String cacheKey = null;
        for (Map.Entry entry : map.entrySet()) {
            Authentication auth = this.getCache().deserializeAuthentication((byte[])entry.getValue());
            Object o = auth.getPrincipal();
            if (o instanceof UserDetails && user.equals(((UserDetails)o).getUsername())) {
                result = auth;
                cacheKey = (String)entry.getKey();
                break;
            }
            if (o instanceof Principal && user.equals(((Principal)o).getName())) {
                result = auth;
                cacheKey = (String)entry.getKey();
                break;
            }
            if (!(o instanceof String) || !user.equals(o)) continue;
            result = auth;
            cacheKey = (String)entry.getKey();
            break;
        }
        if (result != null) {
            Integer[] seconds = this.getCache().getExpireTimes(filterName, cacheKey);
            if (idleTime == null) {
                Assert.assertEquals((Object)TestingAuthenticationCache.DEFAULT_IDLE_SECS, (Object)seconds[0]);
            } else {
                Assert.assertEquals((Object)idleTime, (Object)seconds[0]);
            }
            if (liveTime == null) {
                Assert.assertEquals((Object)TestingAuthenticationCache.DEFAULT_LIVE_SECS, (Object)seconds[1]);
            } else {
                Assert.assertEquals((Object)liveTime, (Object)seconds[1]);
            }
        }
        return result;
    }

    @Test
    public void testBasicAuth() throws Exception {
        this.prepareFilterChain(this.pattern, new String[]{testFilterName});
        SecurityContextHolder.getContext().setAuthentication(null);
        MockHttpServletRequest request = this.createRequest("/foo/bar");
        request.setMethod(RequestMethod.GET.toString());
        MockHttpServletResponse response = new MockHttpServletResponse();
        MockFilterChain chain = new MockFilterChain();
        this.getProxy().doFilter((ServletRequest)request, (ServletResponse)response, (FilterChain)chain);
        String tmp = response.getHeader("WWW-Authenticate");
        Assert.assertNotNull((Object)tmp);
        assert (tmp.contains("GeoServer Realm"));
        assert (tmp.contains("Basic"));
        Assert.assertEquals((long)401L, (long)response.getStatus());
        Assert.assertNull((Object)SecurityContextHolder.getContext().getAuthentication());
        request = this.createRequest("/foo/bar");
        request.setMethod("GET");
        response = new MockHttpServletResponse();
        chain = new MockFilterChain();
        request.addHeader("Authorization", (Object)("Basic " + Base64.encodeBytes((byte[])"user1:pw1".getBytes())));
        this.getProxy().doFilter((ServletRequest)request, (ServletResponse)response, (FilterChain)chain);
        Assert.assertEquals((long)200L, (long)response.getStatus());
        Authentication auth = this.getAuth(testFilterName, "user1", null, null);
        Assert.assertNotNull((Object)auth);
        Assert.assertNull((Object)SecurityContextHolder.getContext().getAuthentication());
        this.checkForAuthenticatedRole(auth);
        Assert.assertEquals((Object)"user1", (Object)((UserDetails)auth.getPrincipal()).getUsername());
        Assert.assertTrue((boolean)auth.getAuthorities().contains(new GeoServerRole("RootRole")));
        Assert.assertTrue((boolean)auth.getAuthorities().contains(new GeoServerRole("DerivedRole")));
        request = this.createRequest("/foo/bar");
        request.setMethod("GET");
        response = new MockHttpServletResponse();
        chain = new MockFilterChain();
        request.addHeader("Authorization", (Object)("Basic " + Base64.encodeBytes((byte[])"unknwon:pw1".getBytes())));
        this.getProxy().doFilter((ServletRequest)request, (ServletResponse)response, (FilterChain)chain);
        tmp = response.getHeader("WWW-Authenticate");
        Assert.assertNotNull((Object)tmp);
        assert (tmp.contains("GeoServer Realm"));
        assert (tmp.contains("Basic"));
        Assert.assertEquals((long)401L, (long)response.getStatus());
        auth = this.getAuth("unknow", "pw1", null, null);
        Assert.assertNull((Object)auth);
        Assert.assertNull((Object)SecurityContextHolder.getContext().getAuthentication());
        request = this.createRequest("/foo/bar");
        request.setMethod("GET");
        response = new MockHttpServletResponse();
        chain = new MockFilterChain();
        request.addHeader("Authorization", (Object)("Basic " + Base64.encodeBytes((byte[])("root:" + this.getMasterPassword()).getBytes())));
        this.getProxy().doFilter((ServletRequest)request, (ServletResponse)response, (FilterChain)chain);
        Assert.assertEquals((long)401L, (long)response.getStatus());
        auth = this.getAuth("root", "geoserver", null, null);
        Assert.assertNull((Object)auth);
        Assert.assertNull((Object)SecurityContextHolder.getContext().getAuthentication());
        this.updateUser("ug1", "user1", false);
        request = this.createRequest("/foo/bar");
        request.setMethod("GET");
        response = new MockHttpServletResponse();
        chain = new MockFilterChain();
        request.addHeader("Authorization", (Object)("Basic " + Base64.encodeBytes((byte[])"user1:pw1".getBytes())));
        this.getProxy().doFilter((ServletRequest)request, (ServletResponse)response, (FilterChain)chain);
        Assert.assertEquals((long)200L, (long)response.getStatus());
        auth = this.getAuth(testFilterName, "user1", null, null);
        Assert.assertNotNull((Object)auth);
        Assert.assertNull((Object)SecurityContextHolder.getContext().getAuthentication());
        this.checkForAuthenticatedRole(auth);
        Assert.assertEquals((Object)"user1", (Object)((UserDetails)auth.getPrincipal()).getUsername());
        Assert.assertTrue((boolean)auth.getAuthorities().contains(new GeoServerRole("RootRole")));
        Assert.assertTrue((boolean)auth.getAuthorities().contains(new GeoServerRole("DerivedRole")));
        this.getCache().removeAll();
        request = this.createRequest("/foo/bar");
        request.setMethod("GET");
        response = new MockHttpServletResponse();
        chain = new MockFilterChain();
        request.addHeader("Authorization", (Object)("Basic " + Base64.encodeBytes((byte[])"user1:pw1".getBytes())));
        this.getProxy().doFilter((ServletRequest)request, (ServletResponse)response, (FilterChain)chain);
        tmp = response.getHeader("WWW-Authenticate");
        Assert.assertNotNull((Object)tmp);
        assert (tmp.contains("GeoServer Realm"));
        assert (tmp.contains("Basic"));
        Assert.assertEquals((long)401L, (long)response.getStatus());
        Assert.assertNull((Object)SecurityContextHolder.getContext().getAuthentication());
        this.updateUser("ug1", "user1", true);
    }

    @Test
    public void testJ2eeProxy() throws Exception {
        J2eeAuthenticationFilterConfig config = new J2eeAuthenticationFilterConfig();
        config.setClassName(GeoServerJ2eeAuthenticationFilter.class.getName());
        config.setName(testFilterName3);
        config.setRoleSource((RoleSource)J2eeAuthenticationBaseFilterConfig.J2EERoleSource.J2EE);
        config.setRoleServiceName("rs1");
        this.getSecurityManager().saveFilter((SecurityNamedServiceConfig)config);
        this.prepareFilterChain(this.pattern, new String[]{testFilterName3});
        SecurityContextHolder.getContext().setAuthentication(null);
        MockHttpServletRequest request = this.createRequest("/foo/bar");
        request.setMethod("GET");
        MockHttpServletResponse response = new MockHttpServletResponse();
        MockFilterChain chain = new MockFilterChain();
        this.getProxy().doFilter((ServletRequest)request, (ServletResponse)response, (FilterChain)chain);
        Assert.assertEquals((long)403L, (long)response.getStatus());
        Assert.assertNull((Object)SecurityContextHolder.getContext().getAuthentication());
        request = this.createRequest("/foo/bar");
        request.setMethod("GET");
        response = new MockHttpServletResponse();
        chain = new MockFilterChain();
        request.setUserPrincipal(() -> "user1");
        request.addUserRole("DerivedRole");
        this.getProxy().doFilter((ServletRequest)request, (ServletResponse)response, (FilterChain)chain);
        Assert.assertEquals((long)200L, (long)response.getStatus());
        Authentication auth = this.getAuth(testFilterName3, "user1", null, null);
        Assert.assertNotNull((Object)auth);
        Assert.assertNull((Object)SecurityContextHolder.getContext().getAuthentication());
        this.checkForAuthenticatedRole(auth);
        Assert.assertEquals((Object)"user1", (Object)auth.getPrincipal());
        Assert.assertTrue((boolean)auth.getAuthorities().contains(new GeoServerRole("RootRole")));
        Assert.assertTrue((boolean)auth.getAuthorities().contains(new GeoServerRole("DerivedRole")));
        request = this.createRequest("/foo/bar");
        request.setMethod("GET");
        response = new MockHttpServletResponse();
        chain = new MockFilterChain();
        request.setUserPrincipal(() -> "root");
        this.getProxy().doFilter((ServletRequest)request, (ServletResponse)response, (FilterChain)chain);
        Assert.assertEquals((long)200L, (long)response.getStatus());
        auth = this.getAuth(testFilterName3, "root", null, null);
        Assert.assertNull((Object)auth);
        Assert.assertNull((Object)SecurityContextHolder.getContext().getAuthentication());
        config.setRoleServiceName(null);
        this.getSecurityManager().saveFilter((SecurityNamedServiceConfig)config);
        request = this.createRequest("/foo/bar");
        request.setMethod("GET");
        response = new MockHttpServletResponse();
        chain = new MockFilterChain();
        request.setUserPrincipal(() -> "user1");
        request.addUserRole("DerivedRole");
        this.getProxy().doFilter((ServletRequest)request, (ServletResponse)response, (FilterChain)chain);
        Assert.assertEquals((long)200L, (long)response.getStatus());
        auth = this.getAuth(testFilterName3, "user1", null, null);
        Assert.assertNotNull((Object)auth);
        Assert.assertNull((Object)SecurityContextHolder.getContext().getAuthentication());
        this.checkForAuthenticatedRole(auth);
        Assert.assertEquals((Object)"user1", (Object)auth.getPrincipal());
        Assert.assertTrue((boolean)auth.getAuthorities().contains(new GeoServerRole("RootRole")));
        Assert.assertTrue((boolean)auth.getAuthorities().contains(new GeoServerRole("DerivedRole")));
        this.insertAnonymousFilter();
        request = this.createRequest("/foo/bar");
        request.setMethod("GET");
        response = new MockHttpServletResponse();
        chain = new MockFilterChain();
        this.getProxy().doFilter((ServletRequest)request, (ServletResponse)response, (FilterChain)chain);
        Assert.assertEquals((long)200L, (long)response.getStatus());
        this.removeAnonymousFilter();
    }

    @Test
    public void testRequestHeaderProxy() throws Exception {
        Authentication auth;
        RequestHeaderAuthenticationFilterConfig config = new RequestHeaderAuthenticationFilterConfig();
        config.setClassName(GeoServerRequestHeaderAuthenticationFilter.class.getName());
        config.setName(testFilterName4);
        config.setRoleServiceName("rs1");
        config.setPrincipalHeaderAttribute("principal");
        config.setRoleSource((RoleSource)PreAuthenticatedUserNameFilterConfig.PreAuthenticatedUserNameRoleSource.RoleService);
        config.setUserGroupServiceName("ug1");
        config.setPrincipalHeaderAttribute("principal");
        config.setRolesHeaderAttribute("roles");
        this.getSecurityManager().saveFilter((SecurityNamedServiceConfig)config);
        this.prepareFilterChain(this.pattern, new String[]{testFilterName4});
        SecurityContextHolder.getContext().setAuthentication(null);
        MockHttpServletRequest request = this.createRequest("/foo/bar");
        request.setMethod("GET");
        MockHttpServletResponse response = new MockHttpServletResponse();
        MockFilterChain chain = new MockFilterChain();
        this.getProxy().doFilter((ServletRequest)request, (ServletResponse)response, (FilterChain)chain);
        Assert.assertEquals((long)403L, (long)response.getStatus());
        Assert.assertNull((Object)SecurityContextHolder.getContext().getAuthentication());
        for (PreAuthenticatedUserNameFilterConfig.PreAuthenticatedUserNameRoleSource rs : PreAuthenticatedUserNameFilterConfig.PreAuthenticatedUserNameRoleSource.values()) {
            this.getCache().removeAll();
            config.setRoleSource((RoleSource)rs);
            this.getSecurityManager().saveFilter((SecurityNamedServiceConfig)config);
            request = this.createRequest("/foo/bar");
            request.setMethod("GET");
            response = new MockHttpServletResponse();
            chain = new MockFilterChain();
            request.addHeader("principal", (Object)"user1");
            if (rs.equals((RoleSource)PreAuthenticatedUserNameFilterConfig.PreAuthenticatedUserNameRoleSource.Header)) {
                request.addHeader("roles", (Object)"DerivedRole;RootRole");
            }
            this.getProxy().doFilter((ServletRequest)request, (ServletResponse)response, (FilterChain)chain);
            Assert.assertEquals((long)200L, (long)response.getStatus());
            auth = this.getAuth(testFilterName4, "user1", null, null);
            if (rs.equals((RoleSource)PreAuthenticatedUserNameFilterConfig.PreAuthenticatedUserNameRoleSource.Header)) continue;
            Assert.assertNotNull((Object)auth);
            Assert.assertNull((Object)SecurityContextHolder.getContext().getAuthentication());
            this.checkForAuthenticatedRole(auth);
            Assert.assertEquals((Object)"user1", (Object)auth.getPrincipal());
            Assert.assertTrue((boolean)auth.getAuthorities().contains(new GeoServerRole("RootRole")));
            Assert.assertTrue((boolean)auth.getAuthorities().contains(new GeoServerRole("DerivedRole")));
        }
        for (PreAuthenticatedUserNameFilterConfig.PreAuthenticatedUserNameRoleSource rs : PreAuthenticatedUserNameFilterConfig.PreAuthenticatedUserNameRoleSource.values()) {
            this.getCache().removeAll();
            config.setRoleSource((RoleSource)rs);
            this.getSecurityManager().saveFilter((SecurityNamedServiceConfig)config);
            config.setRoleSource((RoleSource)rs);
            request = this.createRequest("/foo/bar");
            request.setMethod("GET");
            response = new MockHttpServletResponse();
            chain = new MockFilterChain();
            request.addHeader("principal", (Object)"unknown");
            this.getProxy().doFilter((ServletRequest)request, (ServletResponse)response, (FilterChain)chain);
            Assert.assertEquals((long)200L, (long)response.getStatus());
            if (rs.equals((RoleSource)PreAuthenticatedUserNameFilterConfig.PreAuthenticatedUserNameRoleSource.Header)) continue;
            auth = this.getAuth(testFilterName4, "unknown", null, null);
            Assert.assertNotNull((Object)auth);
            Assert.assertNull((Object)SecurityContextHolder.getContext().getAuthentication());
            this.checkForAuthenticatedRole(auth);
            Assert.assertEquals((Object)"unknown", (Object)auth.getPrincipal());
        }
        config.setRoleSource((RoleSource)PreAuthenticatedUserNameFilterConfig.PreAuthenticatedUserNameRoleSource.UserGroupService);
        this.getSecurityManager().saveFilter((SecurityNamedServiceConfig)config);
        this.updateUser("ug1", "user1", false);
        request = this.createRequest("/foo/bar");
        request.setMethod("GET");
        request.addHeader("principal", (Object)"user1");
        response = new MockHttpServletResponse();
        chain = new MockFilterChain();
        this.getProxy().doFilter((ServletRequest)request, (ServletResponse)response, (FilterChain)chain);
        Assert.assertEquals((long)403L, (long)response.getStatus());
        Authentication auth2 = this.getAuth(testFilterName4, "user1", null, null);
        Assert.assertNull((Object)auth2);
        Assert.assertNull((Object)SecurityContextHolder.getContext().getAuthentication());
        this.updateUser("ug1", "user1", true);
        this.insertAnonymousFilter();
        request = this.createRequest("/foo/bar");
        request.setMethod("GET");
        response = new MockHttpServletResponse();
        chain = new MockFilterChain();
        this.getProxy().doFilter((ServletRequest)request, (ServletResponse)response, (FilterChain)chain);
        Assert.assertEquals((long)200L, (long)response.getStatus());
        this.removeAnonymousFilter();
    }

    @Test
    public void testDigestAuth() throws Exception {
        DigestAuthenticationFilterConfig config = new DigestAuthenticationFilterConfig();
        config.setClassName(GeoServerDigestAuthenticationFilter.class.getName());
        config.setName(testFilterName2);
        config.setUserGroupServiceName("ug1");
        this.getSecurityManager().saveFilter((SecurityNamedServiceConfig)config);
        this.prepareFilterChain(this.pattern, new String[]{testFilterName2});
        SecurityContextHolder.getContext().setAuthentication(null);
        MockHttpServletRequest request = this.createRequest("/foo/bar");
        request.setMethod("GET");
        MockHttpServletResponse response = new MockHttpServletResponse();
        MockFilterChain chain = new MockFilterChain();
        this.getProxy().doFilter((ServletRequest)request, (ServletResponse)response, (FilterChain)chain);
        Assert.assertEquals((long)401L, (long)response.getStatus());
        String tmp = response.getHeader("WWW-Authenticate");
        Assert.assertNotNull((Object)tmp);
        assert (tmp.contains("GeoServer Realm"));
        assert (tmp.contains("Digest"));
        Assert.assertNull((Object)SecurityContextHolder.getContext().getAuthentication());
        request = this.createRequest("/foo/bar");
        request.setMethod("GET");
        response = new MockHttpServletResponse();
        chain = new MockFilterChain();
        String headerValue = this.clientDigestString(tmp, "user1", "pw1", request.getMethod());
        request.addHeader("Authorization", (Object)headerValue);
        this.getProxy().doFilter((ServletRequest)request, (ServletResponse)response, (FilterChain)chain);
        Assert.assertEquals((long)200L, (long)response.getStatus());
        Authentication auth = this.getAuth(testFilterName2, "user1", 300, 300);
        Assert.assertNotNull((Object)auth);
        Assert.assertNull((Object)SecurityContextHolder.getContext().getAuthentication());
        this.checkForAuthenticatedRole(auth);
        Assert.assertEquals((Object)"user1", (Object)((UserDetails)auth.getPrincipal()).getUsername());
        Assert.assertTrue((boolean)auth.getAuthorities().contains(new GeoServerRole("RootRole")));
        Assert.assertTrue((boolean)auth.getAuthorities().contains(new GeoServerRole("DerivedRole")));
        request = this.createRequest("/foo/bar");
        request.setMethod("GET");
        response = new MockHttpServletResponse();
        chain = new MockFilterChain();
        headerValue = this.clientDigestString(tmp, "unknown", "pw1", request.getMethod());
        request.addHeader("Authorization", (Object)headerValue);
        this.getProxy().doFilter((ServletRequest)request, (ServletResponse)response, (FilterChain)chain);
        tmp = response.getHeader("WWW-Authenticate");
        Assert.assertNotNull((Object)tmp);
        assert (tmp.contains("GeoServer Realm"));
        assert (tmp.contains("Digest"));
        Assert.assertEquals((long)401L, (long)response.getStatus());
        auth = this.getAuth(testFilterName2, "unknown", 300, 300);
        Assert.assertNull((Object)auth);
        Assert.assertNull((Object)SecurityContextHolder.getContext().getAuthentication());
        request = this.createRequest("/foo/bar");
        request.setMethod("GET");
        response = new MockHttpServletResponse();
        chain = new MockFilterChain();
        MasterPasswordProviderConfig masterPasswordConfig = this.getSecurityManager().loadMasterPassswordProviderConfig(this.getSecurityManager().getMasterPasswordConfig().getProviderName());
        masterPasswordConfig.setLoginEnabled(true);
        this.getSecurityManager().saveMasterPasswordProviderConfig(masterPasswordConfig);
        headerValue = this.clientDigestString(tmp, "root", this.getMasterPassword(), request.getMethod());
        request.addHeader("Authorization", (Object)headerValue);
        this.getProxy().doFilter((ServletRequest)request, (ServletResponse)response, (FilterChain)chain);
        Assert.assertEquals((long)200L, (long)response.getStatus());
        auth = this.getAuth(testFilterName2, "root", 300, 300);
        Assert.assertNull((Object)auth);
        Assert.assertNull((Object)SecurityContextHolder.getContext().getAuthentication());
        request = this.createRequest("/foo/bar");
        request.setMethod("GET");
        response = new MockHttpServletResponse();
        chain = new MockFilterChain();
        headerValue = this.clientDigestString(tmp, "root", "geoserver1", request.getMethod());
        request.addHeader("Authorization", (Object)headerValue);
        this.getProxy().doFilter((ServletRequest)request, (ServletResponse)response, (FilterChain)chain);
        tmp = response.getHeader("WWW-Authenticate");
        Assert.assertNotNull((Object)tmp);
        assert (tmp.contains("GeoServer Realm"));
        assert (tmp.contains("Digest"));
        Assert.assertEquals((long)401L, (long)response.getStatus());
        auth = this.getAuth(testFilterName2, "root", 300, 300);
        Assert.assertNull((Object)auth);
        Assert.assertNull((Object)SecurityContextHolder.getContext().getAuthentication());
        this.updateUser("ug1", "user1", false);
        request = this.createRequest("/foo/bar");
        request.setMethod("GET");
        response = new MockHttpServletResponse();
        chain = new MockFilterChain();
        headerValue = this.clientDigestString(tmp, "user1", "pw1", request.getMethod());
        request.addHeader("Authorization", (Object)headerValue);
        this.getProxy().doFilter((ServletRequest)request, (ServletResponse)response, (FilterChain)chain);
        Assert.assertEquals((long)200L, (long)response.getStatus());
        auth = this.getAuth(testFilterName2, "user1", 300, 300);
        Assert.assertNotNull((Object)auth);
        Assert.assertNull((Object)SecurityContextHolder.getContext().getAuthentication());
        this.checkForAuthenticatedRole(auth);
        Assert.assertEquals((Object)"user1", (Object)((UserDetails)auth.getPrincipal()).getUsername());
        Assert.assertTrue((boolean)auth.getAuthorities().contains(new GeoServerRole("RootRole")));
        Assert.assertTrue((boolean)auth.getAuthorities().contains(new GeoServerRole("DerivedRole")));
        this.getCache().removeAll();
        request = this.createRequest("/foo/bar");
        request.setMethod("GET");
        response = new MockHttpServletResponse();
        chain = new MockFilterChain();
        headerValue = this.clientDigestString(tmp, "unknown", "pw1", request.getMethod());
        request.addHeader("Authorization", (Object)headerValue);
        this.getProxy().doFilter((ServletRequest)request, (ServletResponse)response, (FilterChain)chain);
        tmp = response.getHeader("WWW-Authenticate");
        Assert.assertNotNull((Object)tmp);
        assert (tmp.contains("GeoServer Realm"));
        assert (tmp.contains("Digest"));
        Assert.assertEquals((long)401L, (long)response.getStatus());
        auth = this.getAuth(testFilterName2, "user1", 300, 300);
        Assert.assertNull((Object)auth);
        Assert.assertNull((Object)SecurityContextHolder.getContext().getAuthentication());
        this.updateUser("ug1", "user1", true);
        this.insertAnonymousFilter();
        request = this.createRequest("/foo/bar");
        request.setMethod("GET");
        response = new MockHttpServletResponse();
        chain = new MockFilterChain();
        this.getProxy().doFilter((ServletRequest)request, (ServletResponse)response, (FilterChain)chain);
        Assert.assertEquals((long)200L, (long)response.getStatus());
        this.removeAnonymousFilter();
    }

    @Test
    public void testBasicAuthWithRememberMe() throws Exception {
        BasicAuthenticationFilterConfig config = new BasicAuthenticationFilterConfig();
        config.setClassName(GeoServerBasicAuthenticationFilter.class.getName());
        config.setUseRememberMe(true);
        config.setName(testFilterName5);
        this.getSecurityManager().saveFilter((SecurityNamedServiceConfig)config);
        this.prepareFilterChain(this.pattern, new String[]{testFilterName5, "rememberme"});
        SecurityContextHolder.getContext().setAuthentication(null);
        MockHttpServletRequest request = this.createRequest("/foo/bar");
        request.setMethod("GET");
        request.addParameter("_spring_security_remember_me", "yes");
        MockHttpServletResponse response = new MockHttpServletResponse();
        MockFilterChain chain = new MockFilterChain();
        this.getProxy().doFilter((ServletRequest)request, (ServletResponse)response, (FilterChain)chain);
        Assert.assertEquals((long)0L, (long)response.getCookies().length);
        String tmp = response.getHeader("WWW-Authenticate");
        Assert.assertNotNull((Object)tmp);
        request = this.createRequest("/foo/bar");
        request.setMethod("GET");
        request.addParameter("_spring_security_remember_me", "yes");
        response = new MockHttpServletResponse();
        chain = new MockFilterChain();
        request.addHeader("Authorization", (Object)("Basic " + Base64.encodeBytes((byte[])"abc@xyz.com:abc".getBytes())));
        this.getProxy().doFilter((ServletRequest)request, (ServletResponse)response, (FilterChain)chain);
        Assert.assertEquals((long)200L, (long)response.getStatus());
        Authentication auth = this.getAuth(testFilterName5, "abc@xyz.com", null, null);
        Assert.assertNotNull((Object)auth);
        Assert.assertNull((Object)SecurityContextHolder.getContext().getAuthentication());
        this.checkForAuthenticatedRole(auth);
        Assert.assertEquals((long)1L, (long)response.getCookies().length);
        Cookie cookie = response.getCookies()[0];
        request = this.createRequest("/foo/bar");
        request.setMethod("GET");
        request.addParameter("_spring_security_remember_me", "yes");
        request.setCookies(new Cookie[]{cookie});
        response = new MockHttpServletResponse();
        chain = new MockFilterChain();
        this.getProxy().doFilter((ServletRequest)request, (ServletResponse)response, (FilterChain)chain);
        Assert.assertEquals((long)200L, (long)response.getStatus());
        auth = this.getAuth(testFilterName5, "abc@xyz.com", null, null);
        Assert.assertNotNull((Object)auth);
        Assert.assertNull((Object)SecurityContextHolder.getContext().getAuthentication());
        this.checkForAuthenticatedRole(auth);
        Assert.assertEquals((Object)"abc@xyz.com", (Object)((UserDetails)auth.getPrincipal()).getUsername());
        request = this.createRequest("/foo/bar");
        request.setMethod("GET");
        request.addParameter("_spring_security_remember_me", "yes");
        request.setCookies(new Cookie[]{cookie});
        response = new MockHttpServletResponse();
        chain = new MockFilterChain();
        request.addHeader("Authorization", (Object)("Basic " + Base64.encodeBytes((byte[])"abc@xyz.com:abc".getBytes())));
        this.getProxy().doFilter((ServletRequest)request, (ServletResponse)response, (FilterChain)chain);
        Assert.assertEquals((long)200L, (long)response.getStatus());
        auth = this.getAuth(testFilterName5, "abc@xyz.com", null, null);
        Assert.assertNotNull((Object)auth);
        Assert.assertNull((Object)SecurityContextHolder.getContext().getAuthentication());
        this.checkForAuthenticatedRole(auth);
        Assert.assertEquals((Object)"abc@xyz.com", (Object)((UserDetails)auth.getPrincipal()).getUsername());
        request = this.createRequest("/foo/bar");
        request.setMethod("GET");
        request.addParameter("_spring_security_remember_me", "yes");
        response = new MockHttpServletResponse();
        chain = new MockFilterChain();
        request.addHeader("Authorization", (Object)("Basic " + Base64.encodeBytes((byte[])("root:" + this.getMasterPassword()).getBytes())));
        this.getProxy().doFilter((ServletRequest)request, (ServletResponse)response, (FilterChain)chain);
        Assert.assertEquals((long)401L, (long)response.getStatus());
        MasterPasswordProviderConfig masterPasswordConfig = this.getSecurityManager().loadMasterPassswordProviderConfig(this.getSecurityManager().getMasterPasswordConfig().getProviderName());
        masterPasswordConfig.setLoginEnabled(true);
        this.getSecurityManager().saveMasterPasswordProviderConfig(masterPasswordConfig);
        response = new MockHttpServletResponse();
        this.getProxy().doFilter((ServletRequest)request, (ServletResponse)response, (FilterChain)chain);
        Assert.assertEquals((long)200L, (long)response.getStatus());
        auth = this.getAuth(testFilterName5, "root", null, null);
        Assert.assertNull((Object)auth);
        Assert.assertNull((Object)SecurityContextHolder.getContext().getAuthentication());
        Assert.assertEquals((long)0L, (long)response.getCookies().length);
        this.updateUser("ug1", "abc@xyz.com", false);
        request = this.createRequest("/foo/bar");
        request.setMethod("GET");
        request.addParameter("_spring_security_remember_me", "yes");
        request.setCookies(new Cookie[]{cookie});
        response = new MockHttpServletResponse();
        chain = new MockFilterChain();
        this.getProxy().doFilter((ServletRequest)request, (ServletResponse)response, (FilterChain)chain);
        Assert.assertEquals((long)401L, (long)response.getStatus());
        Assert.assertEquals((long)1L, (long)response.getCookies().length);
        Cookie cancelCookie = response.getCookies()[0];
        Assert.assertNull((Object)cancelCookie.getValue());
        this.updateUser("ug1", "abc@xyz.com", true);
    }

    @Test
    public void testX509Auth() throws Exception {
        Authentication auth;
        X509CertificateAuthenticationFilterConfig config = new X509CertificateAuthenticationFilterConfig();
        config.setClassName(GeoServerX509CertificateAuthenticationFilter.class.getName());
        config.setName(testFilterName8);
        config.setRoleServiceName("rs1");
        config.setRoleSource((RoleSource)PreAuthenticatedUserNameFilterConfig.PreAuthenticatedUserNameRoleSource.RoleService);
        config.setUserGroupServiceName("ug1");
        config.setRolesHeaderAttribute("roles");
        this.getSecurityManager().saveFilter((SecurityNamedServiceConfig)config);
        this.prepareFilterChain(this.pattern, new String[]{testFilterName8});
        SecurityContextHolder.getContext().setAuthentication(null);
        MockHttpServletRequest request = this.createRequest("/foo/bar");
        request.setMethod("GET");
        MockHttpServletResponse response = new MockHttpServletResponse();
        MockFilterChain chain = new MockFilterChain();
        this.getProxy().doFilter((ServletRequest)request, (ServletResponse)response, (FilterChain)chain);
        Assert.assertEquals((long)403L, (long)response.getStatus());
        Assert.assertNull((Object)SecurityContextHolder.getContext().getAuthentication());
        for (PreAuthenticatedUserNameFilterConfig.PreAuthenticatedUserNameRoleSource rs : PreAuthenticatedUserNameFilterConfig.PreAuthenticatedUserNameRoleSource.values()) {
            this.getCache().removeAll();
            config.setRoleSource((RoleSource)rs);
            this.getSecurityManager().saveFilter((SecurityNamedServiceConfig)config);
            request = this.createRequest("/foo/bar");
            request.setMethod("GET");
            response = new MockHttpServletResponse();
            chain = new MockFilterChain();
            if (rs.equals((RoleSource)PreAuthenticatedUserNameFilterConfig.PreAuthenticatedUserNameRoleSource.Header)) {
                request.addHeader("roles", (Object)"DerivedRole;RootRole");
            }
            this.setCertifacteForUser("user1", request);
            this.getProxy().doFilter((ServletRequest)request, (ServletResponse)response, (FilterChain)chain);
            Assert.assertEquals((long)200L, (long)response.getStatus());
            if (rs.equals((RoleSource)PreAuthenticatedUserNameFilterConfig.PreAuthenticatedUserNameRoleSource.Header)) continue;
            auth = this.getAuth(testFilterName8, "user1", null, null);
            Assert.assertNotNull((Object)auth);
            Assert.assertNull((Object)SecurityContextHolder.getContext().getAuthentication());
            this.checkForAuthenticatedRole(auth);
            Assert.assertEquals((Object)"user1", (Object)auth.getPrincipal());
            Assert.assertTrue((boolean)auth.getAuthorities().contains(new GeoServerRole("RootRole")));
            Assert.assertTrue((boolean)auth.getAuthorities().contains(new GeoServerRole("DerivedRole")));
        }
        for (PreAuthenticatedUserNameFilterConfig.PreAuthenticatedUserNameRoleSource rs : PreAuthenticatedUserNameFilterConfig.PreAuthenticatedUserNameRoleSource.values()) {
            this.getCache().removeAll();
            config.setRoleSource((RoleSource)rs);
            this.getSecurityManager().saveFilter((SecurityNamedServiceConfig)config);
            config.setRoleSource((RoleSource)rs);
            request = this.createRequest("/foo/bar");
            request.setMethod("GET");
            response = new MockHttpServletResponse();
            chain = new MockFilterChain();
            this.setCertifacteForUser("unknown", request);
            this.getProxy().doFilter((ServletRequest)request, (ServletResponse)response, (FilterChain)chain);
            Assert.assertEquals((long)200L, (long)response.getStatus());
            if (rs.equals((RoleSource)PreAuthenticatedUserNameFilterConfig.PreAuthenticatedUserNameRoleSource.Header)) continue;
            auth = this.getAuth(testFilterName8, "unknown", null, null);
            Assert.assertNotNull((Object)auth);
            Assert.assertNull((Object)SecurityContextHolder.getContext().getAuthentication());
            this.checkForAuthenticatedRole(auth);
            Assert.assertEquals((Object)"unknown", (Object)auth.getPrincipal());
        }
        this.updateUser("ug1", "user1", false);
        config.setRoleSource((RoleSource)PreAuthenticatedUserNameFilterConfig.PreAuthenticatedUserNameRoleSource.UserGroupService);
        this.getSecurityManager().saveFilter((SecurityNamedServiceConfig)config);
        request = this.createRequest("/foo/bar");
        request.setMethod("GET");
        response = new MockHttpServletResponse();
        chain = new MockFilterChain();
        this.setCertifacteForUser("user1", request);
        this.getProxy().doFilter((ServletRequest)request, (ServletResponse)response, (FilterChain)chain);
        Assert.assertEquals((long)403L, (long)response.getStatus());
        Authentication auth2 = this.getAuth(testFilterName8, "user1", 0, 0);
        Assert.assertNull((Object)auth2);
        Assert.assertNull((Object)SecurityContextHolder.getContext().getAuthentication());
        this.updateUser("ug1", "user1", true);
        this.insertAnonymousFilter();
        request = this.createRequest("/foo/bar");
        request.setMethod("GET");
        response = new MockHttpServletResponse();
        chain = new MockFilterChain();
        this.getProxy().doFilter((ServletRequest)request, (ServletResponse)response, (FilterChain)chain);
        Assert.assertEquals((long)200L, (long)response.getStatus());
        this.removeAnonymousFilter();
    }

    @Test
    @RunTestSetup
    public void testCascadingFilters() throws Exception {
        DigestAuthenticationFilterConfig config = new DigestAuthenticationFilterConfig();
        config.setClassName(GeoServerDigestAuthenticationFilter.class.getName());
        config.setName(testFilterName2);
        config.setUserGroupServiceName("ug1");
        this.getSecurityManager().saveFilter((SecurityNamedServiceConfig)config);
        this.prepareFilterChain(this.pattern, new String[]{testFilterName, testFilterName2});
        SecurityContextHolder.getContext().setAuthentication(null);
        MockHttpServletRequest request = this.createRequest("/foo/bar");
        request.setMethod("GET");
        MockHttpServletResponse response = new MockHttpServletResponse();
        MockFilterChain chain = new MockFilterChain();
        this.getProxy().doFilter((ServletRequest)request, (ServletResponse)response, (FilterChain)chain);
        Assert.assertEquals((long)401L, (long)response.getStatus());
        String tmp = response.getHeader("WWW-Authenticate");
        Assert.assertNotNull((Object)tmp);
        assert (tmp.contains("GeoServer Realm"));
        assert (tmp.contains("Digest"));
        Assert.assertNull((Object)SecurityContextHolder.getContext().getAuthentication());
        request = this.createRequest("/foo/bar");
        request.setMethod("GET");
        response = new MockHttpServletResponse();
        chain = new MockFilterChain();
        String headerValue = this.clientDigestString(tmp, "user1", "pw1", request.getMethod());
        request.addHeader("Authorization", (Object)headerValue);
        this.getProxy().doFilter((ServletRequest)request, (ServletResponse)response, (FilterChain)chain);
        Assert.assertEquals((long)200L, (long)response.getStatus());
        Authentication auth = this.getAuth(testFilterName2, "user1", 300, 300);
        Assert.assertNotNull((Object)auth);
        Assert.assertNull((Object)SecurityContextHolder.getContext().getAuthentication());
        this.checkForAuthenticatedRole(auth);
        Assert.assertEquals((Object)"user1", (Object)((UserDetails)auth.getPrincipal()).getUsername());
        Assert.assertTrue((boolean)auth.getAuthorities().contains(new GeoServerRole("RootRole")));
        Assert.assertTrue((boolean)auth.getAuthorities().contains(new GeoServerRole("DerivedRole")));
        request = this.createRequest("/foo/bar");
        request.setMethod("GET");
        response = new MockHttpServletResponse();
        chain = new MockFilterChain();
        request.addHeader("Authorization", (Object)("Basic " + Base64.encodeBytes((byte[])"user1:pw1".getBytes())));
        this.getProxy().doFilter((ServletRequest)request, (ServletResponse)response, (FilterChain)chain);
        Assert.assertEquals((long)200L, (long)response.getStatus());
        auth = this.getAuth(testFilterName, "user1", null, null);
        Assert.assertNotNull((Object)auth);
        Assert.assertNull((Object)SecurityContextHolder.getContext().getAuthentication());
        this.checkForAuthenticatedRole(auth);
        Assert.assertEquals((Object)"user1", (Object)((UserDetails)auth.getPrincipal()).getUsername());
        Assert.assertTrue((boolean)auth.getAuthorities().contains(new GeoServerRole("RootRole")));
        Assert.assertTrue((boolean)auth.getAuthorities().contains(new GeoServerRole("DerivedRole")));
    }
}

