/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.security;

import javax.servlet.http.HttpServletRequest;
import org.geoserver.security.GeoServerRequestMatcher;
import org.geoserver.security.GeoServerSecurityFilterChainProxy;
import org.geoserver.security.HTTPMethod;
import org.geoserver.security.RequestFilterChain;
import org.geoserver.security.ServiceLoginFilterChain;
import org.geoserver.test.GeoServerMockTestSupport;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.springframework.mock.web.MockHttpServletRequest;

public class GeoserverRequestMatcherTest
extends GeoServerMockTestSupport {
    GeoServerSecurityFilterChainProxy proxy;

    @Before
    public void setUp() {
        this.proxy = new GeoServerSecurityFilterChainProxy(this.getSecurityManager());
    }

    @Test
    public void testMacher() {
        ServiceLoginFilterChain chain = new ServiceLoginFilterChain(new String[]{"/**"});
        GeoServerRequestMatcher matcher = this.proxy.matcherForChain((RequestFilterChain)chain);
        Assert.assertTrue((boolean)matcher.matches((HttpServletRequest)this.createRequest(HTTPMethod.GET, "/wms")));
        chain = new ServiceLoginFilterChain(new String[]{"/**"});
        chain.getHttpMethods().add(HTTPMethod.GET);
        chain.getHttpMethods().add(HTTPMethod.POST);
        matcher = this.proxy.matcherForChain((RequestFilterChain)chain);
        Assert.assertTrue((boolean)matcher.matches((HttpServletRequest)this.createRequest(HTTPMethod.GET, "/wms")));
        Assert.assertTrue((boolean)matcher.matches((HttpServletRequest)this.createRequest(HTTPMethod.POST, "/wms")));
        Assert.assertTrue((boolean)matcher.matches((HttpServletRequest)this.createRequest(HTTPMethod.PUT, "/wms")));
        chain.setMatchHTTPMethod(true);
        matcher = this.proxy.matcherForChain((RequestFilterChain)chain);
        Assert.assertTrue((boolean)matcher.matches((HttpServletRequest)this.createRequest(HTTPMethod.GET, "/wms")));
        Assert.assertTrue((boolean)matcher.matches((HttpServletRequest)this.createRequest(HTTPMethod.POST, "/wms")));
        Assert.assertFalse((boolean)matcher.matches((HttpServletRequest)this.createRequest(HTTPMethod.PUT, "/wms")));
        chain = new ServiceLoginFilterChain(new String[]{"/wfs/**,/web/**"});
        matcher = this.proxy.matcherForChain((RequestFilterChain)chain);
        Assert.assertFalse((boolean)matcher.matches((HttpServletRequest)this.createRequest(HTTPMethod.GET, "/wms/abc")));
        Assert.assertTrue((boolean)matcher.matches((HttpServletRequest)this.createRequest(HTTPMethod.GET, "/wfs/acc")));
        Assert.assertTrue((boolean)matcher.matches((HttpServletRequest)this.createRequest(HTTPMethod.GET, "/web/abc")));
        chain.getHttpMethods().add(HTTPMethod.GET);
        chain.getHttpMethods().add(HTTPMethod.POST);
        matcher = this.proxy.matcherForChain((RequestFilterChain)chain);
        Assert.assertFalse((boolean)matcher.matches((HttpServletRequest)this.createRequest(HTTPMethod.GET, "/wms/abc")));
        Assert.assertTrue((boolean)matcher.matches((HttpServletRequest)this.createRequest(HTTPMethod.POST, "/wfs/acc")));
        Assert.assertTrue((boolean)matcher.matches((HttpServletRequest)this.createRequest(HTTPMethod.PUT, "/web/abc")));
        chain.setMatchHTTPMethod(true);
        matcher = this.proxy.matcherForChain((RequestFilterChain)chain);
        Assert.assertFalse((boolean)matcher.matches((HttpServletRequest)this.createRequest(HTTPMethod.GET, "/wms/abc")));
        Assert.assertTrue((boolean)matcher.matches((HttpServletRequest)this.createRequest(HTTPMethod.POST, "/wfs/acc")));
        Assert.assertFalse((boolean)matcher.matches((HttpServletRequest)this.createRequest(HTTPMethod.PUT, "/web/abc")));
    }

    @Test
    public void testMacherWithQueryString() {
        ServiceLoginFilterChain chain = new ServiceLoginFilterChain(new String[]{"/wms/**|.*request=getcapabilities.*"});
        GeoServerRequestMatcher matcher = this.proxy.matcherForChain((RequestFilterChain)chain);
        Assert.assertFalse((boolean)matcher.matches((HttpServletRequest)this.createRequest(HTTPMethod.GET, "/wms")));
        Assert.assertTrue((boolean)matcher.matches((HttpServletRequest)this.createRequest(HTTPMethod.GET, "/wms?service=WMS&version=1.1.1&request=GetCapabilities")));
        Assert.assertFalse((boolean)matcher.matches((HttpServletRequest)this.createRequest(HTTPMethod.GET, "/wms?service=WMS&version=1.1.1&request=GetMap")));
        chain = new ServiceLoginFilterChain(new String[]{"/wms/**|(?=.*request=getmap)(?=.*format=image/png).*"});
        matcher = this.proxy.matcherForChain((RequestFilterChain)chain);
        Assert.assertTrue((boolean)matcher.matches((HttpServletRequest)this.createRequest(HTTPMethod.GET, "/wms?service=WMS&version=1.1.1&request=GetMap&format=image/png")));
        Assert.assertTrue((boolean)matcher.matches((HttpServletRequest)this.createRequest(HTTPMethod.GET, "/wms?service=WMS&version=1.1.1&format=image/png&request=GetMap")));
        Assert.assertFalse((boolean)matcher.matches((HttpServletRequest)this.createRequest(HTTPMethod.GET, "/wms?service=WMS&version=1.1.1&format=image/jpg&request=GetMap")));
        chain = new ServiceLoginFilterChain(new String[]{"/wms/**|(?=.*request=getmap)(?!.*format=image/png).*"});
        matcher = this.proxy.matcherForChain((RequestFilterChain)chain);
        Assert.assertTrue((boolean)matcher.matches((HttpServletRequest)this.createRequest(HTTPMethod.GET, "/wms?service=WMS&version=1.1.1&format=image/jpg&request=GetMap")));
        Assert.assertFalse((boolean)matcher.matches((HttpServletRequest)this.createRequest(HTTPMethod.GET, "/wms?service=WMS&version=1.1.1&format=image/png&request=GetMap")));
    }

    MockHttpServletRequest createRequest(HTTPMethod method, String pathInfo) {
        MockHttpServletRequest request = new MockHttpServletRequest();
        request.setServletPath("");
        String queryString = null;
        if (pathInfo.indexOf("?") != -1) {
            queryString = pathInfo.substring(pathInfo.indexOf("?") + 1);
            pathInfo = pathInfo.substring(0, pathInfo.indexOf("?"));
        }
        request.setPathInfo(pathInfo);
        if (queryString != null) {
            request.setQueryString(queryString);
        }
        request.setMethod(method.toString());
        return request;
    }
}

